/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import harmonised.pmmo.util.XP;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;

public class ServerUtil {
    private static boolean serverSide = false;
    private static MinecraftServer server;
    private static final Map<ResourceLocation, ServerLevel> worlds;
    private static long overworldTime;
    public static ServerLevel overworld;
    public static ServerLevel nether;
    public static ServerLevel end;

    public static void init(MinecraftServer server) {
        serverSide = true;
        ServerUtil.server = server;
        worlds.clear();
        for (ServerLevel world : server.m_129785_()) {
            worlds.put(XP.getDimResLoc((Level)world), world);
        }
        overworld = ServerUtil.getWorld(ServerLevel.f_46428_.m_135782_());
        nether = ServerUtil.getWorld(ServerLevel.f_46429_.m_135782_());
        end = ServerUtil.getWorld(ServerLevel.f_46430_.m_135782_());
    }

    public static void tick(TickEvent.WorldTickEvent event) {
        overworldTime = event.world.m_46467_();
    }

    public static long getGameTime() {
        return overworldTime;
    }

    public static List<ServerPlayer> getPlayers() {
        return server == null ? Collections.emptyList() : server.m_6846_().m_11314_();
    }

    public static ServerLevel getWorld(ResourceLocation dimResLoc) {
        return worlds.get(dimResLoc);
    }

    public static void sendMsgToAll(Component msg, ChatType type) {
        ServerUtil.sendMsg(server.m_6846_().m_11314_(), msg, type);
    }

    public static void sendMsg(Collection<ServerPlayer> players, Component msg, ChatType type) {
        for (ServerPlayer player : players) {
            player.m_9146_(msg, type, player.m_142081_());
        }
    }

    static {
        worlds = new HashMap<ResourceLocation, ServerLevel>();
        overworldTime = 0L;
    }
}

