/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DrawUtil {
    public static Set<BlockPos> getCircle(int r) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        int x = 0;
        int d = 1 - r;
        int y = r;
        do {
            posSet.add(new BlockPos(x, 0, y));
            posSet.add(new BlockPos(x, 0, -y));
            posSet.add(new BlockPos(-x, 0, y));
            posSet.add(new BlockPos(-x, 0, -y));
            posSet.add(new BlockPos(y, 0, x));
            posSet.add(new BlockPos(y, 0, -x));
            posSet.add(new BlockPos(-y, 0, x));
            posSet.add(new BlockPos(-y, 0, -x));
            ++x;
            if (d < 0) {
                d += 2 * x + 2;
                continue;
            }
            d += 2 * (x - --y) + 1;
        } while (x < y);
        posSet.add(new BlockPos(x, 0, y));
        posSet.add(new BlockPos(x, 0, -y));
        posSet.add(new BlockPos(-x, 0, y));
        posSet.add(new BlockPos(-x, 0, -y));
        return posSet;
    }

    public static Set<BlockPos> getCircleSolid(int r) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        List<Integer> lengths = DrawUtil.getCircleLengths(r);
        int line = 0;
        for (int length : lengths) {
            for (int z = 0; z <= length; ++z) {
                posSet.add(new BlockPos(line, 0, z));
                posSet.add(new BlockPos(line, 0, -z));
                posSet.add(new BlockPos(-line, 0, z));
                posSet.add(new BlockPos(-line, 0, -z));
                posSet.add(new BlockPos(z, 0, line));
                posSet.add(new BlockPos(z, 0, -line));
                posSet.add(new BlockPos(-z, 0, line));
                posSet.add(new BlockPos(-z, 0, -line));
            }
            ++line;
        }
        return posSet;
    }

    public static Set<BlockPos> getSphereSolid(int r) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        int i = 0;
        List<Integer> sphereRadii = DrawUtil.getSphereRadii(r);
        System.out.println(sphereRadii);
        for (int radius : sphereRadii) {
            for (BlockPos pos : DrawUtil.getCircleSolid(radius)) {
                posSet.add(pos.m_6625_(r - i));
            }
            ++i;
        }
        return posSet;
    }

    public static List<Integer> getSphereRadii(int r) {
        int y;
        ArrayList<Integer> fourthRadii = new ArrayList<Integer>();
        ArrayList<Integer> allY = new ArrayList<Integer>();
        int x = 0;
        int d = 1 - r;
        int oldY = y = r;
        boolean corner = false;
        do {
            d = d < 0 ? (d += 2 * x + 2) : (d += 2 * (++x - --y) + 1);
            if (y != oldY) {
                fourthRadii.add(x - 1);
            }
            oldY = y;
            if (x == y) {
                corner = true;
                continue;
            }
            allY.add(y);
        } while (x < y);
        if (corner) {
            fourthRadii.add(++x);
        }
        List reversedAllY = Lists.reverse(allY);
        reversedAllY.add((Integer)reversedAllY.get(reversedAllY.size() - 1));
        fourthRadii.addAll(reversedAllY);
        return fourthRadii;
    }

    public static List<Integer> getCircleLengths(int r) {
        ArrayList<Integer> halfLengths = new ArrayList<Integer>();
        int x = 0;
        int d = 1 - r;
        int y = r;
        do {
            halfLengths.add(y);
            ++x;
            if (d < 0) {
                d += 2 * x + 2;
                continue;
            }
            d += 2 * (x - --y) + 1;
        } while (x < y);
        return halfLengths;
    }

    public static void drawToWorld(Level world, BlockPos offset, Set<BlockPos> posSet, BlockState state) {
        for (BlockPos pos : posSet) {
            world.m_46597_(new BlockPos(offset.m_123341_() + pos.m_123341_(), offset.m_123342_() + pos.m_123342_(), offset.m_123343_() + pos.m_123343_()), state);
        }
    }

    public static void drawToWorld(Level world, BlockPos offset, Set<BlockPos> posSet, BlockState state, Direction direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                DrawUtil.drawToWorld(world, offset, posSet, state);
                break;
            }
            case EAST: 
            case WEST: {
                break;
            }
        }
    }
}

