/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class CheeseTracker {
    private static final Map<UUID, Integer> playersLookCheeseCount = new HashMap<UUID, Integer>();
    private static final Map<UUID, Double> playersLastLookVecs = new HashMap<UUID, Double>();

    public static void trackCheese(ServerPlayer player) {
        UUID uuid = player.m_142081_();
        Vec3 playerLookVec = player.m_20154_();
        double currLookVec = playerLookVec.f_82479_ + playerLookVec.f_82480_ + playerLookVec.f_82481_;
        double cheeseMaxStorage = Config.forgeConfig.cheeseMaxStorage.get().intValue();
        if (!playersLookCheeseCount.containsKey(uuid)) {
            playersLookCheeseCount.put(uuid, 0);
            playersLastLookVecs.put(uuid, currLookVec);
        }
        int lookVecCheese = playersLookCheeseCount.get(uuid);
        double lazyMultiplier = CheeseTracker.getLazyMultiplier(uuid);
        if (playersLastLookVecs.get(uuid) != currLookVec) {
            playersLookCheeseCount.put(uuid, Math.max(0, lookVecCheese - Config.forgeConfig.activityCheeseReplenishSpeed.get()));
            if (lazyMultiplier != 1.0) {
                player.m_5661_((Component)new TranslatableComponent("pmmo.afkMultiplierRestored", new Object[]{DP.dpSoft(CheeseTracker.getLazyMultiplier(uuid) * 100.0)}).m_6270_(XP.getColorStyle(65280)), true);
            }
        } else {
            playersLookCheeseCount.put(uuid, (int)Math.min(cheeseMaxStorage, Math.min(cheeseMaxStorage, (double)(lookVecCheese + 1))));
            if (lazyMultiplier < Config.forgeConfig.sendPlayerCheeseWarningBelowMultiplier.get()) {
                player.m_5661_((Component)new TranslatableComponent("pmmo.afkMultiplierWarning", new Object[]{DP.dpSoft(CheeseTracker.getLazyMultiplier(uuid) * 100.0)}).m_6270_(XP.getColorStyle(0xFF0000)), true);
            }
        }
        playersLastLookVecs.put(uuid, currLookVec);
    }

    public static double getLazyMultiplier(UUID uuid, String skill) {
        if (JsonConfig.localData.get((Object)JType.SKILLS).containsKey(skill) && JsonConfig.localData.get((Object)JType.SKILLS).get(skill).getOrDefault("noAfkPenalty", 0.0) != 0.0) {
            return 1.0;
        }
        return CheeseTracker.getLazyMultiplier(uuid);
    }

    public static double getLazyMultiplier(UUID uuid) {
        if (!playersLookCheeseCount.containsKey(uuid)) {
            return 1.0;
        }
        int playerCheese = playersLookCheeseCount.get(uuid);
        return Util.mapCapped(playerCheese - Config.forgeConfig.freeCheese.get(), 0.0, Config.forgeConfig.cheeseMaxStorage.get() - Config.forgeConfig.freeCheese.get(), 1.0, Config.forgeConfig.minimumCheeseXpMultiplier.get());
    }
}

