/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.perks;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import org.apache.commons.lang3.function.TriFunction;

public class EffectPerks {
    private static final String COOLDOWN = "cooldown";
    private static final String DURATION = "duration";
    private static final String STRENGTH = "per_level";
    private static final String MIN_LEVEL = "min_level";
    private static final CompoundTag EMPTY = new CompoundTag();
    private static Map<UUID, Long> regen_cooldown = new HashMap<UUID, Long>();
    public static TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> NIGHT_VISION = (player, nbt, level) -> {
        int duration;
        int min = nbt.m_128441_(MIN_LEVEL) ? nbt.m_128451_(MIN_LEVEL) : 50;
        int n = duration = nbt.m_128441_(DURATION) ? nbt.m_128451_(DURATION) : 100;
        if (level < min) {
            return EMPTY;
        }
        if (!player.m_21023_(MobEffects.f_19611_) || player.m_21124_(MobEffects.f_19611_).m_19557_() <= 80) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, duration, 0, true, false, false));
        }
        return EMPTY;
    };
    public static TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> REGEN = (player, nbt, level) -> {
        long cooldown = nbt.m_128441_(COOLDOWN) ? nbt.m_128454_(COOLDOWN) : 300L;
        int duration = nbt.m_128441_(DURATION) ? nbt.m_128451_(DURATION) : 1;
        double strength = nbt.m_128441_(STRENGTH) ? nbt.m_128459_(STRENGTH) : 0.02;
        int perLevel = Math.max(0, (int)((double)level.intValue() * strength));
        long currentCD = regen_cooldown.getOrDefault(player.m_142081_(), System.currentTimeMillis());
        if (currentCD < System.currentTimeMillis() - cooldown || currentCD + 20L >= System.currentTimeMillis()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration, perLevel));
            regen_cooldown.put(player.m_142081_(), System.currentTimeMillis());
        }
        return EMPTY;
    };
}

