/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.party;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.party.PartyMemberInfo;
import harmonised.pmmo.util.XP;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class Party {
    private final long creationDate;
    private final Set<PartyMemberInfo> membersInfo;

    public Party(long creationDate, Set<PartyMemberInfo> members) {
        this.creationDate = creationDate;
        this.membersInfo = members;
    }

    public int getPartySize() {
        return this.membersInfo.size();
    }

    public PartyMemberInfo getMemberInfo(UUID uuid) {
        PartyMemberInfo info = null;
        for (PartyMemberInfo memberInfo : this.membersInfo) {
            if (!memberInfo.uuid.equals(uuid)) continue;
            info = memberInfo;
            break;
        }
        return info;
    }

    public void addMember(UUID uuid) {
        this.membersInfo.add(new PartyMemberInfo(uuid, System.currentTimeMillis(), 0.0));
    }

    public boolean removeMember(UUID uuid) {
        PartyMemberInfo memberInfo = this.getMemberInfo(uuid);
        if (memberInfo == null) {
            return false;
        }
        this.membersInfo.remove(memberInfo);
        return true;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public Set<PartyMemberInfo> getAllMembersInfo() {
        return this.membersInfo;
    }

    public Set<ServerPlayer> getOnlineMembers(MinecraftServer server) {
        HashSet<ServerPlayer> onlineMembers = new HashSet<ServerPlayer>();
        for (ServerPlayer onlinePlayer : server.m_6846_().m_11314_()) {
            if (this.getMemberInfo(onlinePlayer.m_142081_()) == null) continue;
            onlineMembers.add(onlinePlayer);
        }
        return onlineMembers;
    }

    public Set<ServerPlayer> getOnlineMembersInRange(ServerPlayer originPlayer) {
        Set<ServerPlayer> membersInRange = XP.getEntitiesInRange(originPlayer.m_20182_(), this.getOnlineMembers(originPlayer.m_20194_()), Config.forgeConfig.partyRange.get());
        membersInRange.remove(originPlayer);
        for (ServerPlayer memberInRange : new HashSet<ServerPlayer>(membersInRange)) {
            if (XP.isPlayerSurvival((Player)memberInRange)) continue;
            membersInRange.remove(memberInRange);
        }
        return membersInRange;
    }

    public int getMembersCount() {
        return this.membersInfo.size();
    }

    public Set<PartyMemberInfo> getMembersInfo(Set<ServerPlayer> membersInRange) {
        HashSet<PartyMemberInfo> onlineMembersInfo = new HashSet<PartyMemberInfo>();
        for (ServerPlayer player : membersInRange) {
            onlineMembersInfo.add(this.getMemberInfo(player.m_142081_()));
        }
        return onlineMembersInfo;
    }

    public double getTotalXpGained() {
        double totalXpGained = 0.0;
        for (PartyMemberInfo memberInfo : this.membersInfo) {
            totalXpGained += memberInfo.xpGained;
        }
        return totalXpGained;
    }

    public double getMultiplier(int membersInRange) {
        return 1.0 + Math.min((double)membersInRange * Config.forgeConfig.partyXpIncreasePerPlayer.get() / 100.0, Config.forgeConfig.maxPartyXpBonus.get() / 100.0);
    }

    public void submitXpGained(UUID uuid, double xpGained) {
        PartyMemberInfo memberInfo = this.getMemberInfo(uuid);
        if (memberInfo != null) {
            memberInfo.xpGained += xpGained;
        }
    }

    public static int getMaxPartyMembers() {
        return Config.forgeConfig.partyMaxMembers.get();
    }
}

