/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.util.XP;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class MessageTripleTranslation {
    private String tKey;
    private String fKey;
    private String sKey;
    private String rdKey;
    private boolean bar;
    private int color;

    public MessageTripleTranslation(String tKey, String fKey, String sKey, String rdKey, boolean bar, int color) {
        this.tKey = tKey;
        this.fKey = fKey;
        this.sKey = sKey;
        this.rdKey = rdKey;
        this.bar = bar;
        this.color = color;
    }

    public MessageTripleTranslation(ResourceLocation tKey, ResourceLocation fKey, ResourceLocation sKey, ResourceLocation rdKey, boolean bar, int color) {
        this.tKey = tKey.toString();
        this.fKey = fKey.toString();
        this.sKey = sKey.toString();
        this.rdKey = rdKey.toString();
        this.bar = bar;
        this.color = color;
    }

    MessageTripleTranslation() {
    }

    public static MessageTripleTranslation decode(FriendlyByteBuf buf) {
        MessageTripleTranslation packet = new MessageTripleTranslation();
        packet.tKey = buf.m_130277_();
        packet.fKey = buf.m_130277_();
        packet.sKey = buf.m_130277_();
        packet.rdKey = buf.m_130277_();
        packet.bar = buf.readBoolean();
        packet.color = buf.readInt();
        return packet;
    }

    public static void encode(MessageTripleTranslation packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.tKey);
        buf.m_130070_(packet.fKey);
        buf.m_130070_(packet.sKey);
        buf.m_130070_(packet.rdKey);
        buf.writeBoolean(packet.bar);
        buf.writeInt(packet.color);
    }

    public static void handlePacket(MessageTripleTranslation packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            switch (packet.color) {
                case 0: {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent(packet.tKey, new Object[]{new TranslatableComponent(packet.fKey), new TranslatableComponent(packet.sKey), new TranslatableComponent(packet.rdKey)}), packet.bar);
                    break;
                }
                case 1: {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent(packet.tKey, new Object[]{new TranslatableComponent(packet.fKey), new TranslatableComponent(packet.sKey), new TranslatableComponent(packet.rdKey)}).m_6270_(XP.textStyle.get("green")), packet.bar);
                    break;
                }
                case 2: {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent(packet.tKey, new Object[]{new TranslatableComponent(packet.fKey), new TranslatableComponent(packet.sKey), new TranslatableComponent(packet.rdKey)}).m_6270_(XP.textStyle.get("red")), packet.bar);
                    break;
                }
                case 3: {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent(packet.tKey, new Object[]{new TranslatableComponent(packet.fKey), new TranslatableComponent(packet.sKey), new TranslatableComponent(packet.rdKey)}).m_6270_(XP.textStyle.get("yellow")), packet.bar);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

