/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.skills.Skill;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class WorldXpDrop {
    public static float worldXpDropsRotationCap = (float)(0.0 + Config.forgeConfig.worldXpDropsRotationCap.get());
    private final ResourceLocation worldResLoc;
    private final Vec3 pos;
    private final String skill;
    private final int color;
    private float rotation;
    private float size = 1.0f;
    private float decaySpeed = 1.0f;
    public float xp;
    public float startXp;

    public static WorldXpDrop fromXYZ(ResourceLocation worldResLoc, double x, double y, double z, double maxOffset, double xp, String skill) {
        return WorldXpDrop.fromXYZ(worldResLoc, x, y, z, maxOffset, (float)xp, skill);
    }

    public static WorldXpDrop fromXYZ(ResourceLocation worldResLoc, double x, double y, double z, double maxOffset, float xp, String skill) {
        return new WorldXpDrop(worldResLoc, new Vec3(x + Math.random() * maxOffset * 2.0 - maxOffset, y + Math.random() * maxOffset * 2.0 - maxOffset, z + Math.random() * maxOffset * 2.0 - maxOffset), xp, skill);
    }

    public static WorldXpDrop fromVector(ResourceLocation worldResLoc, Vec3 pos, double maxOffset, double xp, String skill) {
        return WorldXpDrop.fromVector(worldResLoc, pos, maxOffset, (float)xp, skill);
    }

    public static WorldXpDrop fromVector(ResourceLocation worldResLoc, Vec3 pos, double maxOffset, float xp, String skill) {
        return new WorldXpDrop(worldResLoc, maxOffset == 0.0 ? pos : new Vec3(pos.m_7096_() + Math.random() * maxOffset * 2.0 - maxOffset, pos.m_7098_() + Math.random() * maxOffset * 2.0 - maxOffset, pos.m_7094_() + Math.random() * maxOffset * 2.0 - maxOffset), xp, skill);
    }

    public static WorldXpDrop fromBlockPos(ResourceLocation worldResLoc, BlockPos pos, double maxOffset, double xp, String skill) {
        return WorldXpDrop.fromBlockPos(worldResLoc, pos, maxOffset, (float)xp, skill);
    }

    public static WorldXpDrop fromBlockPos(ResourceLocation worldResLoc, BlockPos pos, double maxOffset, float xp, String skill) {
        return new WorldXpDrop(worldResLoc, new Vec3((double)pos.m_123341_() + 0.5 + Math.random() * maxOffset * 2.0 - maxOffset, (double)pos.m_123342_() + 0.5 + Math.random() * maxOffset * 2.0 - maxOffset, (double)pos.m_123343_() + 0.5 + Math.random() * maxOffset * 2.0 - maxOffset), xp, skill);
    }

    private WorldXpDrop(ResourceLocation worldResLoc, Vec3 pos, float xp, String skill) {
        this.worldResLoc = worldResLoc;
        this.pos = pos;
        this.xp = this.startXp = xp;
        this.skill = skill;
        this.color = Skill.getSkillColor(skill);
        this.rotation = WorldXpDrop.getRandomRotation();
    }

    private static float getRandomRotation() {
        return (float)(Math.random() * (double)worldXpDropsRotationCap * 2.0 - (double)worldXpDropsRotationCap);
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public String getSkill() {
        return this.skill;
    }

    public int getColor() {
        return this.color;
    }

    public float getStartXp() {
        return this.startXp;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public float getDecaySpeed() {
        return this.decaySpeed;
    }

    public void setDecaySpeed(double decaySpeed) {
        this.decaySpeed = (float)decaySpeed;
    }

    public void setDecaySpeed(float decaySpeed) {
        this.decaySpeed = decaySpeed;
    }

    public ResourceLocation getWorldResLoc() {
        return this.worldResLoc;
    }
}

