/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.Util;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class WorldText {
    private static Map<PresetTextOption, CompoundTag> presetTextOptions = new HashMap<PresetTextOption, CompoundTag>();
    public static float worldXpDropsSizeMultiplier = (float)(0.0 + Config.forgeConfig.worldXpDropsSizeMultiplier.get());
    public static float worldXpDropsDecaySpeedMultiplier = (float)(0.0 + Config.forgeConfig.worldXpDropsDecaySpeedMultiplier.get());
    public static boolean worldXpDropsShowSkill = Config.forgeConfig.worldXpDropsShowSkill.get();
    private ResourceLocation worldResLoc;
    private Vec3 startPos;
    private Vec3 endPos;
    private String text = "EMPTY";
    private float secondsLifespan = 1.0f;
    private float maxOffset = 0.0f;
    private byte preset = 0;
    private float age = 0.0f;
    private float spanRatio;
    private boolean hueColor = false;
    private int color = 0xFFFFFF;
    private float startHue = 0.0f;
    private float startSaturation = 1.0f;
    private float startBrightness = 1.0f;
    private float endHue = 360.0f;
    private float endSaturation = 1.0f;
    private float endBrightness = 1.0f;
    private boolean showValue = false;
    private float startValue = 0.0f;
    private float endValue = 0.0f;
    private float valueDecaySpeed = 1.0f;
    private boolean decayByValue = false;
    private float value = 0.0f;
    private float startSize = 1.0f;
    private float endSize = 0.0f;
    private float startRot = 0.0f;
    private float endRot = 0.0f;

    public static WorldText fromBlockPos(ResourceLocation worldResLoc, BlockPos pos) {
        return WorldText.fromBlockPos(worldResLoc, pos, pos);
    }

    public static WorldText fromBlockPos(ResourceLocation worldResLoc, BlockPos startPos, BlockPos endPos) {
        return new WorldText(worldResLoc, new Vec3((double)startPos.m_123341_() + 0.5, (double)startPos.m_123342_() + 0.5, (double)startPos.m_123343_() + 0.5), new Vec3((double)endPos.m_123341_() + 0.5, (double)endPos.m_123342_() + 0.5, (double)endPos.m_123343_() + 0.5));
    }

    public static WorldText fromVector(ResourceLocation worldResLoc, Vec3 pos) {
        return WorldText.fromVector(worldResLoc, pos, pos);
    }

    public static WorldText fromVector(ResourceLocation worldResLoc, Vec3 startPos, Vec3 endPos) {
        return new WorldText(worldResLoc, startPos, endPos);
    }

    private WorldText(ResourceLocation worldResLoc, Vec3 startPos, Vec3 endPos) {
        this.worldResLoc = worldResLoc;
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public boolean tick(double d) {
        if (this.decayByValue) {
            this.value = (float)((double)this.value - Math.max(0.01523, (double)(this.value * this.valueDecaySpeed * worldXpDropsDecaySpeedMultiplier) * d));
            this.spanRatio = (float)Util.map(this.value, this.startValue, this.endValue, 1.0, 0.0);
        } else {
            this.age = (float)((double)this.age + d);
            this.spanRatio = 1.0f - this.age / this.secondsLifespan;
        }
        return this.spanRatio > 0.0f;
    }

    public ResourceLocation getWorldResLoc() {
        return this.worldResLoc;
    }

    public Vec3 getStartPos() {
        return this.startPos;
    }

    public Vec3 getEndPos() {
        return this.endPos;
    }

    public Vec3 getPos() {
        return new Vec3(Util.map(this.spanRatio, 1.0, 0.0, this.startPos.m_7096_(), this.endPos.m_7096_()), Util.map(this.spanRatio, 1.0, 0.0, this.startPos.m_7098_(), this.endPos.m_7098_()), Util.map(this.spanRatio, 1.0, 0.0, this.startPos.m_7094_(), this.endPos.m_7094_()));
    }

    public String getText() {
        if (this.showValue) {
            return "+" + DP.dpSoft(this.value) + " " + this.text;
        }
        return this.text;
    }

    public double getSize() {
        return Util.map(this.spanRatio, 1.0, 0.0, this.startSize, this.endSize) * (double)worldXpDropsSizeMultiplier * 0.02;
    }

    public float getRotation() {
        return (float)Util.map(this.spanRatio, 1.0, 0.0, this.startRot, this.endRot);
    }

    public int getColor() {
        if (this.hueColor) {
            return Util.hueToRGB((float)Util.map(this.spanRatio, 1.0, 0.0, this.startHue, this.endHue) % 360.0f, (float)Util.mapCapped(this.spanRatio, 0.0, 1.0, this.endSaturation, this.startSaturation), (float)Util.mapCapped(this.spanRatio, 0.0, 1.0, this.endBrightness, this.startBrightness));
        }
        return this.color;
    }

    public static void init() {
        CompoundTag blockBreakPreset = new CompoundTag();
        blockBreakPreset.m_128350_("maxOffset", 0.25f);
        blockBreakPreset.m_128350_("valueDecaySpeed", 1.25f);
        blockBreakPreset.m_128379_("showValue", true);
        blockBreakPreset.m_128379_("decayByValue", true);
        presetTextOptions.put(PresetTextOption.BLOCK_BREAK, blockBreakPreset);
    }

    public void setText(String text) {
        this.text = text;
    }

    public float getSecondsLifespan() {
        return this.secondsLifespan;
    }

    public void setSecondsLifespan(float secondsLifespan) {
        this.secondsLifespan = secondsLifespan;
    }

    public float getMaxOffset() {
        return this.maxOffset;
    }

    public void setMaxOffset(float maxOffset) {
        this.maxOffset = maxOffset;
    }

    public void updatePos() {
        double xOffset = Math.random() * (double)this.maxOffset * 2.0 - (double)this.maxOffset;
        double yOffset = Math.random() * (double)this.maxOffset * 2.0 - (double)this.maxOffset;
        double zOffset = Math.random() * (double)this.maxOffset * 2.0 - (double)this.maxOffset;
        this.startPos = this.maxOffset == 0.0f ? this.startPos : new Vec3(this.startPos.m_7096_() + xOffset, this.startPos.m_7098_() + yOffset, this.startPos.m_7094_() + zOffset);
        this.endPos = this.maxOffset == 0.0f ? this.endPos : new Vec3(this.endPos.m_7096_() + xOffset, this.endPos.m_7098_() + yOffset, this.endPos.m_7094_() + zOffset);
    }

    public byte getPreset() {
        return this.preset;
    }

    public void setPreset(byte preset) {
        this.preset = preset;
    }

    public float getAge() {
        return this.age;
    }

    public void setAge(float age) {
        this.age = age;
    }

    public float getSpanRatio() {
        return this.spanRatio;
    }

    public void setSpanRatio(float spanRatio) {
        this.spanRatio = spanRatio;
    }

    public boolean isHueColor() {
        return this.hueColor;
    }

    public void setHueColor(boolean hueColor) {
        this.hueColor = hueColor;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public float getStartHue() {
        return this.startHue;
    }

    public void setStartHue(float startHue) {
        this.startHue = startHue;
    }

    public float getStartSaturation() {
        return this.startSaturation;
    }

    public void setStartSaturation(float startSaturation) {
        this.startSaturation = startSaturation;
    }

    public float getStartBrightness() {
        return this.startBrightness;
    }

    public void setStartBrightness(float startBrightness) {
        this.startBrightness = startBrightness;
    }

    public float getEndHue() {
        return this.endHue;
    }

    public void setEndHue(float endHue) {
        this.endHue = endHue;
    }

    public float getEndSaturation() {
        return this.endSaturation;
    }

    public void setEndSaturation(float endSaturation) {
        this.endSaturation = endSaturation;
    }

    public float getEndBrightness() {
        return this.endBrightness;
    }

    public void setEndBrightness(float endBrightness) {
        this.endBrightness = endBrightness;
    }

    public boolean isShowValue() {
        return this.showValue;
    }

    public void setShowValue(boolean showValue) {
        this.showValue = showValue;
    }

    public float getStartValue() {
        return this.startValue;
    }

    public void setStartValue(float startValue) {
        this.startValue = startValue;
    }

    public float getEndValue() {
        return this.endValue;
    }

    public void setEndValue(float endValue) {
        this.endValue = endValue;
    }

    public float getValueDecaySpeed() {
        return this.valueDecaySpeed;
    }

    public void setValueDecaySpeed(float valueDecaySpeed) {
        this.valueDecaySpeed = valueDecaySpeed;
    }

    public boolean isDecayByValue() {
        return this.decayByValue;
    }

    public void setDecayByValue(boolean decayByValue) {
        this.decayByValue = decayByValue;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getStartSize() {
        return this.startSize;
    }

    public void setStartSize(float startSize) {
        this.startSize = startSize;
    }

    public float getEndSize() {
        return this.endSize;
    }

    public void setEndSize(float endSize) {
        this.endSize = endSize;
    }

    public float getStartRot() {
        return this.startRot;
    }

    public void setStartRot(float startRot) {
        this.startRot = startRot;
    }

    public float getEndRot() {
        return this.endRot;
    }

    public void setEndRot(float endRot) {
        this.endRot = endRot;
    }

    public void setPos(Vec3 pos) {
        this.startPos = pos;
        this.endPos = pos;
    }

    public void setPos(Vec3 startPos, Vec3 endPos) {
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public static enum PresetTextOption {
        BLOCK_BREAK(1),
        BLOCK_PLACE(2);

        private static Map<Byte, PresetTextOption> options;
        private final byte value;

        private PresetTextOption(byte value) {
            this.value = value;
        }

        public CompoundTag getPresetOptions() {
            return presetTextOptions.get((Object)this);
        }

        public byte getValue() {
            return this.value;
        }

        public static PresetTextOption getPresetOption(byte type) {
            return options.get(type);
        }

        static {
            options = new HashMap<Byte, PresetTextOption>();
            for (PresetTextOption presetTextOption : PresetTextOption.values()) {
                options.put(presetTextOption.value, presetTextOption);
            }
        }
    }
}

