/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.ListButton;
import harmonised.pmmo.gui.PmmoScreen;
import harmonised.pmmo.skills.Skill;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.ScrollPanel;
import org.lwjgl.opengl.GL11;

public class ListScrollPanel
extends ScrollPanel {
    Player player;
    JType jType;
    private final int boxWidth = 256;
    private final int boxHeight = 256;
    private ArrayList<ListButton> buttons;
    private final Minecraft client;
    private final int width;
    private final int height;
    private final int top;
    private final int bottom;
    private final int right;
    private final int left;
    private final int barLeft;
    private final int border = 4;
    private final int barWidth = 6;
    int accumulativeHeight;

    public ListScrollPanel(Minecraft client, int width, int height, int top, int left, JType jType, Player player, ArrayList<ListButton> buttons) {
        super(client, width, height, top, left);
        this.player = player;
        this.jType = jType;
        this.buttons = buttons;
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = height + this.top;
        this.right = width + this.left;
        this.barLeft = this.left + this.width - 6;
    }

    public void setButtons(ArrayList<ListButton> buttons) {
        this.buttons = buttons;
    }

    protected int getContentHeight() {
        int height = 0;
        for (ListButton a : this.buttons) {
            height += a.m_93694_() + 4;
        }
        return height;
    }

    protected void drawPanel(PoseStack stack, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        this.accumulativeHeight = 0;
        for (int i = 0; i < this.buttons.size(); ++i) {
            ListButton button = this.buttons.get(i);
            button.f_93620_ = this.right - button.m_5711_() - 8;
            button.f_93621_ = relativeY + this.accumulativeHeight;
            if (button.f_93621_ + button.m_93694_() + 2 > this.top && button.f_93621_ - 2 < this.bottom) {
                int color;
                if (button.unlocked) {
                    this.m_93179_(stack, this.left + 4, button.f_93621_ - 2, this.right - 2, button.f_93621_ + button.m_93694_() + 2, 0x22444444, 0x33222222);
                } else {
                    this.m_93179_(stack, this.left + 4, button.f_93621_ - 2, this.right - 2, button.f_93621_ + button.m_93694_() + 2, -1438366652, -1440603614);
                }
                button.m_6305_(stack, mouseX, mouseY, 0.0f);
                int n = color = button.unlocked ? 5569620 : 16536660;
                if (this.jType.equals((Object)JType.SKILLS) && (color = Skill.getSkillColor(button.regKey)) == 0xFFFFFF) {
                    color = 5569620;
                }
                if (this.jType.equals((Object)JType.HISCORE)) {
                    ListScrollPanel.m_93236_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (String)(i + 1 + "."), (int)(this.left + 178), (int)(button.f_93621_ + 2), (int)color);
                } else if (this.jType.equals((Object)JType.SKILLS) && i > 0) {
                    ListScrollPanel.m_93236_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (String)(i + "."), (int)(this.left + 178), (int)(button.f_93621_ + 2), (int)color);
                }
                ListScrollPanel.m_93236_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (String)button.title, (int)(this.left + 6), (int)(button.f_93621_ + 2), (int)color);
                int j = 0;
                for (Component line : button.text) {
                    ListScrollPanel.m_93236_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (String)line.getString(), (int)(this.left + 6), (int)(button.f_93621_ + 11 + j++ * 9), (int)(line.m_7383_().m_131135_() == null ? 0xFFFFFF : line.m_7383_().m_131135_().m_131265_()));
                }
            }
            this.accumulativeHeight += button.m_93694_() + 4;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public int getScroll() {
        return (int)this.scrollDistance;
    }

    public void setScroll(int scroll) {
        this.scrollDistance = scroll;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRelativeY() {
        return this.top + this.border - (int)this.scrollDistance;
    }

    private int getMaxScroll() {
        return this.getContentHeight() - (this.height - this.border);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder worldr = tess.m_85915_();
        double scale = this.client.m_91268_().m_85449_();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.client.m_91268_().m_85442_() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        int baseY = this.top + 4 - (int)this.scrollDistance;
        this.drawPanel(stack, this.right, baseY, tess, mouseX, mouseY);
        RenderSystem.m_69465_();
        int extraHeight = this.getContentHeight() + 4 - this.height;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            RenderSystem.m_69472_();
            worldr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            worldr.m_5483_((double)this.barLeft, (double)this.bottom, 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6), (double)this.bottom, 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6), (double)this.top, 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            worldr.m_5483_((double)this.barLeft, (double)this.top, 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            tess.m_85914_();
            worldr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            worldr.m_5483_((double)this.barLeft, (double)(barTop + barHeight), 0.0).m_7421_(0.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).m_7421_(1.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6), (double)barTop, 0.0).m_7421_(1.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            worldr.m_5483_((double)this.barLeft, (double)barTop, 0.0).m_7421_(0.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            tess.m_85914_();
            worldr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            worldr.m_5483_((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(192, 192, 192, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(192, 192, 192, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).m_7421_(1.0f, 0.0f).m_6122_(192, 192, 192, 255).m_5752_();
            worldr.m_5483_((double)this.barLeft, (double)barTop, 0.0).m_7421_(0.0f, 0.0f).m_6122_(192, 192, 192, 255).m_5752_();
            tess.m_85914_();
        }
        RenderSystem.m_69493_();
        PmmoScreen.enableAlpha(1.0f);
        RenderSystem.m_69461_();
        GL11.glDisable((int)3089);
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - 8) {
            barHeight = this.height - 8;
        }
        return barHeight;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return null;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }
}

