/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.BlockBrokenHandler;
import harmonised.pmmo.events.FishedHandler;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.gui.ListButton;
import harmonised.pmmo.gui.ListScrollPanel;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.PmmoScreen;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ListScreen
extends PmmoScreen {
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private static final Style greenColor = XP.textStyle.get("green");
    private static Button exitButton;
    private int x;
    private int y;
    private int scrollX;
    private int scrollY;
    private int buttonX;
    private int buttonY;
    private int accumulativeHeight;
    private int buttonsSize;
    private int buttonsLoaded;
    private int futureHeight;
    private int minCount;
    private int maxCount;
    private ListScrollPanel scrollPanel;
    private EditBox filterTextField;
    private String filterText = "";
    private final Player player;
    private final JType jType;
    private final double baseXp = Config.getConfig("baseXp");
    private ArrayList<ListButton> listButtons = new ArrayList();
    private ArrayList<ListButton> activeListButtons = new ArrayList();
    private UUID uuid;
    private Component title;
    private String type;

    public ListScreen(UUID uuid, Component titleIn, String type, JType jType, Player player) {
        super(titleIn);
        this.title = titleIn;
        this.player = player;
        this.jType = jType;
        this.uuid = uuid;
        this.type = type;
    }

    public void m_7856_() {
        ArrayList<String> keyWords = new ArrayList<String>();
        keyWords.add("helmet");
        keyWords.add("chestplate");
        keyWords.add("leggings");
        keyWords.add("boots");
        keyWords.add("pickaxe");
        keyWords.add("axe");
        keyWords.add("shovel");
        keyWords.add("hoe");
        keyWords.add("sword");
        this.x = this.sr.m_85445_() / 2 - this.boxWidth / 2;
        this.y = this.sr.m_85446_() / 2 - this.boxHeight / 2;
        this.scrollX = this.x + 16;
        this.scrollY = this.y + 10;
        this.buttonX = this.scrollX + 4;
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "", JType.NONE, button -> {
            switch (this.jType) {
                case SKILLS: 
                case HISCORE: 
                case STATS: {
                    Minecraft.m_91087_().m_91152_((Screen)new MainScreen(this.uuid, (Component)ListScreen.getTransComp("pmmo.potato", new Object[0])));
                    break;
                }
                default: {
                    Minecraft.m_91087_().m_91152_((Screen)new GlossaryScreen(this.uuid, (Component)ListScreen.getTransComp("pmmo.skills", new Object[0]), false));
                }
            }
        });
        Map reqMap = JsonConfig.data.get((Object)this.jType);
        Map<String, Map<String, Map<String, Double>>> reqMap2 = JsonConfig.data2.get((Object)this.jType);
        ArrayList<ListButton> tempList = new ArrayList<ListButton>();
        this.listButtons = new ArrayList();
        switch (this.jType) {
            case REQ_BIOME: {
                Map<String, Map<String, Double>> bonusMap = JsonConfig.data.get((Object)JType.XP_BONUS_BIOME);
                Map<String, Map<String, Double>> map = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER);
                ArrayList<String> biomesToAdd = new ArrayList<String>();
                if (reqMap != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                        if (biomesToAdd.contains(entry.getKey())) continue;
                        biomesToAdd.add(entry.getKey());
                    }
                }
                if (bonusMap != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : bonusMap.entrySet()) {
                        if (biomesToAdd.contains(entry.getKey())) continue;
                        biomesToAdd.add(entry.getKey());
                    }
                }
                if (map != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : map.entrySet()) {
                        if (biomesToAdd.contains(entry.getKey())) continue;
                        biomesToAdd.add(entry.getKey());
                    }
                }
                biomesToAdd.sort(Comparator.comparingInt(b -> ListScreen.getReqCount(b, JType.REQ_BIOME)));
                for (String string : biomesToAdd) {
                    if (ForgeRegistries.BIOMES.getValue(XP.getResLoc(string)) == null) continue;
                    tempList.add(new ListButton(0, 0, 3, 8, string, this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case DIMENSION: {
                Map<String, Map<String, Double>> veinBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST);
                if (veinBlacklist == null) break;
                if (veinBlacklist.containsKey("all_dimensions")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "all_dimensions", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                if (veinBlacklist.containsKey("minecraft:overworld")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "minecraft:overworld", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                if (veinBlacklist.containsKey("minecraft:the_nether")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "minecraft:the_nether", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                if (!veinBlacklist.containsKey("minecraft:the_end")) break;
                tempList.add(new ListButton(0, 0, 3, 8, "minecraft:the_end", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                break;
            }
            case REQ_KILL: {
                Iterator<Map.Entry<String, Map<String, Double>>> killXpMap = JsonConfig.data.get((Object)JType.XP_VALUE_KILL);
                Map<String, Map<String, Double>> map = JsonConfig.data.get((Object)JType.MOB_RARE_DROP);
                Iterator<Object> mobsToAdd = new ArrayList();
                if (reqMap != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                        if (((ArrayList)((Object)mobsToAdd)).contains(entry.getKey())) continue;
                        ((ArrayList)((Object)mobsToAdd)).add(entry.getKey());
                    }
                }
                if (killXpMap != null) {
                    for (Map.Entry entry : killXpMap.entrySet()) {
                        if (((ArrayList)((Object)mobsToAdd)).contains(entry.getKey())) continue;
                        ((ArrayList)((Object)mobsToAdd)).add((String)entry.getKey());
                    }
                }
                if (map != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : map.entrySet()) {
                        if (((ArrayList)((Object)mobsToAdd)).contains(entry.getKey())) continue;
                        ((ArrayList)((Object)mobsToAdd)).add(entry.getKey());
                    }
                }
                Iterator iterator = ((ArrayList)((Object)mobsToAdd)).iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (!ForgeRegistries.ENTITIES.containsKey(XP.getResLoc(string))) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, string, this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case XP_VALUE_BREED: 
            case XP_VALUE_TAME: {
                if (reqMap == null) break;
                for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                    if (!ForgeRegistries.ENTITIES.containsKey(XP.getResLoc(entry.getKey()))) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case FISH_ENCHANT_POOL: {
                if (reqMap == null) break;
                for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                    if (!ForgeRegistries.ENCHANTMENTS.containsKey(XP.getResLoc(entry.getKey()))) continue;
                    tempList.add(new ListButton(0, 0, 3, 25, entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case SKILLS: {
                Set<String> skills = XP.getOfflineXpMap(this.uuid).keySet();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                tempList.add(new ListButton(0, 0, 3, 6, "totalLevel", this.jType, "", button -> ((ListButton)button).clickActionSkills()));
                for (String string : skills) {
                    arrayList.add((Object)new ListButton(0, 0, 3, 6, string, this.jType, "", button -> ((ListButton)button).clickActionSkills()));
                }
                arrayList.sort(Comparator.comparingDouble(b -> XP.getOfflineXp(((ListButton)((Object)((Object)((Object)b)))).regKey, this.uuid)).reversed());
                tempList.addAll(arrayList);
                break;
            }
            case HISCORE: {
                Iterator<Object> theSkill = this.type;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Map.Entry entry : XP.playerNames.entrySet()) {
                    arrayList.add((Object)new ListButton(0, 0, 3, 6, (String)entry.getValue(), this.jType, "", button -> ((ListButton)button).clickActionSkills()));
                }
                if (this.type.equals("totalLevel")) {
                    arrayList.sort(Comparator.comparingDouble(b -> XP.getTotalLevelFromMap(XP.getOfflineXpMap(XP.playerUUIDs.get(((ListButton)((Object)((Object)((Object)b)))).regKey)))).reversed());
                } else {
                    arrayList.sort(Comparator.comparingDouble(b -> XP.getOfflineXp(theSkill, XP.playerUUIDs.get(((ListButton)((Object)((Object)((Object)b)))).regKey))).reversed());
                }
                tempList.addAll(arrayList);
                break;
            }
            case SALVAGE: 
            case SALVAGE_FROM: 
            case TREASURE: 
            case TREASURE_FROM: {
                if (reqMap2 == null) break;
                for (Map.Entry<String, Map<String, Object>> entry : reqMap2.entrySet()) {
                    tempList.add(new ListButton(0, 0, 3, 0, entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            default: {
                if (reqMap == null) {
                    return;
                }
                for (Map.Entry<String, Map<String, Object>> entry : reqMap.entrySet()) {
                    if (XP.getItem(entry.getKey()) == Items.f_41852_) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
            }
        }
        for (String string : keyWords) {
            for (ListButton listButton : tempList) {
                if (!listButton.regKey.contains(string) || this.listButtons.contains((Object)listButton)) continue;
                this.listButtons.add(listButton);
            }
        }
        for (ListButton listButton : tempList) {
            if (this.listButtons.contains((Object)listButton)) continue;
            this.listButtons.add(listButton);
        }
        for (ListButton listButton : tempList) {
            if (!JsonConfig.levelJTypes.contains((Object)this.jType) || Util.mapIsAnyAbove1String(reqMap, listButton.regKey)) continue;
            this.listButtons.remove((Object)listButton);
        }
        block76: for (ListButton listButton : this.listButtons) {
            ArrayList<Object> skillText = new ArrayList<Object>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList<Object> positiveEffectText = new ArrayList<Object>();
            switch (this.jType) {
                case DIMENSION: {
                    Map<String, Map<String, Double>> veinBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST);
                    Map<String, Double> dimensionBonusMap = JsonConfig.data.get((Object)JType.XP_BONUS_DIMENSION).get(listButton.regKey);
                    if (veinBlacklist != null) {
                        listButton.text.add((Component)new TextComponent(""));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.veinBlacklist", new Object[0]).m_6270_(XP.textStyle.get("red")));
                        for (Map.Entry<String, Double> entry : veinBlacklist.get(listButton.regKey).entrySet()) {
                            listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp(XP.getItem(entry.getKey()).m_5524_(), new Object[0]).getString()).m_6270_(XP.textStyle.get("red")));
                        }
                    }
                    if (dimensionBonusMap == null) break;
                    for (Map.Entry<String, Double> entry : dimensionBonusMap.entrySet()) {
                        if (entry.getValue() > 0.0) {
                            skillText.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), "+" + entry.getValue() + "%").getString()).m_6270_(Skill.getSkillStyle(entry.getKey())));
                        }
                        if (!(entry.getValue() < 0.0)) continue;
                        skillText.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), entry.getValue() + "%").getString()).m_6270_(Skill.getSkillStyle(entry.getKey())));
                    }
                    break;
                }
                case REQ_BIOME: {
                    Potion effect;
                    listButton.text.add((Component)new TextComponent(""));
                    if (reqMap.containsKey(listButton.regKey)) {
                        ListScreen.addLevelsToButton(listButton, reqMap.get(listButton.regKey), this.player, false);
                    }
                    Map<String, Double> biomeBonusMap = JsonConfig.data.get((Object)JType.XP_BONUS_BIOME).get(listButton.regKey);
                    Map<String, Double> biomeMobMultiplierMap = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER).get(listButton.regKey);
                    Map<String, Double> biomeNegativeEffectsMap = JsonConfig.data.get((Object)JType.BIOME_EFFECT_NEGATIVE).get(listButton.regKey);
                    Map<String, Double> biomePositiveEffectsMap = JsonConfig.data.get((Object)JType.BIOME_EFFECT_POSITIVE).get(listButton.regKey);
                    if (biomeBonusMap != null) {
                        for (Map.Entry<String, Double> entry : biomeBonusMap.entrySet()) {
                            if (entry.getValue() > 0.0) {
                                skillText.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), "+" + entry.getValue() + "%").getString()).m_6270_(Skill.getSkillStyle(entry.getKey())));
                            }
                            if (!(entry.getValue() < 0.0)) continue;
                            skillText.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), entry.getValue() + "%").getString()).m_6270_(Skill.getSkillStyle(entry.getKey())));
                        }
                    }
                    if (biomeMobMultiplierMap != null) {
                        for (Map.Entry<String, Double> entry : biomeMobMultiplierMap.entrySet()) {
                            Style styleColor = Style.f_131099_;
                            if (entry.getValue() > 1.0) {
                                styleColor = XP.textStyle.get("red");
                            } else if (entry.getValue() < 1.0) {
                                styleColor = XP.textStyle.get("green");
                            }
                            switch (entry.getKey()) {
                                case "damageBonus": {
                                    arrayList.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.enemyScaleDamage", DP.dp(entry.getValue() * 100.0)).getString()).m_6270_(styleColor));
                                    break;
                                }
                                case "hpBonus": {
                                    arrayList.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.enemyScaleHp", DP.dp(entry.getValue() * 100.0)).getString()).m_6270_(styleColor));
                                    break;
                                }
                                case "speedBonus": {
                                    arrayList.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.enemyScaleSpeed", DP.dp(entry.getValue() * 100.0)).getString()).m_6270_(styleColor));
                                }
                            }
                        }
                    }
                    if (biomeNegativeEffectsMap != null) {
                        for (Map.Entry<String, Double> entry : biomeNegativeEffectsMap.entrySet()) {
                            if (!ForgeRegistries.POTIONS.containsKey(XP.getResLoc(entry.getKey())) || (effect = (Potion)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()))) == null) continue;
                            arrayList2.add(new TextComponent(" " + ListScreen.getTransComp(effect.getRegistryName().toString() + " " + (int)(entry.getValue() + 1.0), new Object[0]).getString()).m_6270_(XP.textStyle.get("red")));
                        }
                    }
                    if (biomePositiveEffectsMap == null) break;
                    for (Map.Entry<String, Double> entry : biomePositiveEffectsMap.entrySet()) {
                        if (!ForgeRegistries.POTIONS.containsKey(XP.getResLoc(entry.getKey())) || (effect = (Potion)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()))) == null) continue;
                        positiveEffectText.add(new TextComponent(" " + ListScreen.getTransComp(effect.getRegistryName().toString() + " " + (int)(entry.getValue() + 1.0), new Object[0]).getString()).m_6270_(XP.textStyle.get("green")));
                    }
                    break;
                }
                case INFO_ORE: 
                case INFO_LOG: 
                case INFO_PLANT: 
                case INFO_SMELT: 
                case INFO_COOK: 
                case INFO_BREW: {
                    listButton.text.add((Component)new TextComponent(""));
                    Map<String, Double> breakMap = JsonConfig.data.get((Object)JType.REQ_BREAK).get(listButton.regKey);
                    Map<String, Double> infoMap = XP.getJsonMap(listButton.regKey, this.jType);
                    ArrayList<MutableComponent> infoText = new ArrayList<MutableComponent>();
                    String transKey = "pmmo." + this.jType.toString().replace("info_", "") + "ExtraDrop";
                    if (!infoMap.containsKey("extraChance")) continue block76;
                    double extraDroppedPerLevel = infoMap.get("extraChance") / 100.0;
                    double extraDropped = XP.getExtraChance(this.player.m_142081_(), listButton.regKey, this.jType, true) / 100.0;
                    if (extraDropped <= 0.0) {
                        infoText.add(ListScreen.getTransComp(transKey, DP.dp(extraDropped)).m_6270_(XP.textStyle.get("red")));
                    } else {
                        infoText.add(ListScreen.getTransComp(transKey, DP.dp(extraDropped)).m_6270_(XP.textStyle.get("green")));
                    }
                    if (extraDroppedPerLevel <= 0.0) {
                        infoText.add(ListScreen.getTransComp("pmmo.extraPerLevel", DP.dpCustom(extraDroppedPerLevel, 4)).m_6270_(XP.textStyle.get("red")));
                    } else {
                        infoText.add(ListScreen.getTransComp("pmmo.extraPerLevel", DP.dpCustom(extraDroppedPerLevel, 4)).m_6270_(XP.textStyle.get("green")));
                    }
                    if (infoText.size() > 0) {
                        listButton.text.addAll(infoText);
                    }
                    if (breakMap == null || !this.jType.equals((Object)JType.INFO_ORE) && !this.jType.equals((Object)JType.INFO_LOG) && !this.jType.equals((Object)JType.INFO_PLANT)) break;
                    if (XP.checkReq(this.player, listButton.regKey, JType.REQ_BREAK)) {
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.break", new Object[0]).m_6270_(XP.textStyle.get("green")));
                    } else {
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.break", new Object[0]).m_6270_(XP.textStyle.get("red")));
                    }
                    ListScreen.addLevelsToButton(listButton, breakMap, this.player, false);
                    break;
                }
                case XP_BONUS_WORN: {
                    listButton.text.add((Component)new TextComponent(""));
                    ListScreen.addPercentageToButton(listButton, reqMap.get(listButton.regKey), XP.checkReq(this.player, listButton.regKey, JType.REQ_WEAR));
                    break;
                }
                case XP_BONUS_HELD: {
                    listButton.text.add((Component)new TextComponent(""));
                    ListScreen.addPercentageToButton(listButton, reqMap.get(listButton.regKey), true);
                    break;
                }
                case XP_VALUE_BREED: 
                case XP_VALUE_TAME: 
                case XP_VALUE_SMELT: 
                case XP_VALUE_COOK: 
                case XP_VALUE_BREW: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey));
                    break;
                }
                case XP_VALUE_BREAK: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey), JType.REQ_BREAK, this.player);
                    break;
                }
                case XP_VALUE_CRAFT: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey), JType.REQ_CRAFT, this.player);
                    break;
                }
                case XP_VALUE_GROW: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey), JType.REQ_PLACE, this.player);
                    break;
                }
                case FISH_ENCHANT_POOL: {
                    double curChance;
                    Map enchantMap = reqMap.get(listButton.regKey);
                    double fishLevel = Skill.getLevelDecimal(Skill.FISHING.toString(), this.player);
                    double levelReq = enchantMap.get("levelReq");
                    double chancePerLevel = enchantMap.get("chancePerLevel");
                    double maxChance = enchantMap.get("maxChance");
                    double maxLevel = (int)enchantMap.get("maxLevel").doubleValue();
                    double levelsPerTier = enchantMap.get("levelPerLevel");
                    double maxLevelAvailable = levelsPerTier == 0.0 ? maxLevel : Math.floor((fishLevel - levelReq) / levelsPerTier);
                    if (maxLevelAvailable < 0.0) {
                        maxLevelAvailable = 0.0;
                    }
                    if (maxLevelAvailable > maxLevel) {
                        maxLevelAvailable = maxLevel;
                    }
                    if ((curChance = (fishLevel - levelReq) * chancePerLevel) > maxChance) {
                        curChance = maxChance;
                    }
                    if (curChance < 0.0) {
                        curChance = 0.0;
                    }
                    listButton.unlocked = maxLevelAvailable > 0.0;
                    Style color = XP.textStyle.get(listButton.unlocked ? "green" : "red");
                    listButton.text.add((Component)new TextComponent(""));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.currentChance", DP.dpSoft(curChance)).getString()).m_6270_(color));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.startLevel", DP.dpSoft(levelReq)).getString()).m_6270_(color));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.maxEnchantLevel", (int)maxLevelAvailable).getString()).m_6270_(color));
                    listButton.text.add((Component)new TextComponent(""));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.chancePerLevel", DP.dpSoft(chancePerLevel)).getString()));
                    if (maxLevel > 1.0) {
                        listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.levelsPerTier", DP.dpSoft(levelsPerTier)).getString()));
                    }
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.maxEnchantLevel", (int)maxLevel).getString()));
                    break;
                }
                case REQ_KILL: {
                    Map<String, Double> killXpMap = JsonConfig.data.get((Object)JType.XP_VALUE_KILL).get(listButton.regKey);
                    Map<String, Double> rareDropMap = JsonConfig.data.get((Object)JType.MOB_RARE_DROP).get(listButton.regKey);
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, this.jType);
                    Style color = XP.textStyle.get(listButton.unlocked ? "green" : "red");
                    if (reqMap.containsKey(listButton.regKey)) {
                        listButton.text.add((Component)new TextComponent(""));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.toHarm", new Object[0]).m_6270_(color));
                        ListScreen.addLevelsToButton(listButton, reqMap.get(listButton.regKey), this.player, false);
                    }
                    listButton.text.add((Component)new TextComponent(""));
                    listButton.text.add((Component)ListScreen.getTransComp("pmmo.xpValue", new Object[0]).m_6270_(color));
                    if (killXpMap != null) {
                        ListScreen.addXpToButton(listButton, killXpMap, this.jType, this.player);
                    } else if (listButton.entity instanceof Animal) {
                        listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.hunter", new Object[0]), DP.dpSoft(Config.forgeConfig.passiveMobHunterXp.get())).getString()).m_6270_(color));
                    } else if (listButton.entity instanceof Mob) {
                        listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.slayer", new Object[0]), DP.dpSoft(Config.forgeConfig.aggresiveMobSlayerXp.get())).getString()).m_6270_(color));
                    }
                    if (rareDropMap == null) break;
                    listButton.text.add((Component)new TextComponent(""));
                    listButton.text.add((Component)ListScreen.getTransComp("pmmo.rareDrops", new Object[0]).m_6270_(color));
                    for (Map.Entry<String, Double> entry : rareDropMap.entrySet()) {
                        listButton.text.add((Component)new TextComponent(ListScreen.getTransComp(XP.getItem(entry.getKey()).m_5524_(), new Object[0]).getString() + ": " + ListScreen.getTransComp("pmmo.dropChance", DP.dpSoft(entry.getValue())).getString()).m_6270_(color));
                    }
                    break;
                }
                case FISH_POOL: {
                    Map<String, Double> fishPoolMap = reqMap.get(listButton.regKey);
                    double level = Skill.getLevelDecimal(Skill.FISHING.toString(), this.player);
                    double weight = FishedHandler.getFishPoolWeight(level, fishPoolMap);
                    double chance = weight / FishedHandler.getTotalFishPoolWeight(level);
                    listButton.unlocked = weight > 0.0;
                    Style color = XP.textStyle.get(listButton.unlocked ? "green" : "red");
                    this.minCount = (int)fishPoolMap.get("minCount").doubleValue();
                    this.maxCount = (int)fishPoolMap.get("maxCount").doubleValue();
                    listButton.text.add((Component)new TextComponent(""));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.currentWeight", DP.dpSoft(weight)).getString()).m_6270_(color));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.currentChance", DP.dpCustom(chance, 5)).getString()).m_6270_(color));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.dropChance", DP.dpSoft(1.0 / chance)).getString()).m_6270_(color));
                    if (this.minCount == this.maxCount) {
                        listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.caughtAmount", this.minCount).getString()).m_6270_(color));
                    } else {
                        listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.caughtAmountRange", this.minCount, this.maxCount).getString()).m_6270_(color));
                    }
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.xpEach", DP.dpSoft(fishPoolMap.get("xp"))).getString()).m_6270_(color));
                    if (listButton.itemStack.m_41792_()) {
                        if (fishPoolMap.get("enchantLevelReq") <= level && listButton.unlocked) {
                            listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.enchantLevelReq", DP.dpSoft(fishPoolMap.get("enchantLevelReq"))).getString()).m_6270_(XP.textStyle.get("green")));
                        } else {
                            listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.enchantLevelReq", DP.dpSoft(fishPoolMap.get("enchantLevelReq"))).getString()).m_6270_(XP.textStyle.get("red")));
                        }
                    }
                    listButton.text.add((Component)new TextComponent(""));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.startWeight", DP.dpSoft(fishPoolMap.get("startWeight"))).getString()));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.startLevel", DP.dpSoft(fishPoolMap.get("startLevel"))).getString()));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.endWeight", DP.dpSoft(fishPoolMap.get("endWeight"))).getString()));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.endLevel", DP.dpSoft(fishPoolMap.get("endLevel"))).getString()));
                    break;
                }
                case REQ_WEAR: 
                case REQ_TOOL: 
                case REQ_WEAPON: 
                case REQ_USE: 
                case REQ_BREAK: 
                case REQ_CRAFT: 
                case REQ_PLACE: {
                    listButton.text.add((Component)new TextComponent(""));
                    listButton.text.add((Component)ListScreen.getTransComp("pmmo." + this.jType.toString().replace("req_", ""), new Object[0]).m_6270_(XP.textStyle.get(XP.checkReq(this.player, listButton.regKey, this.jType) ? "green" : "red")));
                    ListScreen.addLevelsToButton(listButton, reqMap.get(listButton.regKey), this.player, false);
                    break;
                }
                case HISCORE: {
                    String skill = this.type;
                    String playerName = listButton.regKey;
                    UUID playerUUID = XP.playerUUIDs.get(playerName);
                    if (this.type.equals("totalLevel")) {
                        listButton.text.add((Component)new TextComponent(" " + XP.getTotalLevelFromMap(XP.getOfflineXpMap(playerUUID))));
                        listButton.text.add((Component)new TranslatableComponent("pmmo.xpX", new Object[]{" " + XP.getTotalXpFromMap(XP.getOfflineXpMap(playerUUID))}));
                        break;
                    }
                    Style color = XP.getColorStyle(5503315);
                    Map<String, Double> skillsMap = XP.getOfflineXpMap(playerUUID);
                    if (!skillsMap.containsKey(skill)) break;
                    double xp = skillsMap.get(skill);
                    listButton.text.add((Component)ListScreen.getTransComp("pmmo.levelX", DP.dpSoft(XP.levelAtXpDecimal(xp))).m_6270_(color));
                    listButton.text.add((Component)ListScreen.getTransComp("pmmo.xpX", DP.dpSoft(xp)).m_6270_(color));
                    break;
                }
                case SALVAGE: 
                case SALVAGE_FROM: {
                    if (reqMap2 == null) {
                        return;
                    }
                    int smithLevel = (int)Skill.getLevelDecimal(Skill.SMITHING.toString(), this.player);
                    listButton.unlocked = false;
                    int i = 0;
                    ArrayList<String> toItemsList = new ArrayList<String>(reqMap2.get(listButton.regKey).keySet());
                    toItemsList.sort(Comparator.comparingInt(key -> (int)((Double)((Map)((Map)reqMap2.get(button.regKey)).get(key)).get("levelReq")).doubleValue()));
                    for (String salvageToItemKey : toItemsList) {
                        Map<String, Double> salvageToItemMap = reqMap2.get(listButton.regKey).get(salvageToItemKey);
                        String outputName = ListScreen.getTransComp(XP.getItem(salvageToItemKey).m_5524_(), new Object[0]).getString();
                        double levelReq = salvageToItemMap.get("levelReq");
                        double salvageMax = salvageToItemMap.get("salvageMax");
                        double baseChance = salvageToItemMap.get("baseChance");
                        double chancePerLevel = salvageToItemMap.get("chancePerLevel");
                        double maxChance = salvageToItemMap.get("maxChance");
                        double xpPerItem = salvageToItemMap.get("xpPerItem");
                        double chance = baseChance + chancePerLevel * ((double)smithLevel - levelReq);
                        if (chance < 0.0) {
                            chance = 0.0;
                        }
                        if (chance > maxChance) {
                            chance = maxChance;
                        }
                        Style color = XP.textStyle.get(chance > 0.0 ? "green" : "red");
                        if (chance > 0.0 && (double)smithLevel >= levelReq) {
                            listButton.unlocked = true;
                        }
                        if (i++ == 0) {
                            listButton.text.add((Component)new TranslatableComponent(this.jType == JType.SALVAGE ? "pmmo.salvagesInto" : "pmmo.canBeSalvagedFrom"));
                        }
                        listButton.text.add((Component)new TextComponent("____________________________"));
                        listButton.text.add((Component)new TextComponent(""));
                        listButton.text.add((Component)new TextComponent(ListScreen.getTransComp(this.jType == JType.SALVAGE ? "pmmo.valueValue" : "pmmo.valueFromValue", DP.dpSoft(salvageMax), outputName).getString()).m_6270_(color));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.canBeSalvagedFromLevel", DP.dpSoft(levelReq)).m_6270_(color));
                        listButton.text.add((Component)new TextComponent(""));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.xpPerItem", DP.dpSoft(xpPerItem)).m_6270_(color));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.chancePerItem", DP.dpSoft(chance)).m_6270_(color));
                        listButton.text.add((Component)new TextComponent(""));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.baseChance", DP.dpSoft(baseChance)).m_6270_(color));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.chancePerLevel", DP.dpSoft(chancePerLevel)).m_6270_(color));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.maxChancePerItem", DP.dpSoft(maxChance)).m_6270_(color));
                    }
                    break;
                }
                case TREASURE: 
                case TREASURE_FROM: {
                    if (reqMap2 == null) {
                        return;
                    }
                    int excavationLevel = (int)Skill.getLevelDecimal(Skill.EXCAVATION.toString(), this.player);
                    listButton.unlocked = false;
                    int i = 0;
                    ArrayList<String> toItemsList = new ArrayList<String>(reqMap2.get(listButton.regKey).keySet());
                    toItemsList.sort(Comparator.comparingDouble(key -> BlockBrokenHandler.getTreasureItemChance(excavationLevel, (Map)((Map)reqMap2.get(button.regKey)).get(key))));
                    for (String treasureToItemKey : toItemsList) {
                        Map<String, Double> treasureToItemMap = reqMap2.get(listButton.regKey).get(treasureToItemKey);
                        String outputName = ListScreen.getTransComp(XP.getItem(treasureToItemKey).m_5524_(), new Object[0]).getString();
                        int startLevel = (int)treasureToItemMap.get("startLevel").doubleValue();
                        int endLevel = (int)treasureToItemMap.get("endLevel").doubleValue();
                        double startChance = treasureToItemMap.get("startChance");
                        double endChance = treasureToItemMap.get("endChance");
                        double xpPerItem = treasureToItemMap.get("xpPerItem");
                        int minCount = (int)treasureToItemMap.get("minCount").doubleValue();
                        int maxCount = (int)treasureToItemMap.get("maxCount").doubleValue();
                        double chance = BlockBrokenHandler.getTreasureItemChance(excavationLevel, treasureToItemMap);
                        Style color = XP.textStyle.get(chance > 0.0 ? "green" : "red");
                        if (chance > 0.0) {
                            listButton.unlocked = true;
                        }
                        if (i++ == 0) {
                            listButton.text.add((Component)new TranslatableComponent(this.jType == JType.TREASURE ? "pmmo.containsTreasure" : "pmmo.treasureFrom"));
                        }
                        listButton.text.add((Component)new TextComponent("____________________________"));
                        listButton.text.add((Component)new TextComponent(""));
                        listButton.text.add((Component)new TextComponent(outputName).m_6270_(color));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.xpPerItem", DP.dpSoft(xpPerItem)).m_6270_(color));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.chancePerItem", DP.dpSoft(chance)).m_6270_(color));
                        listButton.text.add((Component)new TextComponent(""));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.minCount", minCount).m_6270_(color));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.maxCount", maxCount).m_6270_(color));
                        listButton.text.add((Component)new TextComponent(""));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.startChance", startChance).m_6270_(color));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.startLevel", startLevel).m_6270_(color));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.endChance", endChance).m_6270_(color));
                        listButton.text.add((Component)ListScreen.getTransComp("pmmo.endLevel", endLevel).m_6270_(color));
                    }
                    break;
                }
                case SKILLS: {
                    if (listButton.regKey.equals("totalLevel")) {
                        listButton.title = ListScreen.getTransComp("pmmo.totalLevel", new Object[0]).getString();
                        listButton.text.add((Component)new TextComponent(" " + XP.getTotalLevelFromMap(XP.getOfflineXpMap(this.uuid))));
                        listButton.text.add((Component)new TranslatableComponent("pmmo.xpX", new Object[]{" " + XP.getTotalXpFromMap(XP.getOfflineXpMap(this.uuid))}));
                        break;
                    }
                    String skill = listButton.regKey;
                    double curXp = XP.getOfflineXp(skill, this.uuid);
                    double nextXp = XP.xpAtLevel(XP.levelAtXp(curXp) + 1);
                    listButton.title = ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + listButton.regKey, new Object[0]), DP.dpSoft(XP.levelAtXpDecimal(curXp))).m_6270_(Skill.getSkillStyle(listButton.regKey)).getString();
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.currentXp", DP.dpSoft(curXp)).getString()));
                    if ((double)Skill.getLevel(skill, this.player) == XP.getMaxLevel()) break;
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.nextLevelXp", DP.dpSoft(nextXp)).getString()));
                    listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.RemainderXp", DP.dpSoft(nextXp - curXp)).getString()));
                    break;
                }
            }
            if (skillText.size() > 0) {
                listButton.text.add((Component)new TextComponent(""));
                skillText.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((Component)textComp).getString())).reversed());
                listButton.text.add((Component)ListScreen.getTransComp("pmmo.xpModifiers", new Object[0]));
                listButton.text.addAll(skillText);
            }
            if (arrayList.size() > 0) {
                if (skillText.size() > 0) {
                    listButton.text.add((Component)new TextComponent(""));
                }
                arrayList.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((Component)textComp).getString())).reversed());
                listButton.text.add((Component)ListScreen.getTransComp("pmmo.enemyScaling", new Object[0]));
                listButton.text.addAll(arrayList);
            }
            if (arrayList2.size() > 0) {
                if (skillText.size() > 0 || arrayList.size() > 0) {
                    listButton.text.add((Component)new TextComponent(""));
                }
                arrayList2.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((Component)textComp).getString())).reversed());
                listButton.text.add((Component)ListScreen.getTransComp("pmmo.negativeBiomeEffects", new Object[0]).m_6270_(XP.textStyle.get("red")));
                listButton.text.addAll(arrayList2);
            }
            if (positiveEffectText.size() > 0) {
                if (skillText.size() > 0 || arrayList.size() > 0) {
                    listButton.text.add((Component)new TextComponent(""));
                }
                positiveEffectText.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((Component)textComp).getString())).reversed());
                listButton.text.add((Component)ListScreen.getTransComp("pmmo.positiveBiomeEffects", new Object[0]).m_6270_(XP.textStyle.get("green")));
                listButton.text.addAll(positiveEffectText);
            }
            switch (this.jType) {
                case INFO_ORE: 
                case INFO_LOG: 
                case INFO_PLANT: 
                case XP_VALUE_BREAK: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_BREAK);
                    break;
                }
                case XP_BONUS_WORN: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_WEAR);
                    break;
                }
                case FISH_POOL: {
                    break;
                }
                case REQ_BIOME: 
                case REQ_WEAR: 
                case REQ_TOOL: 
                case REQ_WEAPON: 
                case REQ_USE: 
                case REQ_BREAK: 
                case REQ_CRAFT: 
                case REQ_PLACE: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, this.jType);
                    break;
                }
                case XP_VALUE_CRAFT: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_CRAFT);
                    break;
                }
                case XP_VALUE_GROW: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_PLACE);
                    break;
                }
            }
        }
        switch (this.jType) {
            case INFO_ORE: 
            case INFO_LOG: 
            case INFO_PLANT: 
            case XP_VALUE_BREAK: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, JType.REQ_BREAK)));
                break;
            }
            case REQ_WEAR: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, JType.REQ_WEAR)));
                break;
            }
            case SALVAGE: 
            case SALVAGE_FROM: {
                this.listButtons.sort(Comparator.comparingDouble(b -> ListScreen.getLowestSalvageReq((Map)reqMap2.get(b.regKey))));
                break;
            }
            default: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, this.jType)));
            }
        }
        switch (this.jType) {
            case XP_VALUE_BREED: {
                ListButton otherAnimalsBreedButton = new ListButton(0, 0, 3, 20, "pmmo.otherAnimals", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                otherAnimalsBreedButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.farming", new Object[0]), DP.dpSoft(Config.forgeConfig.defaultBreedingXp.get())).getString()).m_6270_(greenColor));
                this.listButtons.add(otherAnimalsBreedButton);
                break;
            }
            case XP_VALUE_TAME: {
                ListButton listButton = new ListButton(0, 0, 3, 21, "pmmo.otherAnimals", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.taming", new Object[0]), DP.dpSoft(Config.forgeConfig.defaultTamingXp.get())).getString()).m_6270_(greenColor));
                this.listButtons.add(listButton);
                break;
            }
            case REQ_KILL: {
                ListButton listButton = new ListButton(0, 0, 3, 26, "pmmo.otherAggresiveMobs", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.slayer", new Object[0]), DP.dpSoft(Config.forgeConfig.aggresiveMobSlayerXp.get())).getString()).m_6270_(greenColor));
                this.listButtons.add(listButton);
                ListButton otherPassiveMobsButton = new ListButton(0, 0, 3, 26, "pmmo.otherPassiveMobs", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                otherPassiveMobsButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.hunter", new Object[0]), DP.dpSoft(Config.forgeConfig.passiveMobHunterXp.get())).getString()).m_6270_(greenColor));
                this.listButtons.add(otherPassiveMobsButton);
                break;
            }
            case XP_VALUE_CRAFT: {
                ListButton listButton = new ListButton(0, 0, 3, 22, "pmmo.otherCrafts", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                listButton.text.add((Component)new TextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.crafting", new Object[0]), DP.dpSoft(Config.forgeConfig.defaultCraftingXp.get())).getString()).m_6270_(greenColor));
                this.listButtons.add(listButton);
            }
        }
        this.scrollPanel = new ListScrollPanel(Minecraft.m_91087_(), this.boxWidth - 40, this.boxHeight - 21, this.scrollY, this.scrollX, this.jType, this.player, this.listButtons);
        if (!MainScreen.scrollAmounts.containsKey((Object)this.jType)) {
            MainScreen.scrollAmounts.put(this.jType, 0);
        }
        this.scrollPanel.setScroll(MainScreen.scrollAmounts.get((Object)this.jType));
        this.f_96540_.add(this.scrollPanel);
        this.filterTextField = new EditBox(this.f_96547_, this.x, this.y + this.boxHeight - 10, this.boxWidth, 16, (Component)new TranslatableComponent(""));
        this.filterTextField.m_94144_(this.filterText);
        this.updateListFilter();
        this.filterTextField.m_94178_(true);
        this.f_96540_.add(this.filterTextField);
        this.m_7787_((GuiEventListener)exitButton);
    }

    private static void addLevelsToButton(ListButton button, Map<String, Double> map, Player player, boolean ignoreReq) {
        ArrayList<Object> levelsToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            if (inEntry.getValue() <= 1.0) continue;
            if (!ignoreReq && Skill.getLevelDecimal(inEntry.getKey(), player) < inEntry.getValue()) {
                levelsToAdd.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft(inEntry.getValue())).getString()).m_6270_(XP.textStyle.get("red")));
                continue;
            }
            levelsToAdd.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft(inEntry.getValue())).getString()).m_6270_(XP.textStyle.get("green")));
        }
        levelsToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((Component)textComp).getString())).reversed());
        button.text.addAll(levelsToAdd);
    }

    private static void addXpToButton(ListButton button, Map<String, Double> map) {
        ArrayList<Object> xpToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            xpToAdd.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft(inEntry.getValue())).getString()).m_6270_(XP.textStyle.get("green")));
        }
        xpToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((Component)textComp).getString())).reversed());
        button.text.addAll(xpToAdd);
    }

    private static void addXpToButton(ListButton button, Map<String, Double> map, JType jType, Player player) {
        ArrayList<Object> xpToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            xpToAdd.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft(inEntry.getValue())).getString()).m_6270_(XP.textStyle.get(XP.checkReq(player, button.regKey, jType) ? "green" : "red")));
        }
        xpToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((Component)textComp).getString())).reversed());
        button.text.addAll(xpToAdd);
    }

    private static void addPercentageToButton(ListButton button, Map<String, Double> map, boolean metReq) {
        ArrayList<Object> levelsToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            double value = inEntry.getValue();
            if (metReq) {
                if (value > 0.0) {
                    levelsToAdd.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), "+" + value + "%").getString()).m_6270_(XP.textStyle.get("green")));
                    continue;
                }
                if (!(value < 0.0)) continue;
                levelsToAdd.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), value + "%").getString()).m_6270_(XP.textStyle.get("red")));
                continue;
            }
            levelsToAdd.add(new TextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), value + "%").getString()).m_6270_(XP.textStyle.get("red")));
        }
        levelsToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((Component)textComp).getString())).reversed());
        button.text.addAll(levelsToAdd);
    }

    private static int getTextInt(String comp) {
        String number = comp.replaceAll("\\D+", "");
        if (number.length() > 0 && !Double.isNaN(Double.parseDouble(number))) {
            return (int)Double.parseDouble(number);
        }
        return 0;
    }

    private static double getTextDouble(String comp) {
        String number = comp.replaceAll("\\D+", "");
        if (number.length() > 0 && !Double.isNaN(Double.parseDouble(number))) {
            return Double.parseDouble(number);
        }
        return 0.0;
    }

    private static int getReqCount(String regKey, JType jType) {
        Map<String, Double> map = XP.getJsonMap(regKey, jType);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_96558_(stack, 1);
        this.scrollPanel.m_6305_(stack, mouseX, mouseY, partialTicks);
        if (this.jType.equals((Object)JType.SKILLS)) {
            this.title = ListScreen.getTransComp("pmmo.playerStats", XP.playerNames.get(this.uuid));
        } else if (this.jType.equals((Object)JType.HISCORE)) {
            this.title = ListScreen.getTransComp("pmmo.skillHiscores", ListScreen.getTransComp("pmmo." + this.type, new Object[0])).m_6270_(Skill.getSkillStyle(this.type));
        }
        if (this.f_96547_.m_92895_(this.title.getString()) > 220) {
            ListScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.title, (int)(this.sr.m_85445_() / 2), (int)(this.y - 10), (int)0xFFFFFF);
        } else {
            ListScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.title, (int)(this.sr.m_85445_() / 2), (int)(this.y - 5), (int)0xFFFFFF);
        }
        this.x = this.sr.m_85445_() / 2 - this.boxWidth / 2;
        this.y = this.sr.m_85446_() / 2 - this.boxHeight / 2;
        this.scrollPanel.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.filterTextField.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.accumulativeHeight = 0;
        this.buttonsSize = this.listButtons.size();
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        for (ListButton button : this.activeListButtons) {
            this.buttonX = mouseX - button.f_93620_;
            this.buttonY = mouseY - button.f_93621_;
            if (mouseY >= this.scrollPanel.getTop() && mouseY <= this.scrollPanel.getBottom() && this.buttonX >= 0 && this.buttonX < 32 && this.buttonY >= 0 && this.buttonY < 32) {
                if (this.jType.equals((Object)JType.REQ_BIOME) || this.jType.equals((Object)JType.REQ_KILL) || this.jType.equals((Object)JType.XP_VALUE_BREED) || this.jType.equals((Object)JType.XP_VALUE_TAME) || this.jType.equals((Object)JType.DIMENSION) || this.jType.equals((Object)JType.FISH_ENCHANT_POOL) || this.jType.equals((Object)JType.SKILLS) || this.jType.equals((Object)JType.HISCORE) || button.regKey.equals("pmmo.otherCrafts")) {
                    this.m_96602_(stack, (Component)new TranslatableComponent(button.title), mouseX, mouseY);
                } else if (button.itemStack != null) {
                    this.m_6057_(stack, button.itemStack, mouseX, mouseY);
                }
            }
            this.accumulativeHeight += button.m_93694_();
        }
        MainScreen.scrollAmounts.replace(this.jType, this.scrollPanel.getScroll());
    }

    public static double getLowestSalvageReq(Map<String, Map<String, Double>> map) {
        double lowestReq = XP.getMaxLevel();
        for (Map.Entry<String, Map<String, Double>> entry : map.entrySet()) {
            lowestReq = Math.min(lowestReq, (double)((int)entry.getValue().get("levelReq").doubleValue()));
        }
        return lowestReq;
    }

    public void m_96558_(PoseStack stack, int p_renderBackground_1_) {
        if (this.f_96541_ != null) {
            this.m_93179_(stack, 0, 0, this.f_96543_, this.f_96544_, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundDrawnEvent((Screen)this, stack));
        }
        this.boxHeight = 256;
        this.boxWidth = 256;
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.box);
        this.m_93228_(stack, this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        this.accumulativeHeight = 0;
        for (ListButton listButton : this.listButtons) {
            this.accumulativeHeight += listButton.m_93694_();
            if (this.accumulativeHeight <= this.scrollPanel.getBottom() - this.scrollPanel.getTop()) continue;
            this.scrollPanel.m_6050_(mouseX, mouseY, scroll);
            break;
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.filterTextField.m_7933_(keyCode, scanCode, modifiers);
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.filterTextField.m_7920_(keyCode, scanCode, modifiers);
        this.filterText = this.filterTextField.m_94155_();
        if (this.filterTextField.m_93696_()) {
            this.updateListFilter();
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        this.filterTextField.m_5534_(codePoint, modifiers);
        return false;
    }

    public void updateListFilter() {
        this.activeListButtons = new ArrayList();
        block0: for (ListButton button : this.listButtons) {
            if (button.title.toLowerCase().contains(this.filterText.toLowerCase())) {
                this.activeListButtons.add(button);
                continue;
            }
            for (Component textComp : button.text) {
                if (!textComp.getString().toLowerCase().contains(this.filterText.trim().toLowerCase())) continue;
                this.activeListButtons.add(button);
                continue block0;
            }
        }
        this.scrollPanel.setButtons(this.activeListButtons);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.m_5691_();
            return true;
        }
        for (ListButton a : this.listButtons) {
            int buttonX = (int)mouseX - a.f_93620_;
            int buttonY = (int)mouseY - a.f_93621_;
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom()) || buttonX < 0 || buttonX >= 32 || buttonY < 0 || buttonY >= 32) continue;
            a.m_5716_(mouseX, mouseY);
        }
        this.scrollPanel.m_6375_(mouseX, mouseY, button);
        this.filterTextField.m_6375_(mouseX, mouseY, button);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrollPanel.m_6348_(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.scrollPanel.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static TranslatableComponent getTransComp(String translationKey, Object ... args) {
        return new TranslatableComponent(translationKey, args);
    }

    public static <T> T make(T item, Consumer<T> action) {
        action.accept(item);
        return item;
    }
}

