/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.gui.ListScreen;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ListButton
extends Button {
    private final ResourceLocation items = XP.getResLoc("pmmo", "textures/gui/items.png");
    private final ResourceLocation buttons = XP.getResLoc("pmmo", "textures/gui/buttons.png");
    public int elementOne;
    public int elementTwo;
    public int offsetOne;
    public int offsetTwo;
    public double mobWidth;
    public double mobHeight;
    public double mobScale;
    public boolean unlocked = true;
    public ItemStack itemStack;
    public String regKey;
    public String title;
    public String buttonText;
    public List<Component> text = new ArrayList<Component>();
    public List<Component> tooltipText = new ArrayList<Component>();
    Entity testEntity = null;
    LivingEntity entity = null;
    ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
    Minecraft mc = Minecraft.m_91087_();

    public ListButton(int posX, int posY, int elementOne, int elementTwo, String regKey, JType jType, String buttonText, Button.OnPress onPress) {
        super(posX, posY, 32, 32, (Component)new TranslatableComponent(""), onPress);
        this.regKey = regKey;
        this.buttonText = buttonText;
        this.itemStack = new ItemStack((ItemLike)XP.getItem(regKey));
        this.elementOne = elementOne * 32;
        this.elementTwo = elementTwo * 32;
        if (ForgeRegistries.ENTITIES.containsKey(XP.getResLoc(regKey))) {
            this.testEntity = ((EntityType)ForgeRegistries.ENTITIES.getValue(XP.getResLoc(regKey))).m_20615_((Level)Minecraft.m_91087_().f_91073_);
        }
        if (this.testEntity instanceof LivingEntity) {
            this.entity = (LivingEntity)this.testEntity;
        }
        switch (jType) {
            case FISH_ENCHANT_POOL: {
                this.title = new TranslatableComponent(((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(XP.getResLoc(regKey))).m_44700_(1).getString().replace(" I", "")).getString();
                break;
            }
            case XP_VALUE_BREED: 
            case XP_VALUE_TAME: 
            case REQ_KILL: {
                this.title = new TranslatableComponent(((EntityType)ForgeRegistries.ENTITIES.getValue(XP.getResLoc(regKey))).m_20675_()).getString();
                break;
            }
            case DIMENSION: {
                if (regKey.equals("all_dimensions")) {
                    this.title = new TranslatableComponent("pmmo.allDimensions").getString();
                    break;
                }
                if (!regKey.equals("minecraft:overworld") && !regKey.equals("minecraft:the_nether") && !regKey.equals("minecraft:the_end")) break;
                this.title = new TranslatableComponent(regKey).getString();
                break;
            }
            case STATS: {
                this.title = new TranslatableComponent("pmmo." + regKey).m_6270_(Skill.getSkillStyle(regKey)).getString();
                break;
            }
            case HISCORE: {
                if (XP.playerNames.containsValue(regKey)) {
                    this.title = new TextComponent(regKey).m_6270_(Skill.getSkillStyle(regKey)).getString();
                    break;
                }
                this.title = new TranslatableComponent("pmmo." + regKey).m_6270_(Skill.getSkillStyle(regKey)).getString();
                break;
            }
            case REQ_BIOME: {
                this.title = new TranslatableComponent(regKey).getString();
                break;
            }
            default: {
                this.title = new TranslatableComponent(this.itemStack.m_41778_()).getString();
            }
        }
        switch (regKey) {
            case "pmmo.otherCrafts": 
            case "pmmo.otherAnimals": 
            case "pmmo.otherPassiveMobs": 
            case "pmmo.otherAggresiveMobs": {
                this.title = new TranslatableComponent(new TranslatableComponent(regKey).getString()).getString();
            }
        }
        this.offsetOne = elementOne > 23 ? 192 : (elementOne > 15 ? 128 : (elementOne > 7 ? 64 : 0));
        this.offsetTwo = elementTwo > 23 ? 192 : (elementTwo > 15 ? 128 : (elementTwo > 7 ? 64 : 0));
    }

    public int m_93694_() {
        int height = 11;
        for (Component a : this.text) {
            height += 9;
        }
        if (height > 32) {
            return height;
        }
        return 32;
    }

    public void clickActionGlossary() {
        GlossaryScreen.setButtonsToKey(this.regKey);
        Minecraft.m_91087_().m_91152_((Screen)new GlossaryScreen(Minecraft.m_91087_().f_91074_.m_142081_(), (Component)new TranslatableComponent("pmmo.glossary"), false));
    }

    public void clickActionSkills() {
        if (XP.playerNames.containsValue(this.regKey)) {
            Minecraft.m_91087_().m_91152_((Screen)new ListScreen(XP.playerUUIDs.get(this.regKey), (Component)new TranslatableComponent(""), this.regKey, JType.SKILLS, (Player)Minecraft.m_91087_().f_91074_));
        } else {
            Minecraft.m_91087_().m_91152_((Screen)new ListScreen(Minecraft.m_91087_().f_91074_.m_142081_(), (Component)new TranslatableComponent(""), this.regKey, JType.HISCORE, (Player)Minecraft.m_91087_().f_91074_));
        }
    }

    public void m_6303_(PoseStack stack, int x, int y, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Font fontrenderer = mc.f_91062_;
        RenderSystem.m_69424_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        int i = this.m_7202_(this.m_198029_());
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.buttons);
        this.m_93228_(stack, this.f_93620_, this.f_93621_, this.offsetOne + (this.m_198029_() ? 32 : 0), this.elementOne, this.f_93618_, this.f_93619_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.items);
        this.m_93228_(stack, this.f_93620_, this.f_93621_, this.offsetTwo + (this.m_198029_() ? 32 : 0), this.elementTwo, this.f_93618_, this.f_93619_);
        if (!this.itemStack.m_41720_().equals(Items.f_41852_) && this.entity == null) {
            this.itemRenderer.m_115123_(this.itemStack, this.f_93620_ + 8, this.f_93621_ + 8);
        }
        if (this.entity != null) {
            this.mobHeight = this.entity.m_6972_((Pose)Pose.STANDING).f_20378_;
            this.mobWidth = this.entity.m_6972_((Pose)Pose.STANDING).f_20377_;
            this.mobScale = 27.0;
            if (this.mobHeight > 0.0) {
                this.mobScale /= Math.max(this.mobHeight, this.mobWidth);
            }
        }
        this.m_7906_(stack, mc, x, y);
        int j = this.getFGColor();
        ListButton.m_93208_((PoseStack)stack, (Font)fontrenderer, (String)this.buttonText, (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
    }
}

