/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.ftb_quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.ftb_quests.FTBQHandler;
import harmonised.pmmo.skills.Skill;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class XpReward
extends Reward {
    public static RewardType XP_REWARD = FTBQHandler.XP_REWARD;
    public String skill = "mining";
    public double amount = 83.0;
    public boolean ignoreBonuses = false;

    public XpReward(Quest quest) {
        super(quest);
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    public RewardType getType() {
        return XP_REWARD;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("skill", this.skill);
        nbt.m_128347_("amount", this.amount);
        nbt.m_128379_("ignoreBonuses", this.ignoreBonuses);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.skill = nbt.m_128461_("skill");
        this.amount = nbt.m_128459_("amount");
        this.ignoreBonuses = nbt.m_128471_("ignoreBonuses");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130070_(this.skill);
        buffer.writeDouble(this.amount);
        buffer.writeBoolean(this.ignoreBonuses);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.skill = buffer.m_130277_();
        this.amount = buffer.readDouble();
        this.ignoreBonuses = buffer.readBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("skill", (Object)this.skill, input -> {
            this.skill = (String)input;
        }, NameMap.of((Object)Skill.MINING.toString(), (Object[])Skill.getSkills().keySet().toArray()).create());
        config.addDouble("amount", this.amount, input -> {
            this.amount = input;
        }, 1.0, -Config.getConfig("maxXp"), Config.getConfig("maxXp"));
        config.addBool("ignoreBonuses", this.ignoreBonuses, v -> {
            this.ignoreBonuses = v;
        }, false).setNameKey("pmmo.ignoreBonuses");
    }

    public void claim(ServerPlayer player, boolean notify) {
        Skill.addXp(this.skill, player.m_142081_(), this.amount, "Completing a Quest", !notify, this.ignoreBonuses);
    }
}

