/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.perks.PerkRegistry;
import harmonised.pmmo.api.perks.PerkTrigger;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.network.MessageUpdateBoolean;
import harmonised.pmmo.network.MessageUpdatePlayerNBT;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.skills.VeinInfo;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.ServerUtil;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldTickHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static Map<Player, VeinInfo> activeVein;
    public static Map<Player, ArrayList<BlockPos>> veinSet;
    private static double minVeinCost;
    private static double minVeinHardness;
    private static double levelsPerHardnessMining;
    private static double levelsPerHardnessWoodcutting;
    private static double levelsPerHardnessExcavation;
    private static double levelsPerHardnessFarming;
    private static double levelsPerHardnessCrafting;
    private static double veinMaxBlocks;
    private static double maxVeinCharge;
    private static double exhaustionPerBlock;
    private static int veinMaxDistance;

    public static void refreshVein() {
        activeVein = new HashMap<Player, VeinInfo>();
        veinSet = new HashMap<Player, ArrayList<BlockPos>>();
        minVeinCost = Config.getConfig("minVeinCost");
        minVeinHardness = Config.getConfig("minVeinHardness");
        levelsPerHardnessMining = Config.getConfig("levelsPerHardnessMining");
        levelsPerHardnessWoodcutting = Config.getConfig("levelsPerHardnessWoodcutting");
        levelsPerHardnessExcavation = Config.getConfig("levelsPerHardnessExcavation");
        levelsPerHardnessFarming = Config.getConfig("levelsPerHardnessFarming");
        levelsPerHardnessCrafting = Config.getConfig("levelsPerHardnessCrafting");
        veinMaxDistance = (int)Math.floor(Config.forgeConfig.veinMaxDistance.get());
        exhaustionPerBlock = Config.forgeConfig.exhaustionPerBlock.get();
        veinMaxBlocks = Config.forgeConfig.veinMaxBlocks.get().intValue();
        maxVeinCharge = Config.forgeConfig.maxVeinCharge.get();
    }

    public static void handleWorldTick(TickEvent.WorldTickEvent event) {
        ServerUtil.tick(event);
        int veinSpeed = (int)Math.floor(Config.forgeConfig.veinSpeed.get().intValue());
        int age = -1;
        int maxAge = -2;
        if (event.world.m_142572_() == null) {
            return;
        }
        for (ServerPlayer player : event.world.m_142572_().m_6846_().m_11314_()) {
            PerkRegistry.executePerk(PerkTrigger.SKILL_UP, player);
        }
        for (ServerPlayer player : event.world.m_142572_().m_6846_().m_11314_()) {
            UUID playerUUID = player.m_142081_();
            for (int i = 0; i < veinSpeed; ++i) {
                if (activeVein.containsKey(player) && veinSet.get(player).size() > 0) {
                    VeinInfo veinInfo = activeVein.get(player);
                    Level world = veinInfo.world;
                    ItemStack startItemStack = veinInfo.itemStack;
                    Item startItem = veinInfo.startItem;
                    BlockPos veinPos = veinSet.get(player).get(0);
                    BlockState veinState = world.m_8055_(veinPos);
                    Map<String, Double> abilitiesMap = Config.getAbilitiesMap((Player)player);
                    String regKey = veinState.m_60734_().getRegistryName().toString();
                    double cost = WorldTickHandler.getVeinCost(veinState, veinPos, (Player)player);
                    boolean correctBlock = world.m_8055_(veinPos).m_60734_().equals(veinInfo.state.m_60734_());
                    boolean correctItem = !startItem.m_41465_() || startItemStack.m_41773_() < startItemStack.m_41776_();
                    boolean correctHeldItem = player.m_21205_().m_41720_().equals(startItem);
                    UUID blockUUID = ChunkDataHandler.checkPos(world, veinPos);
                    boolean isOwner = blockUUID == null || blockUUID.equals(playerUUID);
                    String skill = XP.getSkill(veinState);
                    if (!(!skill.equals(Skill.FARMING.toString()) || JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).containsKey(regKey) && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).get(regKey).containsKey("growsUpwards"))) {
                        if (veinState.m_61138_((Property)BlockStateProperties.f_61405_)) {
                            age = (Integer)veinState.m_61143_((Property)BlockStateProperties.f_61405_);
                            maxAge = 1;
                        } else if (veinState.m_61138_((Property)BlockStateProperties.f_61406_)) {
                            age = (Integer)veinState.m_61143_((Property)BlockStateProperties.f_61406_);
                            maxAge = 2;
                        } else if (veinState.m_61138_((Property)BlockStateProperties.f_61407_)) {
                            age = (Integer)veinState.m_61143_((Property)BlockStateProperties.f_61407_);
                            maxAge = 3;
                        } else if (veinState.m_61138_((Property)BlockStateProperties.f_61408_)) {
                            age = (Integer)veinState.m_61143_((Property)BlockStateProperties.f_61408_);
                            maxAge = 5;
                        } else if (veinState.m_61138_((Property)BlockStateProperties.f_61409_)) {
                            age = (Integer)veinState.m_61143_((Property)BlockStateProperties.f_61409_);
                            maxAge = 7;
                        } else if (veinState.m_61138_((Property)BlockStateProperties.f_61410_)) {
                            age = (Integer)veinState.m_61143_((Property)BlockStateProperties.f_61410_);
                            maxAge = 15;
                        } else if (veinState.m_61138_((Property)BlockStateProperties.f_61411_)) {
                            age = (Integer)veinState.m_61143_((Property)BlockStateProperties.f_61411_);
                            maxAge = 25;
                        } else if (veinState.m_61138_((Property)BlockStateProperties.f_61425_)) {
                            age = (Integer)veinState.m_61143_((Property)BlockStateProperties.f_61425_);
                            maxAge = 4;
                        }
                        if (age >= 0 && age != maxAge) {
                            veinSet.get(player).remove(0);
                            return;
                        }
                    }
                    if ((abilitiesMap.get("veinLeft") >= cost || player.m_7500_()) && XP.isVeining.contains(player.m_142081_())) {
                        veinSet.get(player).remove(0);
                        BlockEvent.BreakEvent veinEvent = new BlockEvent.BreakEvent(world, veinPos, veinState, (Player)player);
                        MinecraftForge.EVENT_BUS.post((Event)veinEvent);
                        if (veinEvent.isCanceled() || !correctBlock) continue;
                        if (player.m_7500_()) {
                            world.m_46961_(veinPos, false);
                            continue;
                        }
                        if (correctItem && correctHeldItem && player.m_36324_().m_38702_() > 0) {
                            if (!Config.forgeConfig.veiningOtherPlayerBlocksAllowed.get().booleanValue() && !isOwner) continue;
                            abilitiesMap.put("veinLeft", abilitiesMap.get("veinLeft") - cost);
                            WorldTickHandler.destroyBlock(world, veinPos, (Player)player, startItemStack);
                            player.m_36399_((float)exhaustionPerBlock);
                            continue;
                        }
                        activeVein.remove(player);
                        veinSet.remove(player);
                        NetworkHandler.sendToPlayer(new MessageUpdateBoolean(false, 0), player);
                        continue;
                    }
                    activeVein.remove(player);
                    veinSet.remove(player);
                    NetworkHandler.sendToPlayer(new MessageUpdateBoolean(false, 0), player);
                    continue;
                }
                activeVein.remove(player);
                veinSet.remove(player);
                NetworkHandler.sendToPlayer(new MessageUpdateBoolean(false, 0), player);
            }
        }
    }

    public static void destroyBlock(Level world, BlockPos pos, Player player, ItemStack toolUsed) {
        BlockState blockstate = world.m_8055_(pos);
        FluidState ifluidstate = world.m_6425_(pos);
        world.m_46796_(2001, pos, Block.m_49956_((BlockState)blockstate));
        BlockEntity tileentity = blockstate.m_155947_() ? world.m_7702_(pos) : null;
        Block.m_49881_((BlockState)blockstate, (Level)world, (BlockPos)pos, (BlockEntity)tileentity, (Entity)player, (ItemStack)toolUsed);
        if (Config.forgeConfig.damageToolWhileVeining.get().booleanValue() && world.m_7731_(pos, ifluidstate.m_76188_(), 3) && toolUsed.m_41763_() && !player.m_7500_()) {
            toolUsed.m_41622_(1, (LivingEntity)player, a -> a.m_21190_(InteractionHand.MAIN_HAND));
        }
    }

    public static double getVeinLeft(Player player) {
        return Config.getAbilitiesMap(player).getOrDefault("veinLeft", 0.0);
    }

    public static void scheduleVein(Player player, VeinInfo veinInfo) {
        double veinLeft = WorldTickHandler.getVeinLeft(player);
        double veinCost = WorldTickHandler.getVeinCost(veinInfo.state, veinInfo.pos, player);
        String blockKey = veinInfo.state.m_60734_().getRegistryName().toString();
        if (!(WorldTickHandler.canVeinGlobal(blockKey, player) && WorldTickHandler.canVeinDimension(blockKey, player) && XP.checkReq(player, player.m_21205_().m_41720_().getRegistryName(), JType.REQ_TOOL))) {
            return;
        }
        ArrayList<BlockPos> blockPosArrayList = WorldTickHandler.getVeinShape(veinInfo, veinLeft, veinCost, player.m_7500_(), false);
        if (blockPosArrayList.size() > 0) {
            activeVein.put(player, veinInfo);
            veinSet.put(player, blockPosArrayList);
            NetworkHandler.sendToPlayer(new MessageUpdateBoolean(true, 0), (ServerPlayer)player);
        }
    }

    public static boolean canVeinGlobal(String blockKey, Player player) {
        if (player.m_7500_()) {
            return true;
        }
        Map<String, Double> globalBlacklist = null;
        if (JsonConfig.data.get((Object)JType.VEIN_BLACKLIST).containsKey("all_dimensions")) {
            globalBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST).get("all_dimensions");
        }
        return globalBlacklist == null || !globalBlacklist.containsKey(blockKey);
    }

    public static boolean canVeinDimension(String blockKey, Player player) {
        if (player.m_7500_()) {
            return true;
        }
        Level world = player.f_19853_;
        if (world == null) {
            return true;
        }
        ResourceLocation dimensionKey = XP.getDimResLoc(world);
        Map<String, Double> dimensionBlacklist = null;
        if (JsonConfig.data.get((Object)JType.VEIN_BLACKLIST).containsKey(dimensionKey.toString())) {
            dimensionBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST).get(dimensionKey.toString());
        }
        return dimensionBlacklist == null || !dimensionBlacklist.containsKey(blockKey);
    }

    public static ArrayList<BlockPos> getVeinShape(VeinInfo veinInfo, double veinLeft, double veinCost, boolean isCreative, boolean isLooped) {
        BlockPos originPos;
        HashSet<BlockPos> vein = new HashSet<BlockPos>();
        ArrayList<BlockPos> outVein = new ArrayList<BlockPos>();
        ArrayList<BlockPos> curLayer = new ArrayList<BlockPos>();
        ArrayList<BlockPos> nextLayer = new ArrayList<BlockPos>();
        BlockPos highestPos = originPos = veinInfo.pos;
        curLayer.add(originPos);
        Block block = veinInfo.state.m_60734_();
        Material material = veinInfo.state.m_60767_();
        String regKey = block.getRegistryName().toString();
        String skill = XP.getSkill(veinInfo.state);
        int yLimit = 1;
        if (JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).containsKey(regKey) && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).get(regKey).containsKey("growsUpwards")) {
            yLimit = 0;
        }
        while ((isCreative || veinLeft * 1.523 > veinCost * (double)vein.size() || Config.forgeConfig.veinWoodTopToBottom.get().booleanValue() && !isLooped && skill.equals(Skill.WOODCUTTING.toString())) && (double)vein.size() <= veinMaxBlocks) {
            for (BlockPos curPos : curLayer) {
                if (!curPos.m_123314_((Vec3i)originPos, (double)veinMaxDistance)) continue;
                for (int i = yLimit; i >= -yLimit; --i) {
                    for (int j = 1; j >= -1; --j) {
                        for (int k = 1; k >= -1; --k) {
                            BlockPos curPos2 = curPos.m_6630_(i).m_142390_(j).m_142385_(k);
                            if (vein.contains(curPos2) || !veinInfo.world.m_8055_(curPos2).m_60734_().equals(block)) continue;
                            vein.add(curPos2);
                            outVein.add(curPos2);
                            nextLayer.add(curPos2);
                            if (curPos2.m_123342_() <= highestPos.m_123342_()) continue;
                            highestPos = new BlockPos((Vec3i)curPos2);
                        }
                    }
                }
            }
            if (nextLayer.size() == 0) break;
            curLayer = nextLayer;
            nextLayer = new ArrayList();
        }
        if (!isLooped) {
            if (Config.forgeConfig.veinWoodTopToBottom.get().booleanValue() && material.equals(Material.f_76320_)) {
                veinInfo.pos = highestPos;
            }
            return WorldTickHandler.getVeinShape(veinInfo, veinLeft, veinCost, isCreative, true);
        }
        return outVein;
    }

    public static double getVeinCost(BlockState state, BlockPos pos, Player player) {
        String skill = XP.getSkill(state);
        double hardness = state.m_60800_((BlockGetter)player.f_19853_, pos);
        double level = APIUtils.getLevel(skill, player);
        if (hardness < minVeinHardness) {
            hardness = minVeinHardness;
        }
        double cost = switch (skill) {
            case "mining" -> hardness / (level / levelsPerHardnessMining);
            case "woodcutting" -> hardness / (level / levelsPerHardnessWoodcutting);
            case "excavation" -> hardness / (level / levelsPerHardnessExcavation);
            case "farming" -> hardness / (level / levelsPerHardnessFarming);
            case "crafting" -> hardness / (level / levelsPerHardnessCrafting);
            default -> hardness;
        };
        double mainItemSpeed = player.m_21205_().m_41691_(state);
        if (mainItemSpeed > 1.0) {
            cost /= Math.max(1.0, (mainItemSpeed + 4.0) * (1.0 / Config.getConfig("toolSpeedVeinScale")));
        }
        if (cost < minVeinCost) {
            cost = minVeinCost;
        }
        return cost;
    }

    public static void updateVein(Player player, double gap) {
        double veinLeft;
        Map<String, Double> abilitiesMap = Config.getAbilitiesMap(player);
        if (!abilitiesMap.containsKey("veinLeft")) {
            abilitiesMap.put("veinLeft", maxVeinCharge);
        }
        if ((veinLeft = abilitiesMap.get("veinLeft").doubleValue()) < 0.0) {
            veinLeft = 0.0;
        }
        if (!activeVein.containsKey(player)) {
            veinLeft += Math.min(gap, 2.0);
        }
        if (veinLeft > maxVeinCharge) {
            veinLeft = maxVeinCharge;
        }
        abilitiesMap.put("veinLeft", veinLeft);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(NBTHelper.mapStringToNbt(abilitiesMap), 1), (ServerPlayer)player);
    }
}

