/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.events.SalvageEvent;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.network.MessageTripleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerInteractionHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Set<Block> salvageStations = new HashSet<Block>();
    private static long lastWarning = 0L;

    public static void initSalvageStations() {
        salvageStations.clear();
        for (Map.Entry<String, Map<String, Double>> entry : JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).entrySet()) {
            if (entry.getValue().getOrDefault("salvageStation", 0.0) == 0.0) continue;
            salvageStations.add(XP.getBlock(entry.getKey()));
        }
        if (salvageStations.size() == 0) {
            salvageStations.add(Blocks.f_50625_);
        }
    }

    public static void handlePlayerInteract(PlayerInteractEvent event) {
        try {
            PlayerInteractEvent.EntityInteractSpecific entityInteractEvent;
            Entity target;
            Map<String, Double> reqMap;
            Player player;
            if (event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickItem) {
                Map<String, Double> rightClickAwardMap;
                Player player2 = event.getPlayer();
                ItemStack itemStack = event.getItemStack();
                Item item = itemStack.m_41720_();
                if (item.getRegistryName() == null) {
                    return;
                }
                if (!player2.f_19853_.m_5776_() && (rightClickAwardMap = APIUtils.getXp(itemStack, JType.XP_VALUE_RIGHT_CLICK)) != null) {
                    XP.awardXpMap(player2.m_142081_(), rightClickAwardMap, "right_click", false, false);
                }
                String regKey = item.getRegistryName().toString();
                boolean isClientSide = player2.f_19853_.m_5776_();
                boolean matched = false;
                if (event instanceof PlayerInteractEvent.RightClickItem && XP.isPlayerSurvival(player2) && JsonConfig.data2.get((Object)JType.SALVAGE).containsKey(regKey)) {
                    Object salvageStationBlock;
                    Iterator<Block> iterator = salvageStations.iterator();
                    while (iterator.hasNext() && !(matched = XP.scanBlock((Block)(salvageStationBlock = iterator.next()), 1, player2))) {
                    }
                    if (matched) {
                        event.setCanceled(true);
                    }
                }
                if (item instanceof BlockItem) {
                    if (!XP.checkReq(player2, item.getRegistryName(), JType.REQ_PLACE)) {
                        event.setCanceled(true);
                        if (isClientSide) {
                            player2.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToPlaceDown", new Object[]{new TranslatableComponent(item.m_5524_())}).m_6270_(XP.textStyle.get("red")), true);
                        }
                    }
                } else if (!XP.checkReq(player2, item.getRegistryName(), JType.REQ_USE)) {
                    event.setCanceled(true);
                    if (isClientSide) {
                        player2.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslatableComponent(item.m_5524_())}).m_6270_(XP.textStyle.get("red")), true);
                    }
                }
                if (event instanceof PlayerInteractEvent.RightClickBlock) {
                    Block block = player2.f_19853_.m_8055_(event.getPos()).m_60734_();
                    if (!XP.checkReq(player2, block.getRegistryName(), JType.REQ_USE)) {
                        if (XP.isPlayerSurvival(player2)) {
                            event.setCanceled(true);
                            if (isClientSide && event.getHand().equals((Object)InteractionHand.MAIN_HAND)) {
                                player2.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslatableComponent(block.m_7705_())}).m_6270_(XP.textStyle.get("red")), true);
                                player2.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslatableComponent(block.m_7705_())}).m_6270_(XP.textStyle.get("red")), false);
                                for (Map.Entry entry : JsonConfig.data.get((Object)JType.REQ_USE).get(block.getRegistryName().toString()).entrySet()) {
                                    double entryValue;
                                    int startLevel = Skill.getLevel((String)entry.getKey(), player2);
                                    if ((double)startLevel < (entryValue = ((Double)entry.getValue()).doubleValue())) {
                                        player2.m_5661_((Component)new TranslatableComponent("pmmo.levelDisplay", new Object[]{new TranslatableComponent("pmmo." + (String)entry.getKey()), DP.dpSoft(entryValue)}).m_6270_(XP.textStyle.get("red")), false);
                                        continue;
                                    }
                                    player2.m_5661_((Component)new TranslatableComponent("pmmo.levelDisplay", new Object[]{new TranslatableComponent("pmmo." + (String)entry.getKey()), DP.dpSoft(entryValue)}).m_6270_(XP.textStyle.get("green")), false);
                                }
                            }
                        }
                    } else {
                        event.setCanceled(false);
                        if (player2.m_6047_() && salvageStations.contains(block)) {
                            if (itemStack.m_41619_()) {
                                return;
                            }
                            if (isClientSide) {
                                return;
                            }
                            boolean mainCanBeSalvaged = PlayerInteractionHandler.canBeSalvaged(player2.m_21205_().m_41720_());
                            boolean bl = PlayerInteractionHandler.canBeSalvaged(player2.m_21206_().m_41720_());
                            if (!mainCanBeSalvaged && !bl) {
                                player2.m_5661_((Component)new TranslatableComponent("pmmo.cannotSalvage", new Object[]{new TranslatableComponent(item.m_5524_())}).m_6270_(XP.textStyle.get("red")), true);
                                return;
                            }
                            SalvageEvent salvageEvent = new SalvageEvent(player2, event.getPos());
                            if (MinecraftForge.EVENT_BUS.post((Event)salvageEvent)) {
                                return;
                            }
                            event.setCanceled(true);
                            if (!(XP.getHorizontalDistance(player2.m_20182_(), XP.blockToMiddleVec(event.getPos())) < 2.0)) {
                                player2.m_5661_((Component)new TranslatableComponent("pmmo.tooFarAwayToSalvage").m_6270_(XP.textStyle.get("red")), true);
                                return;
                            }
                            if (!XP.isPlayerSurvival(player2)) {
                                player2.m_5661_((Component)new TranslatableComponent("pmmo.survivalOnlyWarning").m_6270_(XP.textStyle.get("red")), true);
                                return;
                            }
                            PlayerInteractionHandler.salvageItem(player2, itemStack, event.getWorld(), event.getPos());
                            if ((double)Skill.getLevel(Skill.SMITHING.toString(), player2) >= Config.getConfig("dualSalvageSmithingLevelReq") && event.getHand().equals((Object)InteractionHand.MAIN_HAND) && bl) {
                                PlayerInteractionHandler.salvageItem(player2, player2.m_21206_(), event.getWorld(), event.getPos());
                            }
                        }
                    }
                }
            } else if (event instanceof PlayerInteractEvent.EntityInteractSpecific && !XP.checkReq(player = event.getPlayer(), reqMap = XP.getXp(target = (entityInteractEvent = (PlayerInteractEvent.EntityInteractSpecific)event).getTarget(), JType.REQ_ENTITY_INTERACT))) {
                event.setCanceled(true);
                boolean isClientSide = player.f_19853_.m_5776_();
                if (isClientSide && System.currentTimeMillis() - lastWarning > 1523L) {
                    player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToInteractWith", new Object[]{target.m_7755_()}).m_6270_(XP.textStyle.get("red")), false);
                    player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToInteractWith", new Object[]{target.m_7755_()}).m_6270_(XP.textStyle.get("red")), true);
                    XP.sendPlayerSkillList(player, reqMap);
                    lastWarning = System.currentTimeMillis();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    public static void salvageItem(Player player, ItemStack itemStack, Level world, BlockPos pos) {
        Item item = itemStack.m_41720_();
        String regKey = item.getRegistryName().toString();
        Map<String, Map<String, Double>> salvageFromItemMap = JsonConfig.data2.get((Object)JType.SALVAGE).get(regKey);
        if (salvageFromItemMap == null) {
            return;
        }
        boolean ableToSalvageAny = false;
        double award = 0.0;
        int startSmithingLevel = Skill.getLevel(Skill.SMITHING.toString(), player);
        Integer lowestReqLevel = null;
        for (Map.Entry<String, Map<String, Double>> salvageToItemEntry : salvageFromItemMap.entrySet()) {
            int smithingLevel = startSmithingLevel;
            Item salvageToItem = XP.getItem(salvageToItemEntry.getKey());
            Map<String, Double> salvageToItemMap = salvageToItemEntry.getValue();
            double baseChance = salvageToItemMap.get("baseChance");
            double chancePerLevel = salvageToItemMap.get("chancePerLevel");
            double maxSalvageMaterialChance = salvageToItemMap.get("maxChance");
            int reqLevel = (int)Math.floor(salvageToItemMap.get("levelReq"));
            int salvageMax = (int)Math.floor(salvageToItemMap.get("salvageMax"));
            smithingLevel -= reqLevel;
            if (lowestReqLevel == null || lowestReqLevel > reqLevel) {
                lowestReqLevel = reqLevel;
            }
            if (smithingLevel < 0) continue;
            ableToSalvageAny = true;
            double chance = baseChance + chancePerLevel * (double)smithingLevel;
            if (chance > maxSalvageMaterialChance) {
                chance = maxSalvageMaterialChance;
            }
            double startDmg = itemStack.m_41773_();
            double maxDmg = itemStack.m_41776_();
            double displayDurabilityPercent = (1.0 - startDmg / maxDmg) * 100.0;
            double durabilityPercent = 1.0 - startDmg / maxDmg;
            if (Double.isNaN(durabilityPercent)) {
                durabilityPercent = 1.0;
            }
            int potentialReturnAmount = (int)Math.floor((double)salvageMax * durabilityPercent);
            int returnAmount = 0;
            for (int i = 0; i < potentialReturnAmount; ++i) {
                if (!(Math.ceil(Math.random() * 10000.0) <= chance * 100.0)) continue;
                ++returnAmount;
            }
            award += salvageToItemMap.get("xpPerItem") * (double)returnAmount;
            if (returnAmount > 0) {
                XP.dropItems(returnAmount, salvageToItem, world, pos);
            }
            if (returnAmount == potentialReturnAmount) {
                NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageToItem.m_5524_(), false, 1), (ServerPlayer)player);
                continue;
            }
            if (returnAmount > 0) {
                NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageToItem.m_5524_(), false, 3), (ServerPlayer)player);
                continue;
            }
            NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageToItem.m_5524_(), true, 2), (ServerPlayer)player);
        }
        if (ableToSalvageAny) {
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)itemStack);
            double maxSalvageEnchantChance = Config.forgeConfig.maxSalvageEnchantChance.get();
            double enchantSaveChancePerLevel = Config.forgeConfig.enchantSaveChancePerLevel.get();
            double enchantChance = (double)(startSmithingLevel - lowestReqLevel) * enchantSaveChancePerLevel;
            if (enchantChance > maxSalvageEnchantChance) {
                enchantChance = maxSalvageEnchantChance;
            }
            if (enchants.size() > 0) {
                ItemStack salvagedBook = new ItemStack((ItemLike)Items.f_42690_);
                Set enchantKeys = enchants.keySet();
                HashMap<Enchantment, Integer> newEnchantMap = new HashMap<Enchantment, Integer>();
                boolean fullEnchants = true;
                for (Enchantment enchant : enchantKeys) {
                    int enchantLevel = 0;
                    for (int i = 1; i <= (Integer)enchants.get(enchant); ++i) {
                        if (Math.floor(Math.random() * 100.0) < enchantChance) {
                            enchantLevel = i;
                            continue;
                        }
                        fullEnchants = false;
                    }
                    if (enchantLevel <= 0) continue;
                    newEnchantMap.put(enchant, enchantLevel);
                }
                if (newEnchantMap.size() > 0) {
                    EnchantmentHelper.m_44865_(newEnchantMap, (ItemStack)salvagedBook);
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)salvagedBook);
                    if (fullEnchants) {
                        player.m_5661_((Component)new TranslatableComponent("pmmo.savedAllEnchants").m_6270_(XP.textStyle.get("green")), false);
                    } else {
                        player.m_5661_((Component)new TranslatableComponent("pmmo.savedSomeEnchants").m_6270_(XP.textStyle.get("yellow")), false);
                    }
                }
            }
            if (award > 0.0) {
                WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(world), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.523, (double)pos.m_123343_() + 0.5, 0.35, award, Skill.SMITHING.toString());
                XP.addWorldXpDrop(xpDrop, (ServerPlayer)player);
                XP.awardXp((ServerPlayer)player, Skill.SMITHING.toString(), item.getRegistryName().toString(), award, false, false, false);
            }
            itemStack.m_41774_(1);
            player.m_21190_(InteractionHand.OFF_HAND);
        } else {
            player.m_5661_((Component)new TranslatableComponent("pmmo.cannotSalvageLackLevelLonger", new Object[]{lowestReqLevel, new TranslatableComponent(item.m_5524_())}).m_6270_(XP.textStyle.get("red")), true);
        }
    }

    public static boolean canBeSalvaged(Item item) {
        return JsonConfig.data2.get((Object)JType.SALVAGE).containsKey(item.getRegistryName().toString());
    }
}

