/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.perks.PerkRegistry;
import harmonised.pmmo.api.perks.PerkTrigger;
import harmonised.pmmo.config.AutoValues;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.party.PartyMemberInfo;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class DamageHandler {
    private static final String SAVED = "saved";
    private static final String DAMAGE = "damage";

    public static double getEnduranceMultiplier(Player player) {
        double maxEndurance;
        double endurancePerLevel;
        int enduranceLevel = APIUtils.getLevel(Skill.ENDURANCE.toString(), player);
        double endurePercent = (double)enduranceLevel * (endurancePerLevel = Config.forgeConfig.endurancePerLevel.get().doubleValue());
        if (endurePercent > (maxEndurance = Config.forgeConfig.maxEndurance.get().doubleValue())) {
            endurePercent = maxEndurance;
        }
        return endurePercent /= 100.0;
    }

    public static void handleDamage(LivingHurtEvent event) {
        if (!(event.getEntity() instanceof FakePlayer)) {
            IndirectEntityDamageSource indirectSource;
            float damage = event.getAmount();
            if (event.getSource() instanceof IndirectEntityDamageSource && (indirectSource = (IndirectEntityDamageSource)event.getSource()).m_7640_() instanceof Fireball) {
                damage = Math.min(69.0f, damage);
            }
            float startDmg = damage;
            LivingEntity target = event.getEntityLiving();
            Entity source = event.getSource().m_7639_();
            if (target instanceof ServerPlayer) {
                boolean isFallDamage = event.getSource().m_19385_().equals("fall");
                ServerPlayer player = (ServerPlayer)target;
                ServerLevel world = player.m_183503_();
                double agilityXp = 0.0;
                boolean hideEndurance = false;
                if (source instanceof ServerPlayer && !(source instanceof FakePlayer)) {
                    ServerPlayer sourcePlayer = (ServerPlayer)source;
                    Party party = PmmoSavedData.get().getParty(player.m_142081_());
                    if (party != null) {
                        PartyMemberInfo sourceMemberInfo = party.getMemberInfo(sourcePlayer.m_142081_());
                        double friendlyFireMultiplier = Config.forgeConfig.partyFriendlyFireAmount.get() / 100.0;
                        if (sourceMemberInfo != null) {
                            damage = (float)((double)damage * friendlyFireMultiplier);
                        }
                    }
                }
                CompoundTag dataIn = new CompoundTag();
                dataIn.m_128347_("damageIn", (double)damage);
                CompoundTag perkOutput = PerkRegistry.executePerk(PerkTrigger.RECEIVE_DAMAGE, player, dataIn);
                double endured = perkOutput.m_128441_(SAVED) ? perkOutput.m_128459_(SAVED) : 0.0;
                damage = (float)((double)damage - endured);
                double enduranceXp = (double)Math.max(0.0f, damage * 5.0f) + endured * 7.5;
                if (isFallDamage) {
                    double award;
                    dataIn.m_128347_("damageIn", (double)damage);
                    perkOutput = PerkRegistry.executePerk(PerkTrigger.FALL_DAMAGE, player, dataIn);
                    int saved = perkOutput.m_128441_(SAVED) ? perkOutput.m_128451_(SAVED) : 0;
                    damage -= (float)saved;
                    if (saved != 0 && player.m_21223_() > damage) {
                        player.m_5661_((Component)new TranslatableComponent("pmmo.savedFall", new Object[]{saved}), true);
                    }
                    agilityXp = award = (double)(saved * 5);
                }
                if (player.m_21223_() > damage) {
                    WorldXpDrop xpDrop;
                    if (agilityXp > 0.0) {
                        hideEndurance = true;
                    }
                    Vec3 pos = player.m_20182_();
                    if (event.getSource().m_7639_() != null) {
                        XP.awardXp(player, Skill.ENDURANCE.toString(), event.getSource().m_7639_().m_5446_().getString(), enduranceXp, hideEndurance, false, false);
                    } else {
                        XP.awardXp(player, Skill.ENDURANCE.toString(), event.getSource().m_19385_(), enduranceXp, hideEndurance, false, false);
                    }
                    if (enduranceXp > 0.0) {
                        xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((Level)world), pos.m_7096_(), pos.m_7098_() + (double)player.m_20192_() + 0.523, pos.m_7094_(), 1.523, enduranceXp, Skill.ENDURANCE.toString());
                        XP.addWorldXpDrop(xpDrop, player);
                    }
                    if (agilityXp > 0.0) {
                        xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((Level)world), pos.m_7096_(), pos.m_7098_() + (double)player.m_20192_() + 0.523, pos.m_7094_(), 1.523, agilityXp, Skill.AGILITY.toString());
                        xpDrop.setSize(1.523f);
                        XP.addWorldXpDrop(xpDrop, player);
                        XP.awardXp(player, Skill.AGILITY.toString(), "surviving " + startDmg + " fall damage", agilityXp, false, false, false);
                    }
                }
            }
            if (target instanceof LivingEntity && event.getSource().m_7639_() instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)event.getSource().m_7639_();
                ServerLevel world = player.m_183503_();
                if (XP.isHoldingDebugItemInOffhand((Player)player)) {
                    player.m_5661_((Component)new TextComponent("regName:" + target.m_20078_()), false);
                    player.m_5661_((Component)new TextComponent("dmgType:" + event.getSource().f_19326_), false);
                }
                if (XP.isPlayerSurvival((Player)player)) {
                    String skill;
                    ItemStack mainItemStack = player.m_21205_();
                    Map<String, Double> weaponReq = XP.getXp(player.m_21205_(), JType.REQ_WEAPON);
                    NBTHelper.maxDoubleMaps(weaponReq, XP.getXp(player.m_21206_(), JType.REQ_WEAPON));
                    String itemSpecificSkill = AutoValues.getItemSpecificSkill(mainItemStack.m_41720_().getRegistryName().toString());
                    boolean swordInMainHand = mainItemStack.m_41720_() instanceof SwordItem;
                    if (itemSpecificSkill != null) {
                        skill = itemSpecificSkill;
                    } else if (event.getSource().f_19326_.equals("arrow")) {
                        skill = Skill.ARCHERY.toString();
                    } else {
                        skill = Skill.COMBAT.toString();
                        double d = Util.getDistance(player.m_20182_(), target.m_20182_());
                        double d2 = 4.2 + (double)target.m_20205_();
                        double d3 = swordInMainHand ? 1.523 : 0.0;
                        if (d > d2 + d3) {
                            skill = Skill.MAGIC.toString();
                        }
                    }
                    int killGap = 0;
                    int weaponGap = 0;
                    if (Config.getConfig("weaponReqEnabled") != 0.0) {
                        int enchantGap;
                        int gap;
                        if (Config.getConfig("autoGenerateValuesEnabled") != 0.0 && Config.getConfig("autoGenerateWeaponReqDynamicallyEnabled") != 0.0) {
                            weaponReq.put(skill, weaponReq.getOrDefault(skill, AutoValues.getWeaponReqFromStack(mainItemStack)));
                        }
                        if ((gap = Math.max(weaponGap = XP.getSkillReqGap((Player)player, weaponReq), enchantGap = XP.getSkillReqGap((Player)player, XP.getEnchantsUseReq(player.m_21205_())))) > 0) {
                            if (enchantGap < gap) {
                                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToUseAsWeapon", player.m_21205_().m_41778_(), "", true, 2), player);
                            }
                            if (Config.forgeConfig.strictReqWeapon.get().booleanValue()) {
                                event.setCanceled(true);
                                return;
                            }
                        }
                    }
                    CompoundTag dataIn = new CompoundTag();
                    dataIn.m_128350_("damageIn", damage);
                    dataIn.m_128365_("weapon_type", (Tag)AutoValues.getItemSpecificWeaponTypes(mainItemStack.m_41720_().getRegistryName().toString()));
                    CompoundTag dataOut = PerkRegistry.executePerk(PerkTrigger.DEAL_DAMAGE, player, dataIn);
                    float f = damage = dataOut.m_128441_(DAMAGE) ? damage + dataOut.m_128457_(DAMAGE) : damage;
                    if (target.m_20078_() != null && (killGap = Math.max(killGap, XP.getSkillReqGap((Player)player, XP.getResLoc(target.m_20078_()), JType.REQ_KILL))) > 0) {
                        player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToDamage", new Object[]{new TranslatableComponent(target.m_6095_().m_20675_())}).m_6270_(XP.textStyle.get("red")), true);
                        player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToDamage", new Object[]{new TranslatableComponent(target.m_6095_().m_20675_())}).m_6270_(XP.textStyle.get("red")), false);
                        XP.sendPlayerSkillList((Player)player, JsonConfig.data.get((Object)JType.REQ_KILL).get(target.m_20078_()));
                        if (Config.forgeConfig.strictReqKill.get().booleanValue()) {
                            event.setCanceled(true);
                            return;
                        }
                    }
                    float amount = 0.0f;
                    float playerHealth = player.m_21223_();
                    float targetHealth = target.m_21223_();
                    float targetMaxHealth = target.m_21233_();
                    float lowHpBonus = 1.0f;
                    damage /= (float)(weaponGap + 1);
                    amount += Math.min(damage /= (float)(killGap + 1), targetHealth) * 3.0f;
                    if (startDmg >= targetHealth) {
                        amount /= 2.0f;
                    }
                    if (startDmg >= targetMaxHealth) {
                        amount = (float)((double)amount / 1.5);
                    }
                    if (target instanceof Animal) {
                        amount /= 2.0f;
                    } else if (playerHealth <= 10.0f) {
                        lowHpBonus += (11.0f - playerHealth) / 5.0f;
                        if (playerHealth <= 2.0f) {
                            lowHpBonus += 1.0f;
                        }
                    }
                    double distance = Util.getHorizontalDistance(event.getEntity().m_20182_(), player.m_20182_());
                    if (skill.equals(Skill.COMBAT.toString())) {
                        amount *= lowHpBonus;
                    } else if (skill.equals(Skill.ARCHERY.toString())) {
                        distance = distance > 16.0 ? (distance -= 16.0) : 0.0;
                        amount = (float)((double)amount + Math.pow(distance, 1.3251) * (double)damage * 0.5 * (double)(damage / target.m_21233_()) * (damage >= targetMaxHealth ? 1.5 : 1.0));
                        amount *= lowHpBonus;
                    } else {
                        distance = distance > 32.0 ? (distance -= 32.0) : 0.0;
                        amount = (float)((double)amount + Math.pow(distance, 1.1523) * (double)damage * (double)0.05f * (double)(damage / target.m_21233_()) * (damage >= targetMaxHealth ? 1.5 : 1.0));
                        amount *= lowHpBonus;
                    }
                    Vec3 xpDropPos = target.m_20182_();
                    WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((Level)world), xpDropPos.m_7096_(), xpDropPos.m_7098_() + (double)target.m_20206_(), xpDropPos.m_7094_(), (double)target.m_20206_(), amount, skill);
                    XP.addWorldXpDrop(xpDrop, player);
                    Map<String, Double> entityMap = XP.getXp((Entity)target, JType.XP_MULTIPLIER_ENTITY);
                    if (entityMap.containsKey(skill)) {
                        amount = (float)((double)amount * entityMap.get(skill));
                    }
                    XP.awardXp(player, skill, player.m_21205_().m_41786_().toString(), amount, false, false, false);
                    if (weaponGap > 0) {
                        player.m_21205_().m_41622_(weaponGap - 1, (LivingEntity)player, a -> a.m_21190_(InteractionHand.MAIN_HAND));
                    }
                }
            }
            event.setAmount(damage);
            if (event.getAmount() <= 0.0f) {
                event.setCanceled(true);
            }
        }
    }
}

