/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.world.ChunkDataEvent;

public class ChunkDataHandler {
    private static Map<ResourceLocation, Map<ChunkPos, Map<BlockPos, UUID>>> placedMap = new HashMap<ResourceLocation, Map<ChunkPos, Map<BlockPos, UUID>>>();

    public static void init() {
        placedMap = new HashMap<ResourceLocation, Map<ChunkPos, Map<BlockPos, UUID>>>();
    }

    public static void handleChunkDataLoad(ChunkDataEvent.Load event) {
        CompoundTag levelNBT;
        CompoundTag chunkNBT = event.getData();
        if (chunkNBT != null && (levelNBT = chunkNBT.m_128469_("Level")).m_128441_("placedPos")) {
            CompoundTag placedPosNBT;
            Level world = (Level)event.getWorld();
            ResourceLocation dimResLoc = XP.getDimResLoc(world);
            ChunkPos chunkPos = event.getChunk().m_7697_();
            if (!placedMap.containsKey(dimResLoc)) {
                placedMap.put(dimResLoc, new HashMap());
            }
            if ((placedPosNBT = (CompoundTag)levelNBT.m_128423_("placedPos")) == null) {
                return;
            }
            Map<ChunkPos, Map<BlockPos, UUID>> chunkMap = placedMap.get(dimResLoc);
            HashMap blockMap = new HashMap();
            Set keySet = placedPosNBT.m_128431_();
            keySet.forEach(key -> {
                CompoundTag entry = placedPosNBT.m_128469_(key);
                blockMap.put(NbtUtils.m_129239_((CompoundTag)entry.m_128469_("pos")), new UUID(entry.m_128469_("UUID").m_128454_("M"), entry.m_128469_("UUID").m_128454_("L")));
            });
            chunkMap.remove(chunkPos);
            chunkMap.put(chunkPos, blockMap);
        }
    }

    public static void handleChunkDataSave(ChunkDataEvent.Save event) {
        Level world = (Level)event.getWorld();
        ResourceLocation dimResLoc = XP.getDimResLoc(world);
        if (placedMap.containsKey(dimResLoc)) {
            ChunkPos chunkPos = event.getChunk().m_7697_();
            if (placedMap.get(dimResLoc).containsKey(chunkPos)) {
                if (!event.getData().m_128441_("Level")) {
                    event.getData().m_128365_("Level", (Tag)new CompoundTag());
                }
                CompoundTag levelNBT = (CompoundTag)event.getData().m_128423_("Level");
                CompoundTag newPlacedNBT = new CompoundTag();
                int i = 0;
                for (Map.Entry<BlockPos, UUID> entry : placedMap.get(dimResLoc).get(chunkPos).entrySet()) {
                    CompoundTag insidesNBT = new CompoundTag();
                    insidesNBT.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry.getKey()));
                    insidesNBT.m_128365_("UUID", (Tag)XP.writeUniqueId(entry.getValue()));
                    newPlacedNBT.m_128365_("" + i++, (Tag)insidesNBT);
                }
                levelNBT.m_128365_("placedPos", (Tag)newPlacedNBT);
            }
        }
    }

    public static void addPos(ResourceLocation dimResLoc, BlockPos blockPos, UUID uuid) {
        Map<ChunkPos, Map<BlockPos, UUID>> chunkMap;
        ChunkPos chunkPos = new ChunkPos(blockPos);
        if (!placedMap.containsKey(dimResLoc)) {
            placedMap.put(dimResLoc, new HashMap());
        }
        if (!(chunkMap = placedMap.get(dimResLoc)).containsKey(chunkPos)) {
            chunkMap.put(chunkPos, new HashMap());
        }
        Map<BlockPos, UUID> blockMap = chunkMap.get(chunkPos);
        blockMap.put(blockPos, uuid);
    }

    public static void delPos(ResourceLocation dimResLoc, BlockPos blockPos) {
        Map<ChunkPos, Map<BlockPos, UUID>> chunkMap;
        ChunkPos chunkPos = new ChunkPos(blockPos);
        if (!placedMap.containsKey(dimResLoc)) {
            placedMap.put(dimResLoc, new HashMap());
        }
        if (!(chunkMap = placedMap.get(dimResLoc)).containsKey(chunkPos)) {
            chunkMap.put(chunkPos, new HashMap());
        }
        Map<BlockPos, UUID> blockMap = chunkMap.get(chunkPos);
        blockMap.remove(blockPos);
    }

    public static UUID checkPos(Level world, BlockPos pos) {
        return ChunkDataHandler.checkPos(XP.getDimResLoc(world), pos);
    }

    public static UUID checkPos(ResourceLocation dimResLoc, BlockPos blockPos) {
        return (UUID)((Map)((Map)placedMap.getOrDefault(dimResLoc, new HashMap())).getOrDefault(new ChunkPos(blockPos), new HashMap())).get(blockPos);
    }
}

