/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.TooltipSupplier;
import harmonised.pmmo.config.AutoValues;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class BreakSpeedHandler {
    public static void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        boolean breakReqMet;
        Player player = event.getPlayer();
        if (player instanceof FakePlayer) {
            return;
        }
        String skill = XP.getSkill(event.getState()).toLowerCase();
        ItemStack itemStack = player.m_21205_();
        ResourceLocation resLoc = itemStack.m_41720_().getRegistryName();
        if (resLoc == null) {
            return;
        }
        Map<String, Double> toolReq = TooltipSupplier.getTooltipData(resLoc, JType.REQ_TOOL, itemStack);
        if (Config.getConfig("toolReqEnabled") != 0.0 && Config.getConfig("autoGenerateValuesEnabled") != 0.0 && Config.getConfig("autoGenerateToolReqDynamicallyEnabled") != 0.0) {
            Map<String, Double> dynToolReq = AutoValues.getToolReqFromStack(itemStack);
            for (Map.Entry<String, Double> entry : dynToolReq.entrySet()) {
                if (toolReq.containsKey(entry.getKey())) continue;
                toolReq.put(entry.getKey(), Math.max(1.0, entry.getValue()));
            }
        }
        int toolGap = XP.getSkillReqGap(player, toolReq);
        int enchantGap = XP.getSkillReqGap(player, XP.getEnchantsUseReq(player.m_21205_()));
        int gap = Math.max(toolGap, enchantGap);
        boolean bl = breakReqMet = event.getState().m_155947_() ? XP.checkReq(player, event.getEntity().m_20193_().m_7702_(event.getPos()), JType.REQ_BREAK) : XP.checkReq(player, event.getState().m_60734_().getRegistryName(), JType.REQ_BREAK);
        if (!breakReqMet) {
            player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToBreak", new Object[]{new TranslatableComponent(event.getState().m_60734_().m_7705_())}).m_6270_(XP.textStyle.get("red")), true);
            event.setCanceled(true);
            return;
        }
        if (gap > 0) {
            if (enchantGap < gap) {
                player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToUseAsTool", new Object[]{new TranslatableComponent(player.m_21205_().m_41778_())}).m_6270_(XP.textStyle.get("red")), true);
            }
            if (Config.getConfig("strictReqTool") == 1.0) {
                event.setCanceled(true);
                return;
            }
        }
        int startLevel = Skill.getLevel(skill, player);
        switch (XP.getHarvestTool(event.getState())) {
            case "pickaxe": {
                double blocksToUnbreakableY;
                double heightMultiplier;
                float height = event.getPos().m_123342_();
                if (height < 0.0f) {
                    height = -height;
                }
                if ((heightMultiplier = 1.0 - (double)height / (blocksToUnbreakableY = Config.forgeConfig.blocksToUnbreakableY.get().doubleValue())) < Config.forgeConfig.minBreakSpeed.get()) {
                    heightMultiplier = Config.forgeConfig.minBreakSpeed.get();
                }
                double speedBonus = Config.forgeConfig.miningBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getNewSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus) * (float)heightMultiplier);
                break;
            }
            case "axe": {
                double speedBonus = Config.forgeConfig.woodcuttingBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getNewSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
            case "shovel": {
                double speedBonus = Config.forgeConfig.excavationBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getNewSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
            case "hoe": {
                double speedBonus = Config.forgeConfig.farmingBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getNewSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
        }
        event.setNewSpeed(event.getNewSpeed() / (float)(toolGap + 1));
    }
}

