/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.events.TreasureEvent;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.gui.WorldText;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.skills.VeinInfo;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockBrokenHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Map<ResourceLocation, Map<BlockPos, Long>> cooldownTracker = new HashMap<ResourceLocation, Map<BlockPos, Long>>();

    public static void handleBroken(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof FakePlayer)) {
            BlockBrokenHandler.processReq(event);
        }
        ChunkDataHandler.delPos(XP.getDimResLoc((Level)event.getWorld()), event.getPos());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processReq(BlockEvent.BreakEvent event) {
        Map<BlockPos, Long> dimCooldownTracker;
        Long cooldownSince;
        Player player = event.getPlayer();
        BlockState blockState = event.getState();
        Block block = blockState.m_60734_();
        BlockPos pos = event.getPos();
        Level world = (Level)event.getWorld();
        Block blockAbove = world.m_8055_(pos.m_7494_()).m_60734_();
        ResourceLocation dimResLoc = XP.getDimResLoc((Level)event.getWorld());
        boolean passedBreakReq = true;
        if (!cooldownTracker.containsKey(dimResLoc)) {
            cooldownTracker.put(dimResLoc, new HashMap());
        }
        if ((cooldownSince = (dimCooldownTracker = cooldownTracker.get(dimResLoc)).get(pos)) != null) {
            if (System.currentTimeMillis() - cooldownSince <= 50L) return;
            dimCooldownTracker.remove(pos);
        } else {
            dimCooldownTracker.put(pos, System.currentTimeMillis());
        }
        if (XP.isHoldingDebugItemInOffhand(player)) {
            player.m_5661_((Component)new TextComponent(block.getRegistryName().toString()), false);
        }
        if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(blockAbove.getRegistryName().toString()) && blockAbove instanceof IPlantable) {
            passedBreakReq = XP.checkReq(player, blockAbove.getRegistryName(), JType.REQ_BREAK);
        }
        if (!passedBreakReq) {
            block = blockAbove;
        } else {
            passedBreakReq = XP.checkReq(player, block.getRegistryName(), JType.REQ_BREAK);
        }
        if (passedBreakReq) {
            if (!XP.checkReq(player, player.m_21205_().m_41720_().getRegistryName(), JType.REQ_TOOL)) return;
            BlockBrokenHandler.processBroken(event);
            ChunkDataHandler.delPos(XP.getDimResLoc(world), pos);
            return;
        } else {
            if (XP.getHarvestTool(blockState).equals("axe")) {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToChop", block.m_7705_(), "", true, 2), (ServerPlayer)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToChop", block.m_7705_(), "", false, 2), (ServerPlayer)player);
            } else if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(blockAbove.getRegistryName().toString()) || block instanceof IPlantable) {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToHarvest", block.m_7705_(), "", true, 2), (ServerPlayer)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToHarvest", block.m_7705_(), "", false, 2), (ServerPlayer)player);
            } else {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToBreak", block.m_7705_(), "", true, 2), (ServerPlayer)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToBreak", block.m_7705_(), "", false, 2), (ServerPlayer)player);
            }
            for (Map.Entry<String, Double> entry : JsonConfig.data.get((Object)JType.REQ_BREAK).get(block.getRegistryName().toString()).entrySet()) {
                double entryValue;
                int startLevel = Skill.getLevel(entry.getKey(), player);
                if ((double)startLevel < (entryValue = entry.getValue().doubleValue())) {
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.levelDisplay", "pmmo." + entry.getKey(), "" + (int)Math.floor(entryValue), false, 2), (ServerPlayer)player);
                    continue;
                }
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.levelDisplay", "pmmo." + entry.getKey(), "" + (int)Math.floor(entryValue), false, 1), (ServerPlayer)player);
            }
            event.setCanceled(true);
        }
    }

    private static void processBroken(BlockEvent.BreakEvent event) {
        int gap;
        ItemStack theDropItem;
        boolean veiningAllowed;
        BlockState state = event.getState();
        if (state.m_60767_().m_76332_()) {
            return;
        }
        Block block = state.m_60734_();
        BlockPos pos = event.getPos();
        String regKey = block.getRegistryName().toString();
        BlockEntity tile = event.getWorld().m_7702_(event.getPos());
        Map<String, Double> xpMap = tile == null ? XP.getXpBypass(block.getRegistryName(), JType.XP_VALUE_BREAK) : XP.getXp(tile, JType.XP_VALUE_BREAK);
        Level world = (Level)event.getWorld();
        BlockEntity tileEntity = world.m_7702_(event.getPos());
        if (tileEntity != null) {
            tileEntity = BlockEntity.m_155241_((BlockPos)pos, (BlockState)state, (CompoundTag)tileEntity.serializeNBT());
        }
        boolean isClientSide = world.m_5776_();
        Player player = event.getPlayer();
        boolean bl = veiningAllowed = Config.getConfig("veiningAllowed") != 0.0;
        if (XP.isVeining.contains(player.m_142081_()) && veiningAllowed && !WorldTickHandler.activeVein.containsKey(player)) {
            WorldTickHandler.scheduleVein(player, new VeinInfo(world, state, event.getPos(), player.m_21205_()));
        }
        if (!XP.isPlayerSurvival(player) || isClientSide) {
            return;
        }
        Material material = event.getState().m_60767_();
        double blockHardnessLimitForBreaking = Config.forgeConfig.blockHardnessLimitForBreaking.get();
        boolean wasPlaced = ChunkDataHandler.checkPos(world, event.getPos()) != null;
        ItemStack toolUsed = player.m_21205_();
        String skill = XP.getSkill(state);
        double hardness = Math.min(blockHardnessLimitForBreaking, (double)state.m_60800_((BlockGetter)event.getWorld(), event.getPos()));
        boolean isEffective = true;
        Object awardMsg = "";
        switch (XP.getSkill(state)) {
            case "mining": {
                awardMsg = "Mining";
                break;
            }
            case "woodcutting": {
                awardMsg = "Chopping";
                break;
            }
            case "excavation": {
                awardMsg = "Digging";
                break;
            }
            case "farming": {
                awardMsg = "Harvesting";
                break;
            }
            default: {
                awardMsg = "Breaking";
            }
        }
        awardMsg = (String)awardMsg + " " + block.getRegistryName();
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)player.m_21205_());
        int fortune = 0;
        if (enchants.get(Enchantments.f_44987_) != null) {
            fortune = (Integer)enchants.get(Enchantments.f_44987_);
        }
        boolean dropsItself = false;
        List drops = null;
        if (block.canHarvestBlock(state, (BlockGetter)world, player.m_142538_(), player)) {
            try {
                if (world instanceof ServerLevel) {
                    LootContext.Builder builder = new LootContext.Builder((ServerLevel)world).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)toolUsed).m_78972_(LootContextParams.f_81455_, (Object)player).m_78984_(LootContextParams.f_81462_, (Object)tileEntity);
                    if (fortune > 0) {
                        builder.m_78963_((float)fortune);
                    }
                    drops = block.m_7381_(event.getState(), builder);
                    if (EnchantmentHelper.m_44831_((ItemStack)toolUsed).containsKey(Enchantments.f_44985_)) {
                        List noSilkDrops;
                        ItemStack noEnchantTool = toolUsed.m_41777_();
                        noEnchantTool.m_41749_("Enchantments");
                        builder = new LootContext.Builder((ServerLevel)world).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)noEnchantTool).m_78972_(LootContextParams.f_81455_, (Object)player).m_78984_(LootContextParams.f_81462_, (Object)tileEntity);
                        if (fortune > 0) {
                            builder.m_78963_((float)fortune);
                        }
                        if ((noSilkDrops = block.m_7381_(event.getState(), builder)).size() > 0 && ((ItemStack)noSilkDrops.get(0)).m_41720_().equals(block.m_5456_())) {
                            dropsItself = true;
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
        if (drops == null) {
            drops = new ArrayList();
        }
        HashMap<String, Double> award = new HashMap<String, Double>();
        award.put(skill, hardness);
        int dropItemCount = 0;
        if (drops.size() > 0) {
            dropItemCount = ((ItemStack)drops.get(0)).m_41613_();
            if (((ItemStack)drops.get(0)).m_41720_().equals(block.m_5456_())) {
                dropsItself = true;
            }
        }
        if (!wasPlaced) {
            XP.addMapsAnyDouble(award, XP.multiplyMapAnyDouble(xpMap, Math.max(dropItemCount, 1)));
        }
        ItemStack itemStack = theDropItem = drops.size() > 0 ? (ItemStack)drops.get(0) : ItemStack.f_41583_;
        if (JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).containsKey(regKey) && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).get(regKey).containsKey("growsUpwards")) {
            Block baseBlock = event.getState().m_60734_();
            BlockPos baseBlockPos = event.getPos();
            double extraChance = XP.getExtraChance(player.m_142081_(), block.getRegistryName(), JType.INFO_PLANT, false) / 100.0;
            int totalDrops = 0;
            guaranteedDrop = 0;
            extraDrop = 0;
            int rewardable = 0;
            int guaranteedDropEach = (int)Math.floor(extraChance);
            extraChance = (extraChance - Math.floor(extraChance)) * 100.0;
            int height = 0;
            BlockPos curBlockPos = new BlockPos(baseBlockPos.m_123341_(), baseBlockPos.m_123342_() + height, baseBlockPos.m_123343_());
            block = world.m_8055_(curBlockPos).m_60734_();
            boolean correctBlock = block.equals(baseBlock);
            while (correctBlock) {
                BlockPos nextPos;
                Block nextBlock;
                boolean bl2 = wasPlaced = ChunkDataHandler.checkPos(world, curBlockPos) != null;
                if (!wasPlaced) {
                    ++rewardable;
                    guaranteedDrop += guaranteedDropEach;
                    if (Math.ceil(Math.random() * 1000.0) <= extraChance * 10.0) {
                        ++extraDrop;
                    }
                }
                if ((nextBlock = world.m_8055_(nextPos = new BlockPos(baseBlockPos.m_123341_(), baseBlockPos.m_123342_() + ++height, baseBlockPos.m_123343_())).m_60734_()).equals(baseBlock)) {
                    curBlockPos = nextPos;
                    block = nextBlock;
                    continue;
                }
                correctBlock = false;
            }
            int dropsLeft = guaranteedDrop + extraDrop;
            if (dropsLeft > 0) {
                XP.dropItems(dropsLeft, block.m_5456_(), world, event.getPos());
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + dropsLeft, theDropItem.m_41778_(), true, 1), (ServerPlayer)player);
            }
            totalDrops = rewardable + dropsLeft;
            award.put(skill, hardness);
            XP.addMapsAnyDouble(award, xpMap);
            XP.multiplyMapAnyDouble(award, totalDrops);
            awardMsg = "removing " + height + " + " + (guaranteedDrop + extraDrop) + " extra " + block.getRegistryName();
        } else if ((material.equals(Material.f_76300_) || material.equals(Material.f_76301_) || material.equals(Material.f_76302_)) && drops.size() > 0) {
            award = new HashMap();
            award.put(skill, hardness);
            int age = -1;
            int maxAge = -1;
            if (state.m_61138_((Property)BlockStateProperties.f_61405_)) {
                age = (Integer)state.m_61143_((Property)BlockStateProperties.f_61405_);
                maxAge = 1;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61406_)) {
                age = (Integer)state.m_61143_((Property)BlockStateProperties.f_61406_);
                maxAge = 2;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61407_)) {
                age = (Integer)state.m_61143_((Property)BlockStateProperties.f_61407_);
                maxAge = 3;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61408_)) {
                age = (Integer)state.m_61143_((Property)BlockStateProperties.f_61408_);
                maxAge = 5;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61409_)) {
                age = (Integer)state.m_61143_((Property)BlockStateProperties.f_61409_);
                maxAge = 7;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61410_)) {
                age = (Integer)state.m_61143_((Property)BlockStateProperties.f_61410_);
                maxAge = 15;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61411_)) {
                age = (Integer)state.m_61143_((Property)BlockStateProperties.f_61411_);
                maxAge = 25;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61425_)) {
                age = (Integer)state.m_61143_((Property)BlockStateProperties.f_61425_);
                maxAge = 4;
                if (wasPlaced) {
                    return;
                }
            }
            if (age == maxAge && age >= 0 || block instanceof SeaPickleBlock) {
                double extraChance = XP.getExtraChance(player.m_142081_(), block.getRegistryName(), JType.INFO_PLANT, false) / 100.0;
                guaranteedDrop = (int)extraChance;
                int totalExtraDrops = guaranteedDrop + (extraDrop = XP.rollChance(extraChance % 1.0) ? 1 : 0);
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop + extraDrop, theDropItem.m_41720_(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, theDropItem.m_41720_().m_5524_(), true, 1), (ServerPlayer)player);
                }
                awardMsg = "Harvesting " + dropItemCount + " + " + totalExtraDrops + " " + block.getRegistryName();
                XP.multiplyMapAnyDouble(XP.addMapsAnyDouble(award, xpMap), dropItemCount + totalExtraDrops);
            } else if (!wasPlaced) {
                awardMsg = "Breaking " + block.getRegistryName();
                XP.multiplyMapAnyDouble(XP.addMapsAnyDouble(award, xpMap), dropItemCount);
            }
        }
        if (XP.getExtraChance(player.m_142081_(), block.getRegistryName(), JType.INFO_ORE, false) > 0.0) {
            boolean isSilk;
            award = new HashMap();
            award.put(skill, hardness);
            boolean bl3 = isSilk = enchants.get(Enchantments.f_44985_) != null;
            if (!wasPlaced && !isSilk) {
                XP.addMapsAnyDouble(award, XP.multiplyMapAnyDouble(tile == null ? XP.getXpBypass(block.getRegistryName(), JType.XP_VALUE_BREAK) : XP.getXp(tile, JType.XP_VALUE_BREAK), theDropItem.m_41613_()));
            }
            if (dropsItself && !wasPlaced || !dropsItself && !isSilk) {
                double extraChance = XP.getExtraChance(player.m_142081_(), block.getRegistryName(), JType.INFO_ORE, false) / 100.0;
                int guaranteedDrop = (int)extraChance;
                int extraDrop = XP.rollChance(extraChance % 1.0) ? 1 : 0;
                int totalExtraDrops = guaranteedDrop + extraDrop;
                if (!dropsItself && wasPlaced) {
                    XP.addMapsAnyDouble(award, XP.multiplyMapAnyDouble(tile == null ? XP.getXpBypass(block.getRegistryName(), JType.XP_VALUE_BREAK) : XP.getXp(tile, JType.XP_VALUE_BREAK), theDropItem.m_41613_()));
                }
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop + extraDrop, theDropItem.m_41720_(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, theDropItem.m_41720_().m_5524_(), true, 1), (ServerPlayer)player);
                }
                XP.addMapsAnyDouble(award, XP.multiplyMapAnyDouble(tile == null ? XP.getXpBypass(block.getRegistryName(), JType.XP_VALUE_BREAK) : XP.getXp(tile, JType.XP_VALUE_BREAK), totalExtraDrops));
            }
            awardMsg = "Mining " + block.getRegistryName();
        }
        if (XP.getExtraChance(player.m_142081_(), block.getRegistryName(), JType.INFO_LOG, false) > 0.0 && isEffective) {
            if (!wasPlaced) {
                award = new HashMap();
                award.put(skill, hardness);
                double extraChance = XP.getExtraChance(player.m_142081_(), block.getRegistryName(), JType.INFO_LOG, false) / 100.0;
                int guaranteedDrop = (int)extraChance;
                int extraDrop = XP.rollChance(extraChance % 1.0) ? 1 : 0;
                int totalExtraDrops = guaranteedDrop + extraDrop;
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop + extraDrop, theDropItem.m_41720_(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, theDropItem.m_41720_().m_5524_(), true, 1), (ServerPlayer)player);
                }
                XP.multiplyMapAnyDouble(XP.addMapsAnyDouble(award, xpMap), dropItemCount + totalExtraDrops);
            }
            awardMsg = "Chopping " + block.getRegistryName().toString();
        }
        if (JsonConfig.data2.get((Object)JType.TREASURE).containsKey(block.getRegistryName().toString()) && !wasPlaced) {
            Map<String, Map<String, Double>> treasurePool = JsonConfig.data2.get((Object)JType.TREASURE).get(block.getRegistryName().toString());
            int excavationLevel = Skill.getLevel(Skill.EXCAVATION.toString(), player);
            for (Map.Entry<String, Map<String, Double>> treasureItem : treasurePool.entrySet()) {
                boolean foundTreasure = false;
                Map<String, Double> treasureItemMap = treasureItem.getValue();
                double chance = BlockBrokenHandler.getTreasureItemChance(excavationLevel, treasureItemMap);
                if (Math.ceil(Math.random() * 10000.0) <= chance * 100.0) {
                    Item item = XP.getItem(treasureItem.getKey());
                    int minCount = (int)Math.floor(treasureItemMap.get("minCount"));
                    int maxCount = (int)Math.floor(treasureItemMap.get("maxCount"));
                    int count = (int)Math.floor(Math.random() * (double)maxCount + (double)minCount);
                    Map<String, Double> treasureAward = new HashMap<String, Double>();
                    treasureAward.put(Skill.EXCAVATION.toString(), treasureItemMap.get("xpPerItem") * (double)count);
                    BlockPos treasurePos = event.getPos();
                    ItemStack itemStack2 = new ItemStack((ItemLike)item, count);
                    TreasureEvent treasureEvent = new TreasureEvent(player, treasurePos, itemStack2, treasureAward);
                    if (MinecraftForge.EVENT_BUS.post((Event)treasureEvent)) {
                        return;
                    }
                    treasurePos = treasureEvent.getBlockPos();
                    itemStack2 = treasureEvent.getItemStack();
                    treasureAward = treasureEvent.getAward();
                    XP.dropItemStack(itemStack2, world, treasurePos);
                    foundTreasure = true;
                    XP.addMapsAnyDouble(award, treasureAward);
                    player.m_5661_((Component)new TranslatableComponent("pmmo.youFoundTreasureItem", new Object[]{count, new TranslatableComponent(itemStack2.m_41778_())}).m_6270_(XP.textStyle.get("green")), false);
                    LOGGER.debug(player.m_5446_().getString() + " found Treasure! " + count + " " + treasureItem.getKey() + " " + event.getPos());
                }
                if (!foundTreasure) continue;
                player.m_5661_((Component)new TranslatableComponent("pmmo.youFoundTreasure").m_6270_(XP.textStyle.get("green")), true);
            }
        }
        if ((gap = XP.getSkillReqGap(player, player.m_21205_().m_41720_().getRegistryName(), JType.REQ_TOOL)) > 0) {
            player.m_21205_().m_41622_(gap - 1, (LivingEntity)player, a -> a.m_21190_(InteractionHand.MAIN_HAND));
        }
        ResourceLocation dimResLoc = XP.getDimResLoc(world);
        for (String awardSkillName : award.keySet()) {
            double xp = (Double)award.get(awardSkillName) / (double)(gap + 1);
            if ((int)(Math.random() * 152369.0) == 0) {
                for (int i = 0; i < 1000; ++i) {
                    WorldText worldText = WorldText.fromBlockPos(XP.getDimResLoc(world), pos.m_142385_((int)(Math.random() * 30.0 - 15.0)).m_142390_((int)(Math.random() * 30.0 - 15.0)), pos.m_142385_((int)(Math.random() * 60.0 - 30.0)).m_142390_((int)(Math.random() * 60.0 - 30.0)).m_6630_(25));
                    worldText.setMaxOffset(0.25f);
                    String text = "";
                    switch ((int)(Math.random() * 4.0)) {
                        case 0: {
                            text = "owo";
                            break;
                        }
                        case 1: {
                            text = "OwO";
                            break;
                        }
                        case 2: {
                            text = "uwu";
                            break;
                        }
                        case 3: {
                            text = "UwU";
                        }
                    }
                    worldText.setText(text);
                    worldText.setHueColor(true);
                    worldText.setEndHue(1080.0f);
                    worldText.setStartSize(0.0f);
                    worldText.setEndSize(50.0f);
                    worldText.setSecondsLifespan((float)(10.0 + Math.random() * 50.0));
                    worldText.setStartRot((float)(Math.random() * 360.0 - 180.0));
                    worldText.setEndRot((float)(Math.random() * 360.0 - 180.0));
                    XP.addWorldTextRadius(dimResLoc, worldText, 128.0);
                }
            }
            WorldXpDrop xpDrop = WorldXpDrop.fromBlockPos(XP.getDimResLoc(world), pos, 0.25, xp, awardSkillName);
            xpDrop.setDecaySpeed(1.25);
            XP.addWorldXpDrop(xpDrop, (ServerPlayer)player);
            Skill.addXp(awardSkillName, (ServerPlayer)player, (double)((Double)award.get(awardSkillName)), (String)awardMsg, false, false);
        }
    }

    public static double getTreasureItemChance(int level, Map<String, Double> map) {
        return Util.mapCapped(level, map.get("startLevel"), map.get("endLevel"), map.get("startChance"), map.get("endChance"));
    }
}

