/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.MessageTripleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnvilRepairHandler {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void handleAnvilRepair(AnvilRepairEvent event) {
        if (Config.forgeConfig.anvilHandlingEnabled.get().booleanValue()) {
            try {
                if (!event.getPlayer().f_19853_.f_46443_) {
                    ServerPlayer player = (ServerPlayer)event.getPlayer();
                    boolean bypassEnchantLimit = Config.forgeConfig.bypassEnchantLimit.get();
                    int currLevel = Skill.getLevel(Skill.SMITHING.toString(), (Player)player);
                    ItemStack rItem = event.getIngredientInput();
                    ItemStack lItem = event.getItemInput();
                    ItemStack oItem = event.getItemResult();
                    if (event.getItemInput().m_41720_().m_41465_()) {
                        float repaired;
                        double anvilCostReductionPerLevel = Config.forgeConfig.anvilCostReductionPerLevel.get();
                        double extraChanceToNotBreakAnvilPerLevel = Config.forgeConfig.extraChanceToNotBreakAnvilPerLevel.get() / 100.0;
                        double anvilFinalItemBonusRepaired = Config.forgeConfig.anvilFinalItemBonusRepaired.get() / 100.0;
                        int anvilFinalItemMaxCostToAnvil = Config.forgeConfig.anvilFinalItemMaxCostToAnvil.get();
                        double bonusRepair = anvilFinalItemBonusRepaired * (double)currLevel;
                        int maxCost = (int)Math.floor(50.0 - (double)currLevel * anvilCostReductionPerLevel);
                        if (maxCost < anvilFinalItemMaxCostToAnvil) {
                            maxCost = anvilFinalItemMaxCostToAnvil;
                        }
                        event.setBreakChance(event.getBreakChance() / (1.0f + (float)extraChanceToNotBreakAnvilPerLevel * (float)currLevel));
                        if (oItem.m_41610_() > maxCost) {
                            oItem.m_41742_(maxCost);
                        }
                        if ((repaired = (float)(oItem.m_41773_() - lItem.m_41773_())) < 0.0f) {
                            repaired = -repaired;
                        }
                        oItem.m_41721_((int)Math.floor((double)oItem.m_41773_() - (double)repaired * bonusRepair));
                        double award = ((double)repaired + (double)repaired * bonusRepair * 2.5) / 100.0 * (1.0 + (double)lItem.m_41610_() * 0.025);
                        if (award > 0.0) {
                            Vec3 pos = player.m_20182_();
                            WorldXpDrop xpDrop = WorldXpDrop.fromVector(XP.getDimResLoc((Level)player.m_183503_()), new Vec3(pos.m_7096_(), pos.m_7098_() + (double)player.m_20192_(), pos.m_7094_()).m_82549_(player.m_20154_().m_82542_(1.523, 1.523, 1.523)), 0.523, award, Skill.SMITHING.toString());
                            xpDrop.setDecaySpeed(0.25);
                            xpDrop.setSize(2.0f);
                            XP.addWorldXpDrop(xpDrop, player);
                            NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraRepaired", "" + (int)repaired, "" + (int)((double)repaired * bonusRepair), true, 1), player);
                            XP.awardXp(player, Skill.SMITHING.toString(), "repairing an item by: " + repaired, award, false, false, false);
                        }
                    }
                    if (bypassEnchantLimit) {
                        Map lEnchants = EnchantmentHelper.m_44831_((ItemStack)rItem);
                        Map rEnchants = EnchantmentHelper.m_44831_((ItemStack)lItem);
                        Map<Enchantment, Integer> newEnchants = AnvilRepairHandler.mergeEnchants(lEnchants, rEnchants, (Player)player, currLevel);
                        EnchantmentHelper.m_44865_(newEnchants, (ItemStack)oItem);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("ANVIL FAILED, PLEASE REPORT", (Throwable)e);
            }
        }
    }

    public static Map<Enchantment, Integer> mergeEnchants(Map<Enchantment, Integer> lEnchants, Map<Enchantment, Integer> rEnchants, Player player, int currLevel) {
        HashMap<Enchantment, Integer> newEnchants = new HashMap<Enchantment, Integer>();
        double bypassChance = Config.forgeConfig.upgradeChance.get();
        double failedBypassPenaltyChance = Config.forgeConfig.failedUpgradeKeepLevelChance.get();
        int levelsPerOneEnchantBypass = Config.forgeConfig.levelsPerOneEnchantBypass.get();
        int maxEnchantmentBypass = Config.forgeConfig.maxEnchantmentBypass.get();
        int maxEnchantLevel = Config.forgeConfig.maxEnchantLevel.get();
        boolean alwaysUseUpgradeChance = Config.forgeConfig.alwaysUseUpgradeChance.get();
        boolean creative = !XP.isPlayerSurvival(player);
        lEnchants.forEach((enchant, startLevel) -> {
            if (newEnchants.containsKey(enchant)) {
                if ((Integer)newEnchants.get(enchant) < startLevel) {
                    newEnchants.replace((Enchantment)enchant, (Integer)startLevel);
                }
            } else {
                newEnchants.put((Enchantment)enchant, (Integer)startLevel);
            }
        });
        rEnchants.forEach((enchant, startLevel) -> {
            if (newEnchants.containsKey(enchant)) {
                if ((Integer)newEnchants.get(enchant) < startLevel) {
                    newEnchants.replace((Enchantment)enchant, (Integer)startLevel);
                }
            } else {
                newEnchants.put((Enchantment)enchant, (Integer)startLevel);
            }
        });
        HashSet keys = new HashSet(newEnchants.keySet());
        keys.forEach(enchant -> {
            int startLevel = (Integer)newEnchants.get(enchant);
            int maxPlayerBypass = (int)Math.floor((double)currLevel / (double)levelsPerOneEnchantBypass);
            if (maxPlayerBypass > maxEnchantmentBypass) {
                maxPlayerBypass = maxEnchantmentBypass;
            }
            if (maxEnchantLevel < startLevel && !creative) {
                if (maxEnchantLevel > 0) {
                    newEnchants.replace((Enchantment)enchant, maxEnchantLevel);
                } else {
                    newEnchants.remove(enchant);
                }
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.maxEnchantLevelWarning", enchant.m_44700_(1).getString().replace(" I", ""), "" + maxEnchantLevel, false, 2), (ServerPlayer)player);
            } else if (enchant.m_6586_() + maxPlayerBypass < startLevel && !creative) {
                if (enchant.m_6586_() + maxPlayerBypass > 0) {
                    newEnchants.replace((Enchantment)enchant, enchant.m_6586_() + maxPlayerBypass);
                } else {
                    newEnchants.remove(enchant);
                }
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.enchantmentDegradedWarning", enchant.m_44700_(1).getString().replace(" I", ""), "" + (enchant.m_6586_() + maxPlayerBypass), false, 2), (ServerPlayer)player);
            } else if (lEnchants.get(enchant) != null && rEnchants.get(enchant) != null && ((Integer)lEnchants.get(enchant)).intValue() == ((Integer)rEnchants.get(enchant)).intValue()) {
                if (startLevel + 1 > maxEnchantLevel && !creative) {
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.maxEnchantLevelWarning", enchant.m_44700_(1).getString().replace(" I", ""), "" + maxEnchantLevel, false, 2), (ServerPlayer)player);
                } else if (startLevel + 1 > enchant.m_6586_() + maxPlayerBypass && !creative) {
                    player.m_5661_((Component)new TranslatableComponent("pmmo.enchantLackOfLevelWarning", new Object[]{enchant.m_44700_(1).getString().replace(" I", "")}).m_6270_(XP.textStyle.get("red")), false);
                } else if ((startLevel >= enchant.m_6586_() || alwaysUseUpgradeChance) && !creative) {
                    if (Math.ceil(Math.random() * 100.0) <= bypassChance) {
                        newEnchants.replace((Enchantment)enchant, startLevel + 1);
                        NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.enchantUpgradeSuccess", enchant.m_44700_(1).getString().replace(" I", ""), "" + (startLevel + 1), false, 1), (ServerPlayer)player);
                    } else if (Math.ceil(Math.random() * 100.0) <= failedBypassPenaltyChance) {
                        if (startLevel > 1) {
                            newEnchants.replace((Enchantment)enchant, startLevel - 1);
                        } else {
                            newEnchants.remove(enchant);
                        }
                        NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.enchantUpgradeAndSaveFail", enchant.m_44700_(1).getString().replace(" I", ""), "" + bypassChance, "" + failedBypassPenaltyChance, false, 2), (ServerPlayer)player);
                    } else {
                        newEnchants.replace((Enchantment)enchant, startLevel);
                        NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.enchantUpgradeFail", enchant.m_44700_(1).getString().replace(" I", ""), "" + bypassChance, false, 3), (ServerPlayer)player);
                    }
                } else {
                    newEnchants.replace((Enchantment)enchant, startLevel + 1);
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.enchantUpgradeSuccess", enchant.m_44700_(1).getString().replace(" I", ""), "" + (startLevel + 1), false, 1), (ServerPlayer)player);
                }
            }
        });
        return newEnchants;
    }
}

