/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.party.PartyMemberInfo;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PartyCommand {
    public static int execute(CommandContext<CommandSourceStack> context) throws CommandRuntimeException {
        Player player = (Player)((CommandSourceStack)context.getSource()).m_81373_();
        UUID uuid = player.m_142081_();
        PmmoSavedData pmmoSavedData = PmmoSavedData.get();
        Party party = pmmoSavedData.getParty(uuid);
        if (party == null) {
            player.m_5661_((Component)new TranslatableComponent("pmmo.youAreNotInAParty").m_6270_(XP.textStyle.get("red")), false);
        } else {
            Set<PartyMemberInfo> membersInfo = party.getAllMembersInfo();
            Set membersInRangeUUID = party.getOnlineMembersInRange((ServerPlayer)player).stream().map(playerToMap -> playerToMap.m_142081_()).collect(Collectors.toSet());
            double totalXpGained = party.getTotalXpGained();
            player.m_5661_((Component)new TranslatableComponent("pmmo.youAreInAParty").m_6270_(XP.textStyle.get("green")), false);
            player.m_5661_((Component)new TranslatableComponent("pmmo.totalMembersOutOfMax", new Object[]{party.getPartySize(), Party.getMaxPartyMembers()}).m_6270_(XP.textStyle.get("green")), false);
            player.m_5661_((Component)new TranslatableComponent("pmmo.partyTotalXpGained", new Object[]{DP.dpSoft(totalXpGained)}).m_6270_(XP.textStyle.get("green")), false);
            player.m_5661_((Component)new TranslatableComponent("pmmo.partyXpBonus", new Object[]{DP.dpSoft((party.getMultiplier(membersInRangeUUID.size()) - 1.0) * 100.0)}).m_6270_(XP.textStyle.get("green")), false);
            for (PartyMemberInfo memberInfo : membersInfo) {
                String xpGainedPercentage = DP.dpSoft(memberInfo.xpGained / totalXpGained * 100.0);
                String color = "yellow";
                if (!memberInfo.uuid.equals(uuid)) {
                    color = membersInRangeUUID.contains(memberInfo.uuid) ? "green" : "dark_green";
                }
                player.m_5661_((Component)new TranslatableComponent("pmmo.partyMemberListEntry", new Object[]{pmmoSavedData.getName(memberInfo.uuid), DP.dpSoft(memberInfo.xpGained), totalXpGained == 0.0 ? "0" : xpGainedPercentage, memberInfo.xpGained}).m_6270_(XP.textStyle.get(color)), false);
            }
        }
        return 1;
    }
}

