/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.api.perks.PerkRegistry;
import harmonised.pmmo.api.perks.PerkTrigger;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.util.XP;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClearCommand {
    private static final Logger LOGGER = LogManager.getLogger();

    public static int execute(CommandContext<CommandSourceStack> context) throws CommandRuntimeException {
        Object[] args = context.getInput().split(" ");
        try {
            Collection players = EntityArgument.m_91477_(context, (String)"target");
            for (ServerPlayer player : players) {
                String playerName = player.m_5446_().getString();
                XP.updateRecipes(player);
                Map<String, Double> xpMap = PmmoSavedData.get().getXpMap(player.m_142081_());
                for (String skill : new HashSet<String>(xpMap.keySet())) {
                    xpMap.remove(skill);
                }
                PerkRegistry.executePerk(PerkTrigger.SKILL_UP, player);
                NetworkHandler.sendToPlayer(new MessageXp(0.0, "42069", 0.0, true), player);
                player.m_5661_((Component)new TranslatableComponent("pmmo.skillsCleared"), false);
                LOGGER.info("PMMO Command Clear: " + playerName + " has had their stats wiped!");
            }
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Clear Command Failed to get Players [" + Arrays.toString(args) + "]", (Throwable)e);
        }
        return 1;
    }
}

