/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.network.MessageUpdatePlayerNBT;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.XP;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckStatsCommand {
    public static final Logger LOGGER = LogManager.getLogger();

    public static int execute(CommandContext<CommandSourceStack> context) throws CommandRuntimeException {
        Player sender = (Player)((CommandSourceStack)context.getSource()).m_81373_();
        String[] args = context.getInput().split(" ");
        if (sender == null) {
            LOGGER.error("Error: Pmmo checkstats sent by non-player");
            return -1;
        }
        try {
            ServerPlayer target = EntityArgument.m_91474_(context, (String)"player name");
            CompoundTag packetxpMap = NBTHelper.mapStringToNbt(Config.getXpMap((Player)target));
            packetxpMap.m_128359_("UUID", target.m_142081_().toString());
            packetxpMap.m_128359_("name", target.m_7755_().getString());
            NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(packetxpMap, 3), (ServerPlayer)sender);
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Error: Invalid Player requested at CheckStats Command \"" + args[2] + "\"", (Throwable)e);
            sender.m_5661_((Component)new TranslatableComponent("pmmo.invalidPlayer", new Object[]{args[2]}).m_6270_(XP.textStyle.get("red")), false);
            return -1;
        }
        return 1;
    }
}

