/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddCommand {
    public static final Logger LOGGER = LogManager.getLogger();

    public static int execute(CommandContext<CommandSourceStack> context) throws CommandRuntimeException {
        Object[] args = context.getInput().split(" ");
        String skill = StringArgumentType.getString(context, (String)"Skill").toLowerCase();
        String type = StringArgumentType.getString(context, (String)"Level|Xp").toLowerCase();
        boolean ignoreBonuses = true;
        ServerPlayer sender = null;
        try {
            ignoreBonuses = BoolArgumentType.getBool(context, (String)"Ignore Bonuses");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sender = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        try {
            Collection players = EntityArgument.m_91477_(context, (String)"target");
            for (ServerPlayer player : players) {
                String playerName = player.m_5446_().getString();
                double newValue = DoubleArgumentType.getDouble(context, (String)"Value To Add");
                if (type.equals("level")) {
                    Skill.addLevel(skill, player, newValue, "add level Command", false, ignoreBonuses);
                } else if (type.equals("xp")) {
                    Skill.addXp(skill, player, newValue, "add xp Command", false, ignoreBonuses);
                } else {
                    LOGGER.error("PMMO Command Add: Invalid 6th Element in command (level|xp) " + Arrays.toString(args));
                    if (sender != null) {
                        sender.m_5661_((Component)new TranslatableComponent("pmmo.invalidChoice", new Object[]{args[5]}).m_6270_(XP.textStyle.get("red")), false);
                    }
                }
                LOGGER.info("PMMO Command Add: " + playerName + " " + (String)args[4] + " has had " + (String)args[6] + " " + (String)args[5] + " added");
            }
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("PMMO Command Add: Add Command Failed to get Players [" + Arrays.toString(args) + "]", (Throwable)e);
        }
        return 1;
    }
}

