/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.api;

import com.google.common.collect.LinkedListMultimap;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.util.XP;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PredicateRegistry {
    private static LinkedListMultimap<String, Predicate<Player>> reqPredicates = LinkedListMultimap.create();
    private static LinkedListMultimap<String, BiPredicate<Player, BlockEntity>> reqBreakPredicates = LinkedListMultimap.create();

    public static void registerPredicate(ResourceLocation res, JType jType, Predicate<Player> pred) {
        String condition = jType.toString() + ";" + res.toString();
        if (pred == null) {
            return;
        }
        reqPredicates.get((Object)condition).add(pred);
        XP.LOGGER.info("Predicate Registered: " + condition);
    }

    public static void registerBreakPredicate(ResourceLocation res, JType jType, BiPredicate<Player, BlockEntity> pred) {
        String condition = jType.toString() + ";" + res.toString();
        if (pred == null) {
            return;
        }
        reqBreakPredicates.get((Object)condition).add(pred);
        XP.LOGGER.info("Predicate Registered: " + condition);
    }

    public static boolean predicateExists(ResourceLocation res, JType jType) {
        if (jType.equals((Object)JType.REQ_BREAK)) {
            return reqBreakPredicates.containsKey((Object)(jType.toString() + ";" + res.toString()));
        }
        return reqPredicates.containsKey((Object)(jType.toString() + ";" + res.toString()));
    }

    public static boolean checkPredicateReq(Player player, ResourceLocation res, JType jType) {
        if (!PredicateRegistry.predicateExists(res, jType)) {
            return false;
        }
        boolean outcome = true;
        for (Predicate pred : reqPredicates.get((Object)(jType.toString() + ";" + res.toString()))) {
            if (pred.test(player)) continue;
            return false;
        }
        return outcome;
    }

    public static boolean checkPredicateReq(Player player, BlockEntity tile, JType jType) {
        ResourceLocation res = tile.m_58900_().m_60734_().getRegistryName();
        if (!PredicateRegistry.predicateExists(res, jType)) {
            return false;
        }
        boolean outcome = true;
        for (BiPredicate pred : reqBreakPredicates.get((Object)(jType.toString() + ";" + res.toString()))) {
            if (pred.test(player, tile)) continue;
            return false;
        }
        return outcome;
    }
}

