/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.potion;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.ench.table.EnchantingRecipe;
import shadows.apotheosis.ench.table.EnchantingStatManager;

public class PotionEnchantingRecipe
extends EnchantingRecipe {
    public static final Serializer SERIALIZER = new Serializer();

    public PotionEnchantingRecipe(EnchantingStatManager.Stats requirements, EnchantingStatManager.Stats maxRequirements) {
        super(new ResourceLocation("apotheosis", "potion_charm_enchanting"), PotionEnchantingRecipe.charm(), PotionEnchantingRecipe.potion(), requirements, maxRequirements);
    }

    private static ItemStack charm() {
        ItemStack out = new ItemStack((ItemLike)Apoth.Items.POTION_CHARM);
        out.m_41784_().m_128379_("Unbreakable", true);
        return out;
    }

    private static Ingredient potion() {
        ArrayList<ItemStack> potionStacks = new ArrayList<ItemStack>();
        for (Potion p : ForgeRegistries.POTIONS) {
            if (p.m_43488_().size() != 1 || ((MobEffectInstance)p.m_43488_().get(0)).m_19544_().m_8093_()) continue;
            ItemStack potion = new ItemStack((ItemLike)Apoth.Items.POTION_CHARM);
            PotionUtils.m_43549_((ItemStack)potion, (Potion)p);
            potionStacks.add(potion);
        }
        return Ingredient.m_43927_((ItemStack[])potionStacks.toArray(new ItemStack[0]));
    }

    @Override
    public boolean matches(ItemStack input, float eterna, float quanta, float arcana) {
        if (input.m_41782_() && input.m_41783_().m_128471_("Unbreakable")) {
            return false;
        }
        return super.matches(input, eterna, quanta, arcana);
    }

    @Override
    public ItemStack assemble(ItemStack input, float eterna, float quanta, float arcana) {
        ItemStack out = input.m_41777_();
        out.m_41721_(0);
        out.m_41784_().m_128379_("Unbreakable", true);
        return out;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<PotionEnchantingRecipe> {
        protected static final Gson GSON = new GsonBuilder().create();

        public PotionEnchantingRecipe fromJson(ResourceLocation id, JsonObject obj) {
            EnchantingStatManager.Stats maxStats;
            EnchantingStatManager.Stats stats = (EnchantingStatManager.Stats)GSON.fromJson(obj.get("requirements"), EnchantingStatManager.Stats.class);
            EnchantingStatManager.Stats stats2 = maxStats = obj.has("max_requirements") ? (EnchantingStatManager.Stats)GSON.fromJson(obj.get("max_requirements"), EnchantingStatManager.Stats.class) : EnchantingRecipe.NO_MAX;
            if (maxStats.eterna != -1.0f && stats.eterna > maxStats.eterna) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max eterna bounds (min > max).");
            }
            if (maxStats.quanta != -1.0f && stats.quanta > maxStats.quanta) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max quanta bounds (min > max).");
            }
            if (maxStats.arcana != -1.0f && stats.arcana > maxStats.arcana) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max arcana bounds (min > max).");
            }
            return new PotionEnchantingRecipe(stats, maxStats);
        }

        public PotionEnchantingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            EnchantingStatManager.Stats stats = EnchantingStatManager.Stats.read(buf);
            EnchantingStatManager.Stats maxStats = buf.readBoolean() ? EnchantingStatManager.Stats.read(buf) : EnchantingRecipe.NO_MAX;
            return new PotionEnchantingRecipe(stats, maxStats);
        }

        public void toNetwork(FriendlyByteBuf buf, PotionEnchantingRecipe recipe) {
            recipe.requirements.write(buf);
            buf.writeBoolean(recipe.maxRequirements != EnchantingRecipe.NO_MAX);
            if (recipe.maxRequirements != EnchantingRecipe.NO_MAX) {
                recipe.maxRequirements.write(buf);
            }
        }
    }
}

