/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.compat.GameStagesCompat;
import shadows.apotheosis.adventure.loot.AffixLootEntry;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.json.DimWeightedJsonReloadListener;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.NBTAdapter;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.SerializerBuilder;

public class AffixLootManager
extends DimWeightedJsonReloadListener<AffixLootEntry> {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ItemStack.class, (Object)ItemAdapter.INSTANCE).registerTypeAdapter(CompoundTag.class, (Object)NBTAdapter.INSTANCE).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(LootRarity.class, (Object)new LootRarity.Serializer()).setPrettyPrinting().create();
    public static final AffixLootManager INSTANCE = new AffixLootManager();
    private static List<Runnable> loadCallbacks = new ArrayList<Runnable>();

    private AffixLootManager() {
        super(AdventureModule.LOGGER, "affix_loot_entries", false, false);
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, new SerializerBuilder("Affix Loot Entry").json(obj -> (AffixLootEntry)GSON.fromJson((JsonElement)obj, AffixLootEntry.class), e -> GSON.toJsonTree(e).getAsJsonObject()));
    }

    protected void validateItem(AffixLootEntry item) {
        super.validateItem((PlaceboJsonReloadListener.TypeKeyed)item);
        Preconditions.checkArgument((!item.stack.m_41619_() ? 1 : 0) != 0);
        Preconditions.checkArgument((item.type != null ? 1 : 0) != 0);
        Preconditions.checkArgument((item.type != LootCategory.NONE ? 1 : 0) != 0);
    }

    protected void onReload() {
        super.onReload();
        loadCallbacks.forEach(Runnable::run);
    }

    public static void registerCallback(Runnable r) {
        loadCallbacks.add(r);
    }

    public AffixLootEntry getRandomItem(Random rand, Player player, ServerLevelAccessor level) {
        ArrayList list = new ArrayList(this.zeroLuckList.size());
        this.registry.values().stream().filter(DimWeightedJsonReloadListener.IDimWeighted.matches((ResourceLocation)level.m_6018_().m_46472_().m_135782_())).filter(i -> GameStagesCompat.hasStage(player, i.stages)).map(l -> l.wrap(player.m_36336_())).forEach(list::add);
        return WeightedRandom.m_146317_((Random)rand, list).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
    }
}

