/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.client.from_mantle;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import shadows.apotheosis.adventure.client.from_mantle.SimpleBlockModel;

public class ColoredBlockModel
implements IModelGeometry<ColoredBlockModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final List<ColorData> colorData;

    public ColoredBlockModel(SimpleBlockModel model, List<ColorData> data) {
        this.model = model;
        this.colorData = data;
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    public static void bakePart(SimpleBakedModel.Builder builder, IModelConfiguration owner, BlockElement part, int color, int luminosity, ModelState transform, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        for (Direction direction : part.f_111310_.keySet()) {
            BlockElementFace face = (BlockElementFace)part.f_111310_.get(direction);
            String texture = face.f_111356_;
            if (texture.charAt(0) == '#') {
                texture = texture.substring(1);
            }
            TextureAtlasSprite sprite = spriteGetter.apply(owner.resolveTexture(texture));
            BakedQuad quad = ColoredBlockModel.bakeFace(part, face, sprite, direction, transform, color, luminosity, location);
            if (face.f_111354_ == null) {
                builder.m_119526_(quad);
                continue;
            }
            builder.m_119530_(Direction.m_122384_((Matrix4f)transform.m_6189_().m_121104_(), (Direction)face.f_111354_), quad);
        }
    }

    public static BakedModel bakeModel(IModelConfiguration owner, List<BlockElement> elements, List<ColorData> colorData, ModelState transform, ItemOverrides overrides, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(owner, overrides).m_119528_(particle);
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            BlockElement part = elements.get(i);
            ColorData colors = colorData.size() > i ? colorData.get(i) : ColorData.DEFAULT;
            ColoredBlockModel.bakePart(builder, owner, part, colors.color, colors.luminosity(), transform, spriteGetter, location);
        }
        return builder.m_119533_();
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return ColoredBlockModel.bakeModel(owner, this.model.getElements(), this.colorData, modelTransform, overrides, spriteGetter, modelLocation);
    }

    public static int parseColor(@Nullable String color) {
        if (color == null || color.isEmpty()) {
            return -1;
        }
        if (color.charAt(0) != '-') {
            try {
                int length = color.length();
                if (length == 8) {
                    return (int)Long.parseLong(color, 16);
                }
                if (length == 6) {
                    return 0xFF000000 | Integer.parseInt(color, 16);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new JsonSyntaxException("Invalid color '" + color + "'");
    }

    public static BakedQuad bakeFace(BlockElement part, BlockElementFace face, TextureAtlasSprite sprite, Direction facing, ModelState transform, int color, int luminosity, ResourceLocation location) {
        return ColoredBlockModel.bakeQuad(part.f_111308_, part.f_111309_, face, sprite, facing, transform, part.f_111311_, part.f_111312_, color, luminosity, location);
    }

    public static BakedQuad bakeQuad(Vector3f posFrom, Vector3f posTo, BlockElementFace face, TextureAtlasSprite sprite, Direction facing, ModelState transform, @Nullable BlockElementRotation partRotation, boolean shade, int color, int luminosity, ResourceLocation location) {
        BlockFaceUV faceUV = face.f_111357_;
        if (transform.m_7538_()) {
            faceUV = FaceBakery.m_111581_((BlockFaceUV)face.f_111357_, (Direction)facing, (Transformation)transform.m_6189_(), (ResourceLocation)location);
        }
        float[] originalUV = new float[faceUV.f_111387_.length];
        System.arraycopy(faceUV.f_111387_, 0, originalUV, 0, originalUV.length);
        float shrinkRatio = sprite.m_118417_();
        float u = (faceUV.f_111387_[0] + faceUV.f_111387_[0] + faceUV.f_111387_[2] + faceUV.f_111387_[2]) / 4.0f;
        float v = (faceUV.f_111387_[1] + faceUV.f_111387_[1] + faceUV.f_111387_[3] + faceUV.f_111387_[3]) / 4.0f;
        faceUV.f_111387_[0] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[0], (float)u);
        faceUV.f_111387_[2] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[2], (float)u);
        faceUV.f_111387_[1] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[1], (float)v);
        faceUV.f_111387_[3] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[3], (float)v);
        int[] vertexData = ColoredBlockModel.makeVertices(faceUV, sprite, facing, BlockModel.f_111421_.m_111592_(posFrom, posTo), transform.m_6189_(), partRotation, color, luminosity);
        Direction direction = FaceBakery.m_111612_((int[])vertexData);
        System.arraycopy(originalUV, 0, faceUV.f_111387_, 0, originalUV.length);
        if (partRotation == null) {
            BlockModel.f_111421_.m_111630_(vertexData, direction);
        }
        ForgeHooksClient.fillNormal((int[])vertexData, (Direction)direction);
        return new BakedQuad(vertexData, face.f_111355_, direction, sprite, shade);
    }

    private static int[] makeVertices(BlockFaceUV uvs, TextureAtlasSprite sprite, Direction orientation, float[] posDiv16, Transformation rotationIn, @Nullable BlockElementRotation partRotation, int color, int luminosity) {
        int[] vertexData = new int[32];
        for (int i = 0; i < 4; ++i) {
            ColoredBlockModel.bakeVertex(vertexData, i, orientation, uvs, posDiv16, sprite, rotationIn, partRotation, color, luminosity);
        }
        return vertexData;
    }

    private static void bakeVertex(int[] vertexData, int vertexIndex, Direction facing, BlockFaceUV blockFaceUVIn, float[] posDiv16, TextureAtlasSprite sprite, Transformation rotationIn, @Nullable BlockElementRotation partRotation, int color, int luminosity) {
        FaceInfo.VertexInfo vertexInfo = FaceInfo.m_108984_((Direction)facing).m_108982_(vertexIndex);
        Vector3f vector3f = new Vector3f(posDiv16[vertexInfo.f_108998_], posDiv16[vertexInfo.f_108999_], posDiv16[vertexInfo.f_109000_]);
        BlockModel.f_111421_.m_111586_(vector3f, partRotation);
        BlockModel.f_111421_.m_111589_(vector3f, rotationIn);
        ColoredBlockModel.fillVertex(vertexData, vertexIndex, vector3f, sprite, blockFaceUVIn, color, luminosity);
    }

    private static int swapColorRedBlue(int color) {
        return color & 0xFF00FF00 | color >> 16 & 0xFF | color << 16 & 0xFF0000;
    }

    private static void fillVertex(int[] vertexData, int vertexIndex, Vector3f vector, TextureAtlasSprite sprite, BlockFaceUV blockFaceUV, int color, int luminosity) {
        int i = vertexIndex * 8;
        vertexData[i] = Float.floatToRawIntBits(vector.m_122239_());
        vertexData[i + 1] = Float.floatToRawIntBits(vector.m_122260_());
        vertexData[i + 2] = Float.floatToRawIntBits(vector.m_122269_());
        vertexData[i + 3] = ColoredBlockModel.swapColorRedBlue(color);
        vertexData[i + 4] = Float.floatToRawIntBits(sprite.m_118367_((double)blockFaceUV.m_111392_(vertexIndex) * 0.999 + (double)blockFaceUV.m_111392_((vertexIndex + 2) % 4) * 0.001));
        vertexData[i + 5] = Float.floatToRawIntBits(sprite.m_118393_((double)blockFaceUV.m_111396_(vertexIndex) * 0.999 + (double)blockFaceUV.m_111396_((vertexIndex + 2) % 4) * 0.001));
        vertexData[i + 6] = luminosity << 4;
    }

    public record ColorData(int color, int luminosity) {
        public static final ColorData DEFAULT = new ColorData(-1, -1);

        public static ColorData fromJson(JsonObject json) {
            int color = ColoredBlockModel.parseColor(GsonHelper.m_13851_((JsonObject)json, (String)"color", (String)""));
            int luminosity = GsonHelper.m_13824_((JsonObject)json, (String)"luminosity", (int)0);
            return new ColorData(color, luminosity);
        }
    }

    private static class Loader
    implements IModelLoader<ColoredBlockModel> {
        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public ColoredBlockModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            SimpleBlockModel model = SimpleBlockModel.deserialize(deserializationContext, modelContents);
            ArrayList<ColorData> colorData = new ArrayList<ColorData>();
            GsonHelper.m_13933_((JsonObject)modelContents, (String)"colors").forEach(e -> colorData.add(ColorData.fromJson(e.getAsJsonObject())));
            return new ColoredBlockModel(model, colorData);
        }
    }
}

