/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.socket.Gem;
import shadows.apotheosis.adventure.affix.socket.GemItem;
import shadows.apotheosis.adventure.compat.GameStagesCompat;
import shadows.placebo.json.DimWeightedJsonReloadListener;
import shadows.placebo.json.JsonUtil;
import shadows.placebo.json.SerializerBuilder;

public class GemManager
extends DimWeightedJsonReloadListener<Gem> {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(Attribute.class, JsonUtil.makeSerializer((IForgeRegistry)ForgeRegistries.ATTRIBUTES)).create();
    public static final GemManager INSTANCE = new GemManager();
    private static List<Runnable> loadCallbacks = new ArrayList<Runnable>();

    public GemManager() {
        super(AdventureModule.LOGGER, "gems", false, false);
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, new SerializerBuilder("Gem").withJsonDeserializer(obj -> (Gem)((Object)((Object)GSON.fromJson((JsonElement)obj, Gem.class)))));
    }

    public static ItemStack getRandomGemStack(Random rand, Player player, ServerLevelAccessor level) {
        return GemItem.fromGem(INSTANCE.getRandomItem(rand, player, level), rand);
    }

    protected void onReload() {
        super.onReload();
        loadCallbacks.forEach(Runnable::run);
    }

    public static void registerCallback(Runnable r) {
        loadCallbacks.add(r);
    }

    public Gem getRandomItem(Random rand, Player player, ServerLevelAccessor level) {
        ArrayList list = new ArrayList(this.zeroLuckList.size());
        this.registry.values().stream().filter(DimWeightedJsonReloadListener.IDimWeighted.matches((ResourceLocation)level.m_6018_().m_46472_().m_135782_())).filter(i -> GameStagesCompat.hasStage(player, i.stages)).map(l -> l.wrap(player.m_36336_())).forEach(list::add);
        return WeightedRandom.m_146317_((Random)rand, list).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
    }
}

