/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.mixin.LivingEntityInvoker;
import shadows.placebo.util.StepFunction;

public class ExecutingAffix
extends Affix {
    protected final Map<LootRarity, StepFunction> values;

    public ExecutingAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.EFFECT);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.HEAVY_WEAPON && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix." + this.getId() + ".desc", new Object[]{ItemStack.f_41584_.format(100.0f * this.getTrueLevel(rarity, level))}).m_130940_(ChatFormatting.YELLOW));
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        float threshold = this.getTrueLevel(rarity, level);
        if ((double)Apotheosis.localAtkStrength >= 0.98 && target instanceof LivingEntity) {
            DamageSource src;
            LivingEntity living = (LivingEntity)target;
            if (!living.f_19853_.f_46443_ && living.m_21223_() / living.m_21233_() < threshold && !((LivingEntityInvoker)living).callCheckTotemDeathProtection(src = new EntityDamageSource("apotheosis.execute", (Entity)user).m_19380_().m_19382_())) {
                SoundEvent soundevent = ((LivingEntityInvoker)living).callGetDeathSound();
                if (soundevent != null) {
                    living.m_5496_(soundevent, ((LivingEntityInvoker)living).callGetSoundVolume(), living.m_6100_());
                }
                living.m_21153_(0.0f);
                living.m_6667_(src);
            }
        }
    }

    public static Affix read(JsonObject obj) {
        Map<LootRarity, StepFunction> values = AffixHelper.readValues(GsonHelper.m_13930_((JsonObject)obj, (String)"values"));
        return new ExecutingAffix(values);
    }

    public JsonObject write() {
        return new JsonObject();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_178355_(this.values, (b, key) -> b.m_130070_(key.id()), (b, func) -> func.write(b));
    }

    public static Affix read(FriendlyByteBuf buf) {
        Map values = buf.m_178368_(b -> LootRarity.byId(b.m_130277_()), b -> StepFunction.read((FriendlyByteBuf)b));
        return new ExecutingAffix(values);
    }
}

