/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.affix.AttributeAffix;
import shadows.apotheosis.adventure.affix.effect.CatalyzingAffix;
import shadows.apotheosis.adventure.affix.effect.CleavingAffix;
import shadows.apotheosis.adventure.affix.effect.DamageReductionAffix;
import shadows.apotheosis.adventure.affix.effect.DurableAffix;
import shadows.apotheosis.adventure.affix.effect.EnlightenedAffix;
import shadows.apotheosis.adventure.affix.effect.ExecutingAffix;
import shadows.apotheosis.adventure.affix.effect.FestiveAffix;
import shadows.apotheosis.adventure.affix.effect.MagicalArrowAffix;
import shadows.apotheosis.adventure.affix.effect.OmneticAffix;
import shadows.apotheosis.adventure.affix.effect.PotionAffix;
import shadows.apotheosis.adventure.affix.effect.PsychicAffix;
import shadows.apotheosis.adventure.affix.effect.RadialAffix;
import shadows.apotheosis.adventure.affix.effect.RetreatingAffix;
import shadows.apotheosis.adventure.affix.effect.SpectralShotAffix;
import shadows.apotheosis.adventure.affix.effect.TelepathicAffix;
import shadows.apotheosis.adventure.affix.effect.ThunderstruckAffix;
import shadows.apotheosis.adventure.affix.socket.SocketAffix;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.SerializerBuilder;

public class AffixManager
extends PlaceboJsonReloadListener<Affix> {
    public static final AffixManager INSTANCE = new AffixManager();
    private Multimap<AffixType, Affix> byType = ImmutableMultimap.of();

    public AffixManager() {
        super(AdventureModule.LOGGER, "affixes", true, true);
    }

    protected void beginReload() {
        super.beginReload();
    }

    protected void onReload() {
        super.onReload();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.registry.values().forEach(a -> builder.put((Object)a.type, (Object)a));
        this.byType = builder.build();
        Preconditions.checkArgument((boolean)(Apoth.Affixes.SOCKET.get() instanceof SocketAffix), (Object)"Socket Affix not registered!");
        Preconditions.checkArgument((boolean)(Apoth.Affixes.DURABLE.get() instanceof DurableAffix), (Object)"Durable Affix not registered!");
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(Apotheosis.loc("attribute"), new SerializerBuilder("Attribute Affix").autoRegister(AttributeAffix.class));
        this.registerSerializer(Apotheosis.loc("mob_effect"), new SerializerBuilder("Potion Affix").autoRegister(PotionAffix.class));
        this.registerSerializer(Apotheosis.loc("damage_reduction"), new SerializerBuilder("Damage Reduction Affix").autoRegister(DamageReductionAffix.class));
        this.registerSerializer(Apotheosis.loc("catalyzing"), new SerializerBuilder("Catalyzing Affix").autoRegister(CatalyzingAffix.class));
        this.registerSerializer(Apotheosis.loc("cleaving"), new SerializerBuilder("Cleaving Affix").autoRegister(CleavingAffix.class));
        this.registerSerializer(Apotheosis.loc("enlightened"), new SerializerBuilder("Enlightened Affix").autoRegister(EnlightenedAffix.class));
        this.registerSerializer(Apotheosis.loc("executing"), new SerializerBuilder("Executing Affix").autoRegister(ExecutingAffix.class));
        this.registerSerializer(Apotheosis.loc("festive"), new SerializerBuilder("Festive Affix").autoRegister(FestiveAffix.class));
        this.registerSerializer(Apotheosis.loc("magical"), new SerializerBuilder("Magical Affix").autoRegister(MagicalArrowAffix.class));
        this.registerSerializer(Apotheosis.loc("omnetic"), new SerializerBuilder("Omnetic Affix").autoRegister(OmneticAffix.class));
        this.registerSerializer(Apotheosis.loc("psychic"), new SerializerBuilder("Psychic Affix").autoRegister(PsychicAffix.class));
        this.registerSerializer(Apotheosis.loc("radial"), new SerializerBuilder("Radial Affix").autoRegister(RadialAffix.class));
        this.registerSerializer(Apotheosis.loc("retreating"), new SerializerBuilder("Retreating Affix").autoRegister(RetreatingAffix.class));
        this.registerSerializer(Apotheosis.loc("spectral"), new SerializerBuilder("Spectral Affix").autoRegister(SpectralShotAffix.class));
        this.registerSerializer(Apotheosis.loc("telepathic"), new SerializerBuilder("Telepathic Affix").autoRegister(TelepathicAffix.class));
        this.registerSerializer(Apotheosis.loc("thunderstruck"), new SerializerBuilder("Thunderstruck Affix").autoRegister(ThunderstruckAffix.class));
        this.registerSerializer(Apotheosis.loc("socket"), new SerializerBuilder("Socket Affix").builtin(SocketAffix::new));
        this.registerSerializer(Apotheosis.loc("durable"), new SerializerBuilder("Durable Affix").builtin(DurableAffix::new));
    }

    public Multimap<AffixType, Affix> getTypeMap() {
        return this.byType;
    }
}

