/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.boss.BossDungeonFeature;
import shadows.apotheosis.adventure.boss.BossDungeonFeature2;
import shadows.apotheosis.adventure.spawner.RogueSpawnerFeature;

public class AdventureGeneration {
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> CF_BOSS_DUNGEON = AdventureGeneration.register(BossDungeonFeature.INSTANCE, "boss_dungeon");
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> CF_BOSS_DUNGEON_2 = AdventureGeneration.register(BossDungeonFeature2.INSTANCE, "boss_dungeon_2");
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> CF_ROGUE_SPAWNER = AdventureGeneration.register(RogueSpawnerFeature.INSTANCE, "rogue_spawner");
    public static final Holder<PlacedFeature> BOSS_DUNGEON = AdventureGeneration.register("boss_dungeon", CF_BOSS_DUNGEON, new PlacementModifier[]{CountPlacement.m_191628_((int)AdventureConfig.bossDungeonAttempts), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158929_()), BiomeFilter.m_191561_()});
    public static final Holder<PlacedFeature> BOSS_DUNGEON_DEEP = AdventureGeneration.register("boss_dungeon_deep", CF_BOSS_DUNGEON, new PlacementModifier[]{CountPlacement.m_191628_((int)(AdventureConfig.bossDungeonAttempts / 2)), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)6), (VerticalAnchor)VerticalAnchor.m_158922_((int)-1)), BiomeFilter.m_191561_()});
    public static final Holder<PlacedFeature> BOSS_DUNGEON_2 = AdventureGeneration.register("boss_dungeon_2", CF_BOSS_DUNGEON_2, new PlacementModifier[]{CountPlacement.m_191628_((int)AdventureConfig.bossDungeon2Attempts), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158929_()), BiomeFilter.m_191561_()});
    public static final Holder<PlacedFeature> BOSS_DUNGEON_2_DEEP = AdventureGeneration.register("boss_dungeon_2_deep", CF_BOSS_DUNGEON_2, new PlacementModifier[]{CountPlacement.m_191628_((int)(AdventureConfig.bossDungeon2Attempts / 2)), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)6), (VerticalAnchor)VerticalAnchor.m_158922_((int)-1)), BiomeFilter.m_191561_()});
    public static final Holder<PlacedFeature> ROGUE_SPAWNER = AdventureGeneration.register("rogue_spawner", CF_ROGUE_SPAWNER, new PlacementModifier[]{CountPlacement.m_191628_((int)AdventureConfig.rogueSpawnerAttempts), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158929_()), BiomeFilter.m_191561_()});
    public static final Holder<PlacedFeature> ROGUE_SPAWNER_DEEP = AdventureGeneration.register("rogue_spawner_deep", CF_ROGUE_SPAWNER, new PlacementModifier[]{CountPlacement.m_191628_((int)(AdventureConfig.rogueSpawnerAttempts / 2)), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)6), (VerticalAnchor)VerticalAnchor.m_158922_((int)-1)), BiomeFilter.m_191561_()});
    private static final List<Holder<PlacedFeature>> FEATS = ImmutableList.of(BOSS_DUNGEON, BOSS_DUNGEON_DEEP, BOSS_DUNGEON_2, BOSS_DUNGEON_2_DEEP, ROGUE_SPAWNER, ROGUE_SPAWNER_DEEP);

    static Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> register(Feature<NoneFeatureConfiguration> feat, String id) {
        return FeatureUtils.m_206485_((String)("apotheosis:" + id), feat);
    }

    static Holder<PlacedFeature> register(String id, Holder<? extends ConfiguredFeature<?, ?>> feat, PlacementModifier ... modifs) {
        return PlacementUtils.m_206513_((String)("apotheosis:" + id), feat, (PlacementModifier[])modifs);
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent e) {
        if (!AdventureConfig.BIOME_BLACKLIST.contains(e.getName())) {
            for (Holder<PlacedFeature> f : FEATS) {
                e.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, f);
            }
        }
    }
}

