/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.network;

import com.afunproject.dawncraft.Constants;
import com.afunproject.dawncraft.client.ClientHandler;
import com.afunproject.dawncraft.network.ToastMessage;
import java.io.Serializable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.smileycorp.atlas.api.network.NetworkUtils;
import net.smileycorp.atlas.api.network.SimpleIntMessage;
import net.smileycorp.atlas.api.network.SimpleStringMessage;

public class DCNetworkHandler {
    public static SimpleChannel NETWORK_INSTANCE;

    public static void initPackets() {
        NETWORK_INSTANCE = NetworkUtils.createChannel((ResourceLocation)Constants.loc("main"));
        NetworkUtils.registerMessage((SimpleChannel)NETWORK_INSTANCE, (int)0, SimpleStringMessage.class, (T, K) -> DCNetworkHandler.processNotificationMessage(T, (NetworkEvent.Context)K.get()));
        NetworkUtils.registerMessage((SimpleChannel)NETWORK_INSTANCE, (int)1, SimpleIntMessage.class, (T, K) -> DCNetworkHandler.processAnimalMessage(T, (NetworkEvent.Context)K.get()));
        NetworkUtils.registerMessage((SimpleChannel)NETWORK_INSTANCE, (int)2, ToastMessage.class, (T, K) -> DCNetworkHandler.processToastMessage(T, (NetworkEvent.Context)K.get()));
    }

    public static void processNotificationMessage(SimpleStringMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientHandler.displayMessage(message.getText())));
        ctx.setPacketHandled(true);
    }

    public static void processAnimalMessage(SimpleIntMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientHandler.displayAnimalMessage(message.get())));
        ctx.setPacketHandled(true);
    }

    public static void processToastMessage(ToastMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientHandler.displayToast(message.get())));
        ctx.setPacketHandled(true);
    }
}

