/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.mixin;

import com.afunproject.dawncraft.DCConfig;
import com.afunproject.dawncraft.DCItemTags;
import com.afunproject.dawncraft.capability.DCCapabilities;
import com.afunproject.dawncraft.capability.Toasts;
import com.afunproject.dawncraft.dungeon.item.CrystallizedXPItem;
import com.afunproject.dawncraft.dungeon.item.DungeonItems;
import com.afunproject.dawncraft.effects.DawnCraftEffects;
import com.afunproject.dawncraft.integration.create.CreateCompat;
import com.afunproject.dawncraft.integration.curios.CuriosCompat;
import com.afunproject.dawncraft.integration.sophisticatedbackpacks.SophisticatedBackpacksCompat;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class MixinPlayer
extends LivingEntity {
    @Shadow
    public float f_36080_;
    @Shadow
    public int f_36078_;
    @Shadow
    public int f_36079_;
    @Shadow
    private Inventory f_36093_;

    @Shadow
    public abstract void m_6756_(int var1);

    protected MixinPlayer(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(at={@At(value="TAIL")}, method={"awardStat(Lnet/minecraft/resources/ResourceLocation;I)V"})
    public void dctweaks$awardStat(ResourceLocation stat, int value, CallbackInfo callback) {
        LazyOptional cap;
        if (stat == Stats.f_12994_ && this instanceof ServerPlayer && ModList.get().isLoaded("journeymap") && ((ServerPlayer)this).m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12994_)) >= 1000 && (cap = this.getCapability(DCCapabilities.TOASTS)).isPresent()) {
            ((Toasts)cap.orElseGet(null)).sendToast((ServerPlayer)this, (byte)8);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"dropEquipment()V"}, cancellable=true)
    public void dctweaks$dropEquipment(CallbackInfo callback) {
        if ((Boolean)DCConfig.harderKeepInventory.get() == false | !this.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        this.m_36345_();
        this.f_36093_.f_35979_.forEach(this::handleItems);
        if (ModList.get().isLoaded("curios")) {
            this.handleItems(CuriosCompat.getEquippedCurios((Player)this));
        }
        callback.cancel();
    }

    public List<ItemStack> handleItems(List<ItemStack> items) {
        int amplifier = 1;
        if (this.m_21023_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get())) {
            amplifier += this.m_21124_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get()).m_19564_();
        }
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag tag;
            ItemStack stack = items.get(i);
            if (stack.m_41720_() == DungeonItems.CRYSTALLIZED_XP.get()) {
                stack.m_41764_(0);
            }
            if (stack.m_204117_(DCItemTags.VALUABLES)) {
                int loss;
                if (this.f_19853_.f_46441_.nextInt(8) >= amplifier) continue;
                ItemStack drop = stack.m_41777_();
                int count = stack.m_41613_();
                int newCount = count - (loss = this.f_19796_.nextInt(stack.m_41613_() + 1));
                if (newCount < 0) {
                    drop.m_41764_(stack.m_41613_());
                } else {
                    drop.m_41764_(loss);
                }
                stack.m_41764_(Math.max(0, newCount));
                this.m_7197_(drop, true, false);
                continue;
            }
            if (stack.m_41720_() == Blocks.f_50456_.m_5456_()) {
                tag = BlockItem.m_186336_((ItemStack)stack);
                if (tag == null || !tag.m_128425_("Items", 9)) continue;
                NonNullList shulker_items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)shulker_items);
                this.handleItems((List<ItemStack>)shulker_items);
                ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)shulker_items);
                BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)BlockEntityType.f_58939_, (CompoundTag)tag);
                continue;
            }
            if (ModList.get().isLoaded("create") && CreateCompat.isToolbox(stack.m_41720_()) && (tag = stack.m_41783_()) != null && tag.m_128425_("Items", 9)) {
                NonNullList toolbox_items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)toolbox_items);
                this.handleItems((List<ItemStack>)toolbox_items);
                ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)toolbox_items);
                stack.m_41739_(tag);
            }
            if (!ModList.get().isLoaded("sophisticatedbackpacks") || !SophisticatedBackpacksCompat.isBackpack(stack.m_41720_())) continue;
            this.m_7197_(stack.m_41777_(), true, false);
            stack.m_41764_(0);
        }
        return items;
    }

    @Inject(at={@At(value="HEAD")}, method={"getExperienceReward(Lnet/minecraft/world/entity/player/Player;)I"}, cancellable=true)
    protected void dctweaks$getExperienceReward(Player player, CallbackInfoReturnable<Integer> callback) {
        if ((Boolean)DCConfig.harderKeepInventory.get() == false | !this.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        int loss = 5;
        if (this.m_21023_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get())) {
            loss *= this.m_21124_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get()).m_19564_() + 1;
        }
        this.m_7197_(CrystallizedXPItem.withValue(this.f_36079_ - this.getLoss(loss)), true, false);
        this.f_36078_ = 0;
        this.f_36079_ = 0;
        this.f_36080_ = 0.0f;
    }

    public int getLoss(int loss) {
        int totalLoss = 0;
        for (int i = 1; i <= loss; ++i) {
            int level = this.f_36078_ - i;
            if (level >= 30) {
                totalLoss += 112 + (level - 30) * 9;
                continue;
            }
            totalLoss += level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
        }
        return Math.min(Math.abs(totalLoss), this.f_36079_);
    }

    @Shadow
    protected abstract void m_36345_();

    @Shadow
    public abstract ItemEntity m_7197_(ItemStack var1, boolean var2, boolean var3);

    @Shadow
    public abstract void m_6749_(int var1);
}

