/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.mixin;

import com.afunproject.dawncraft.capability.DCCapabilities;
import com.afunproject.dawncraft.capability.SageQuestTracker;
import com.afunproject.dawncraft.effects.DawnCraftEffects;
import com.afunproject.dawncraft.integration.epicfight.EpicFightCompat;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MixinMob
extends LivingEntity {
    public MixinMob(Level level) {
        super(null, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"isNoAi()Z"}, cancellable=true)
    public void dctweaks$isNoAi(CallbackInfoReturnable<Boolean> callback) {
        if (this.m_21023_((MobEffect)DawnCraftEffects.IMMOBILIZED.get())) {
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"interact(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, cancellable=true)
    public void dctweaks$interact(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> callback) {
        if (this instanceof Animal) {
            SageQuestTracker cap;
            if (ModList.get().isLoaded("epicfight") && EpicFightCompat.isCombatMode(player)) {
                return;
            }
            LazyOptional optional = player.getCapability(DCCapabilities.SAGE_QUEST_TRACKER);
            if (optional.isPresent() && (cap = (SageQuestTracker)optional.resolve().get()).isActive()) {
                cap.checkAnimal(player, (Animal)this);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canBeLeashed(Lnet/minecraft/world/entity/player/Player;)Z"}, cancellable=true)
    public void dctweaks$canBeLeashed(Player p_21418_, CallbackInfoReturnable<Boolean> callback) {
        if (this.m_6095_() == EntityType.f_20460_) {
            callback.setReturnValue((Object)false);
        }
    }
}

