/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.custom.quests.dc;

import com.afunproject.dawncraft.capability.DCCapabilities;
import com.afunproject.dawncraft.capability.SageQuestTracker;
import com.afunproject.dawncraft.integration.quests.custom.QuestEntity;
import com.afunproject.dawncraft.integration.quests.custom.QuestType;
import com.afunproject.dawncraft.integration.quests.custom.entity.QuestEntityBase;
import com.afunproject.dawncraft.integration.quests.custom.quests.Quest;
import net.mcreator.simplemobs.init.SimpleMobsModItems;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;

public class SageQuest
extends Quest {
    protected final int end_phase = 3;

    public SageQuest() {
        super((player, entity, phase, isTest) -> {
            LazyOptional optional = player.getCapability(DCCapabilities.SAGE_QUEST_TRACKER);
            if (optional.isPresent()) {
                return phase == 2 && ((SageQuestTracker)optional.resolve().get()).getCheckedCount() >= 10;
            }
            return false;
        });
    }

    @Override
    public void completeQuest(Player quest_completer, Mob entity, int phase, boolean accepted) {
        if (phase == 3) {
            LazyOptional optional;
            if (entity instanceof QuestEntityBase) {
                ((QuestEntityBase)entity).setDespawnable(true);
            }
            if ((optional = quest_completer.getCapability(DCCapabilities.SAGE_QUEST_TRACKER)).isPresent()) {
                ((SageQuestTracker)optional.resolve().get()).setActive(false);
            }
            this.giveItem(quest_completer, new ItemStack((ItemLike)SimpleMobsModItems.SHINY_KEY.get()));
            this.setPhase(entity, phase + 1);
        } else if (phase == 1 && accepted) {
            this.setPhase(entity, phase + 1);
            LazyOptional optional = quest_completer.getCapability(DCCapabilities.SAGE_QUEST_TRACKER);
            if (optional.isPresent()) {
                ((SageQuestTracker)optional.resolve().get()).setActive(true);
            }
        }
        if (entity instanceof QuestEntity) {
            ((QuestEntity)entity).setQuestText(this.getText(((QuestEntity)entity).getQuestPhase(), accepted));
        }
    }

    @Override
    public String getText(int phase, boolean accepted) {
        return "text.dawncraft.quest.sage" + phase;
    }

    @Override
    public QuestType getQuestType(int phase) {
        if (phase == 3) {
            return QuestType.AUTO_CLOSE;
        }
        if (phase % 2 == 1) {
            return QuestType.ACCEPT_QUEST;
        }
        return QuestType.DENY;
    }

    @Override
    public boolean isQuestActive(Mob entity, int phase) {
        return phase < 3;
    }
}

