/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.custom.quests.dc;

import com.afunproject.dawncraft.DCItemTags;
import com.afunproject.dawncraft.dungeon.item.DungeonItems;
import com.afunproject.dawncraft.integration.quests.custom.QuestEntity;
import com.afunproject.dawncraft.integration.quests.custom.QuestType;
import com.afunproject.dawncraft.integration.quests.custom.conditions.AndCondition;
import com.afunproject.dawncraft.integration.quests.custom.conditions.OrCondition;
import com.afunproject.dawncraft.integration.quests.custom.conditions.QuestCondition;
import com.afunproject.dawncraft.integration.quests.custom.conditions.TagCondition;
import com.afunproject.dawncraft.integration.quests.custom.entity.QuestEntityBase;
import com.afunproject.dawncraft.integration.quests.custom.quests.Quest;
import com.afunproject.dawncraft.integration.quests.network.OpenQuestMessage;
import com.afunproject.dawncraft.network.DCNetworkHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkDirection;

public class MonsterSlayerQuest
extends Quest {
    public MonsterSlayerQuest() {
        super(new OrCondition(MonsterSlayerQuest.getCondition(DCItemTags.LESSER_MONSTER_DROP, 2), MonsterSlayerQuest.getCondition(DCItemTags.GREATER_MONSTER_DROP, 4), MonsterSlayerQuest.getCondition(DCItemTags.MINIBOSS_MONSTER_DROP, 6)));
    }

    private static QuestCondition getCondition(TagKey<Item> tag, int i) {
        return new AndCondition((player, entity, phase, isTest) -> phase == i, new TagCondition(tag, 1, false));
    }

    @Override
    public void completeQuest(Player quest_completer, Mob entity, int phase, boolean accepted) {
        if (phase == -1) {
            QuestEntity.safeCast((Entity)entity).setQuestPhase(2);
        } else if (phase == 1 && accepted) {
            QuestEntity quest_entity = QuestEntity.safeCast((Entity)entity);
            quest_entity.setQuestPhase(-1);
            quest_entity.setQuestText("text.dawncraft.quest.monster_slayer1b");
            DCNetworkHandler.NETWORK_INSTANCE.sendTo((Object)new OpenQuestMessage(entity, this), ((ServerPlayer)quest_completer).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        } else if (accepted) {
            if (phase == 3) {
                this.giveItem(quest_completer, new ItemStack((ItemLike)Items.f_42616_, 3));
            } else if (phase == 5) {
                this.giveItem(quest_completer, new ItemStack((ItemLike)Items.f_42616_, 15));
            } else if (phase == 7) {
                this.giveItem(quest_completer, new ItemStack((ItemLike)Items.f_42616_, 54));
                this.giveItem(quest_completer, new ItemStack((ItemLike)DungeonItems.SLAYERS_BLADE.get()));
                if (entity instanceof QuestEntityBase) {
                    ((QuestEntityBase)entity).setDespawnable(true);
                }
            }
            this.setPhase(entity, phase + 1);
        }
        QuestEntity.safeCast((Entity)entity).setQuestText(this.getText(QuestEntity.safeCast((Entity)entity).getQuestPhase(), accepted));
    }

    @Override
    public QuestType getQuestType(int phase) {
        if (phase == -1) {
            return QuestType.AUTO_CLOSE;
        }
        if (phase == 7) {
            return QuestType.AUTO_CLOSE;
        }
        if (phase % 2 == 1) {
            return QuestType.ACCEPT_QUEST;
        }
        return QuestType.DENY;
    }

    @Override
    public String getText(int phase, boolean accepted) {
        return "text.dawncraft.quest.monster_slayer" + phase;
    }

    @Override
    public boolean isQuestActive(Mob entity, int phase) {
        return phase <= 7;
    }
}

