/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.custom.quests.dc;

import com.afunproject.dawncraft.integration.journeymap.JourneyMapEvents;
import com.afunproject.dawncraft.integration.quests.custom.QuestEntity;
import com.afunproject.dawncraft.integration.quests.custom.QuestType;
import com.afunproject.dawncraft.integration.quests.custom.entity.QuestEntityBase;
import com.afunproject.dawncraft.integration.quests.custom.quests.ItemQuest;
import com.afunproject.dawncraft.integration.quests.network.OpenQuestMessage;
import com.afunproject.dawncraft.network.DCNetworkHandler;
import net.mcreator.simplemobs.init.SimpleMobsModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkDirection;

public class CultQuest
extends ItemQuest {
    public CultQuest() {
        super(new ItemStack((ItemLike)Items.f_42516_), new ItemStack((ItemLike)SimpleMobsModItems.PLAGUEMASK_HELMET.get()));
    }

    @Override
    public void completeQuest(Player quest_completer, Mob entity, int phase, boolean accepted) {
        if (phase == -1) {
            QuestEntity.safeCast((Entity)entity).setQuestPhase(2);
        }
        if (phase == 1 && accepted) {
            QuestEntity quest_entity = QuestEntity.safeCast((Entity)entity);
            quest_entity.setQuestPhase(-1);
            quest_entity.setQuestText(this.getText() + "1b");
            DCNetworkHandler.NETWORK_INSTANCE.sendTo((Object)new OpenQuestMessage(entity, this), ((ServerPlayer)quest_completer).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        } else {
            super.completeQuest(quest_completer, entity, phase, accepted);
        }
    }

    @Override
    protected void completeItemQuest(Player quest_completer, Mob entity, int phase, boolean accepted) {
        ListTag tag;
        ItemStack map;
        BlockPos pos;
        if (phase == 3) {
            pos = this.findStructure((ServerLevel)quest_completer.f_19853_, new ResourceLocation("custom:church"), quest_completer.m_142538_());
            map = this.createMap((ServerLevel)quest_completer.f_19853_, pos);
            map.m_41714_((Component)new TranslatableComponent("map.dawncraft.cultist"));
            tag = new ListTag();
            tag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TranslatableComponent("map.dawncraft.cultist.lore"))));
            map.m_41700_("Lore", (Tag)tag);
            this.giveItem(quest_completer, map);
            if (ModList.get().isLoaded("journeymap")) {
                JourneyMapEvents.addWaypoint(pos, "waypoint.dawncraft.cultist", (ServerPlayer)quest_completer);
            }
        }
        if (phase == this.end_phase) {
            if (entity instanceof QuestEntityBase) {
                ((QuestEntityBase)entity).setDespawnable(true);
            }
            pos = this.findStructure((ServerLevel)quest_completer.f_19853_, new ResourceLocation("custom:church_father"), quest_completer.m_142538_());
            map = this.createMap((ServerLevel)quest_completer.f_19853_, pos);
            map.m_41714_((Component)new TranslatableComponent("map.dawncraft.cultist_2"));
            tag = new ListTag();
            tag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TranslatableComponent("map.dawncraft.cultist_2.lore"))));
            map.m_41700_("Lore", (Tag)tag);
            this.giveItem(quest_completer, map);
            if (ModList.get().isLoaded("journeymap")) {
                JourneyMapEvents.addWaypoint(pos, "waypoint.dawncraft.cultist_2", (ServerPlayer)quest_completer);
            }
        }
    }

    @Override
    public QuestType getQuestType(int phase) {
        if (phase == -1) {
            return QuestType.AUTO_CLOSE;
        }
        return super.getQuestType(phase);
    }

    @Override
    protected String getText() {
        return "text.dawncraft.quest.cult";
    }
}

