/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.custom.quests.dc;

import com.afunproject.dawncraft.integration.quests.custom.QuestEntity;
import com.afunproject.dawncraft.integration.quests.custom.QuestType;
import com.afunproject.dawncraft.integration.quests.custom.conditions.AndCondition;
import com.afunproject.dawncraft.integration.quests.custom.conditions.ItemCondition;
import com.afunproject.dawncraft.integration.quests.custom.quests.Quest;
import com.afunproject.dawncraft.integration.quests.network.OpenQuestMessage;
import com.afunproject.dawncraft.network.DCNetworkHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkDirection;

public class AlchemistQuest
extends Quest {
    public AlchemistQuest() {
        super(new AndCondition((player, entity, phase, isTest) -> phase != -1, new ItemCondition(new ItemStack((ItemLike)Items.f_42616_))));
    }

    @Override
    public void completeQuest(Player quest_completer, Mob entity, int phase, boolean accepted) {
        if (phase != -1 && accepted && this.isQuestComplete(quest_completer, entity, -2)) {
            QuestEntity.safeCast((Entity)entity).setQuestText(this.getText(-1, true));
            this.setPhase(entity, -1);
            if (quest_completer instanceof ServerPlayer) {
                DCNetworkHandler.NETWORK_INSTANCE.sendTo((Object)new OpenQuestMessage(entity, this), ((ServerPlayer)quest_completer).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @Override
    public boolean isQuestComplete(Player player, Mob entity, int phase) {
        if (phase != -2) {
            return false;
        }
        return super.isQuestComplete(player, entity, phase);
    }

    @Override
    public String getText(int phase, boolean accepted) {
        return phase == -1 ? "text.dawncraft.quest.alchemist.bloodthirst\u00a6text.dawncraft.quest.alchemist.withering\u00a6text.dawncraft.quest.alchemist.endurance" : "text.dawncraft.quest.alchemist";
    }

    @Override
    public QuestType getQuestType(int phase) {
        return phase == -1 ? QuestType.OPTIONS : QuestType.ACCEPT_QUEST;
    }

    @Override
    public boolean isQuestActive(Mob entity, int phase) {
        return true;
    }
}

