/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.custom.quests;

import com.afunproject.dawncraft.integration.quests.custom.QuestEntity;
import com.afunproject.dawncraft.integration.quests.custom.QuestType;
import com.afunproject.dawncraft.integration.quests.custom.conditions.AndCondition;
import com.afunproject.dawncraft.integration.quests.custom.conditions.TagCondition;
import com.afunproject.dawncraft.integration.quests.custom.quests.Quest;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public abstract class ItemTagQuest
extends Quest {
    protected final int end_phase;

    public ItemTagQuest(TagKey<Item> tag, int count) {
        super(new AndCondition((player, entity, phase, isTest) -> phase == 2), new TagCondition(tag, count));
        this.end_phase = 3;
    }

    @Override
    public void completeQuest(Player quest_completer, Mob entity, int phase, boolean accepted) {
        if (phase == this.end_phase) {
            this.completeItemQuest(quest_completer, entity, phase, accepted);
        } else if (phase % 2 == 1 && accepted) {
            this.setPhase(entity, phase + 1);
            this.completeItemQuest(quest_completer, entity, phase, accepted);
        }
        QuestEntity.safeCast((Entity)entity).setQuestText(this.getText(QuestEntity.safeCast((Entity)entity).getQuestPhase(), accepted));
    }

    @Override
    public String getText(int phase, boolean accepted) {
        return this.getText() + phase;
    }

    @Override
    public QuestType getQuestType(int phase) {
        if (phase == this.end_phase) {
            return QuestType.AUTO_CLOSE;
        }
        if (phase % 2 == 1) {
            return QuestType.ACCEPT_QUEST;
        }
        return QuestType.DENY;
    }

    @Override
    public boolean isQuestActive(Mob entity, int phase) {
        return true;
    }

    protected abstract void completeItemQuest(Player var1, Mob var2, int var3, boolean var4);

    protected abstract String getText();
}

