/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.custom.entity;

import com.afunproject.dawncraft.integration.epicfight.EpicFightCompat;
import com.afunproject.dawncraft.integration.quests.custom.QuestEntity;
import com.afunproject.dawncraft.integration.quests.custom.quests.Quest;
import com.afunproject.dawncraft.integration.quests.custom.quests.QuestsRegistry;
import com.afunproject.dawncraft.integration.quests.network.OpenQuestMessage;
import com.afunproject.dawncraft.network.DCNetworkHandler;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkDirection;

public abstract class QuestEntityBase
extends Mob
implements QuestEntity {
    protected static final EntityDataAccessor<String> TEXT = SynchedEntityData.m_135353_(QuestEntityBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<Integer> QUEST_PHASE = SynchedEntityData.m_135353_(QuestEntityBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<String> QUEST = SynchedEntityData.m_135353_(QuestEntityBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected boolean damageable;
    private boolean shouldDespawn;

    protected QuestEntityBase(EntityType<? extends Mob> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f, 0.02f, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TEXT, (Object)"");
        this.f_19804_.m_135372_(QUEST_PHASE, (Object)1);
        this.f_19804_.m_135372_(QUEST, (Object)"");
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Quest quest;
        if (player.m_36341_()) {
            return super.m_6071_(player, hand);
        }
        if (ModList.get().isLoaded("epicfight") && EpicFightCompat.isCombatMode(player)) {
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer && this.canSeeQuest() && (quest = this.getCurrentQuest()) != null) {
            if (!quest.isQuestActive(this, (Integer)this.f_19804_.m_135370_(QUEST_PHASE))) {
                return InteractionResult.PASS;
            }
            if (quest.isQuestComplete(player, this, (Integer)this.f_19804_.m_135370_(QUEST_PHASE))) {
                this.f_19804_.m_135381_(QUEST_PHASE, (Object)((Integer)this.f_19804_.m_135370_(QUEST_PHASE) + 1));
                this.setQuestText(quest.getText((Integer)this.f_19804_.m_135370_(QUEST_PHASE), true));
            }
            DCNetworkHandler.NETWORK_INSTANCE.sendTo((Object)new OpenQuestMessage(this, quest), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        return InteractionResult.PASS;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_6138_() {
        List entities = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), entity -> !this.m_20365_((Entity)entity) && !entity.m_5833_() && entity.m_6094_());
        for (Entity entity2 : entities) {
            this.m_7324_(entity2);
        }
    }

    public void m_5997_(double x, double y, double z) {
    }

    public boolean m_21532_() {
        return !this.shouldDespawn;
    }

    public boolean m_6785_(double range) {
        return range >= 50.0 && this.shouldDespawn;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result;
        boolean bl = result = this.damageable || source == DamageSource.f_19317_ ? super.m_6469_(source, amount) : false;
        if (this.damageable && this.getCurrentQuest() != null) {
            this.getCurrentQuest().onHurt(this, source);
        }
        return result;
    }

    public void m_6667_(DamageSource source) {
        if (this.getCurrentQuest() != null) {
            this.getCurrentQuest().onDeath(this, source);
        }
    }

    public boolean m_7313_(Entity entity) {
        return !this.damageable;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("damageable", this.damageable);
        compound.m_128379_("shouldDespawn", this.shouldDespawn);
        this.saveQuestData(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("damageable")) {
            this.damageable = compound.m_128471_("damageable");
        }
        if (compound.m_128441_("shouldDespawn")) {
            this.shouldDespawn = compound.m_128471_("shouldDespawn");
        }
        this.loadQuestData(compound);
    }

    public static AttributeSupplier createDefaultAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22278_, 100.0);
        return builder.m_22265_();
    }

    @Override
    public Quest getCurrentQuest() {
        try {
            return QuestsRegistry.getQuest(new ResourceLocation((String)this.f_19804_.m_135370_(QUEST)));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getQuestPhase() {
        return (Integer)this.f_19804_.m_135370_(QUEST_PHASE);
    }

    @Override
    public String getQuestText() {
        return (String)this.f_19804_.m_135370_(TEXT);
    }

    @Override
    public void setQuestPhase(int phase) {
        this.f_19804_.m_135381_(QUEST_PHASE, (Object)phase);
    }

    @Override
    public void setQuest(Quest quest) {
        if (quest == null) {
            this.f_19804_.m_135381_(QUEST, (Object)"");
        } else {
            this.f_19804_.m_135381_(QUEST, (Object)quest.getRegistryName().toString());
        }
    }

    @Override
    public void setQuestText(String text) {
        this.f_19804_.m_135381_(TEXT, (Object)text);
    }

    @Override
    public CompoundTag saveQuestData(CompoundTag tag) {
        tag.m_128359_("text", (String)this.f_19804_.m_135370_(TEXT));
        tag.m_128405_("quest_phase", ((Integer)this.f_19804_.m_135370_(QUEST_PHASE)).intValue());
        if (this.getCurrentQuest() != null) {
            tag.m_128359_("quest", this.getCurrentQuest().getRegistryName().toString());
        }
        return tag;
    }

    @Override
    public void loadQuestData(CompoundTag tag) {
        if (tag.m_128441_("text")) {
            this.f_19804_.m_135381_(TEXT, (Object)tag.m_128461_("text"));
        }
        if (tag.m_128441_("quest_phase")) {
            this.f_19804_.m_135381_(QUEST_PHASE, (Object)tag.m_128451_("quest_phase"));
        }
        if (tag.m_128441_("quest")) {
            this.setQuest(QuestsRegistry.getQuest(new ResourceLocation(tag.m_128461_("quest"))));
            if (this.getCurrentQuest() != null) {
                this.f_19804_.m_135381_(TEXT, (Object)this.getCurrentQuest().getText((Integer)this.f_19804_.m_135370_(QUEST_PHASE), true));
            }
        }
    }

    public void setDespawnable(boolean shouldDespawn) {
        this.shouldDespawn = shouldDespawn;
    }
}

