/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.custom.conditions;

import com.afunproject.dawncraft.DawnCraft;
import com.afunproject.dawncraft.integration.quests.custom.conditions.QuestCondition;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TagCondition
implements QuestCondition {
    protected TagKey<Item> tag;
    protected int count;
    protected boolean consume;

    public TagCondition(TagKey<Item> tag) {
        this(tag, 1, true);
    }

    public TagCondition(TagKey<Item> tag, int count) {
        this(tag, count, true);
    }

    public TagCondition(TagKey<Item> tag, int count, boolean consume) {
        this.tag = tag;
        this.count = count;
        this.consume = consume;
    }

    @Override
    public boolean apply(Player player, Mob entity, int phase, boolean isTest) {
        ArrayList stacks = Lists.newArrayList();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!(stack.m_204117_(this.tag) & !this.contains(stacks, stack))) continue;
            stacks.add(stack);
            if (stacks.size() < this.count) continue;
            break;
        }
        if (stacks.size() >= this.count) {
            if (!isTest && this.consume) {
                for (ItemStack stack : stacks) {
                    stack.m_41774_(1);
                }
                player.m_5496_(SoundEvents.f_12275_, 0.5f, 0.5f);
            }
            return true;
        }
        DawnCraft.logInfo(stacks.size() + " items found of required " + this.count);
        return false;
    }

    public boolean contains(List<ItemStack> stacks, ItemStack stack) {
        for (ItemStack stack1 : stacks) {
            if (stack1.m_41720_() != stack.m_41720_()) continue;
            return true;
        }
        return false;
    }
}

