/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.client;

import com.afunproject.dawncraft.client.ClientEventRegister;
import com.afunproject.dawncraft.client.entity.FallenRenderer;
import com.afunproject.dawncraft.client.entity.PlayerEntityRenderer;
import com.afunproject.dawncraft.integration.quests.client.screens.QuestScreen;
import com.afunproject.dawncraft.integration.quests.custom.QuestEntity;
import com.afunproject.dawncraft.integration.quests.custom.QuestType;
import com.afunproject.dawncraft.integration.quests.custom.entity.QuestEntities;
import com.afunproject.dawncraft.integration.quests.custom.entity.QuestEntityBase;
import com.afunproject.dawncraft.integration.quests.custom.quests.Quest;
import com.afunproject.dawncraft.integration.quests.network.OpenQuestMessage;
import com.feywild.quest_giver.util.RenderEnum;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.mcreator.simplemobs.entity.KorokIntroEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class QuestClientEvents {
    private static final double MAX_DISTANCE = 64.0;
    private static final int Y_POS = -18;
    private static final int X_POS = -8;

    public static void init() {
        MinecraftForge.EVENT_BUS.register(QuestClientEvents.class);
        ClientEventRegister.RENDERER_REGISTERS.add(QuestClientEvents::registerEntityRenderers);
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)QuestEntities.FALLEN_ADVENTURER.get(), FallenRenderer::new);
        event.registerEntityRenderer((EntityType)QuestEntities.QUEST_PLAYER.get(), PlayerEntityRenderer::new);
    }

    public static void openQuestGUI(OpenQuestMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        Mob mob = message.get((Level)mc.f_91073_);
        QuestEntity entity = QuestEntity.safeCast((Entity)mob);
        Quest quest = message.getQuest();
        QuestType type = quest == null ? QuestType.ACKNOWLEDGE : quest.getQuestType(message.getPhase() == 0 ? entity.getQuestPhase() : message.getPhase());
        String text = message.getMessage() == null ? entity.getQuestText() : message.getMessage();
        mc.m_91152_((Screen)new QuestScreen(mob, (MutableComponent)new TranslatableComponent(text, new Object[]{mc.f_91074_}), type));
    }

    @SubscribeEvent
    public static void onRenderNamePlate(RenderNameplateEvent event) {
        QuestEntityBase entity;
        Quest quest;
        Minecraft mc = Minecraft.m_91087_();
        if (event.getEntity() instanceof QuestEntityBase & !(event.getEntity() instanceof KorokIntroEntity) && (quest = (entity = (QuestEntityBase)event.getEntity()).getCurrentQuest()) != null && quest.isQuestActive(entity, entity.getQuestPhase()) & !(mc.f_91080_ instanceof QuestScreen)) {
            PoseStack poseStack = event.getPoseStack();
            EntityRenderDispatcher dispatcher = mc.m_91290_();
            double squareDistance = dispatcher.m_114471_((Entity)entity);
            double fadeDistance = 32.0;
            double opacityDistance = Mth.m_14008_((double)(1.0 - (Math.sqrt(squareDistance) - fadeDistance) / (64.0 - fadeDistance)), (double)0.0, (double)1.0);
            float markerHeight = entity.m_20206_() + 0.5f;
            if (squareDistance > 4096.0) {
                return;
            }
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)markerHeight, 0.0);
            poseStack.m_85845_(dispatcher.m_114470_());
            poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)opacityDistance));
            QuestClientEvents.renderMarker(RenderEnum.EXCLAMATION.getRender(), poseStack);
            RenderSystem.m_69461_();
            RenderSystem.m_69465_();
            poseStack.m_85849_();
        }
    }

    private static void renderMarker(ResourceLocation resource, PoseStack poseStack) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        QuestClientEvents.renderIcon(resource, poseStack);
        poseStack.m_85849_();
    }

    private static void renderIcon(ResourceLocation resource, PoseStack poseStack) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Minecraft.m_91087_().m_91097_().m_118506_(resource).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, -8.0f, -2.0f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, 8.0f, -2.0f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, 8.0f, -18.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, -8.0f, -18.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }
}

