/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.journeymap.client;

import com.afunproject.dawncraft.integration.epicfight.client.KeyToast;
import com.afunproject.dawncraft.integration.journeymap.network.AddWaypointMessage;
import com.afunproject.dawncraft.integration.journeymap.network.RemoveWaypointMessage;
import com.afunproject.dawncraft.integration.journeymap.network.WaypointMessage;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.display.WaypointGroup;
import journeymap.client.api.event.ClientEvent;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Items;

@ClientPlugin
public class JourneyMapPlugin
implements IClientPlugin {
    private static final WaypointGroup GROUP = new WaypointGroup("dawncraft", "structures");
    private static JourneyMapPlugin instance;
    private IClientAPI api;
    private List<WaypointMessage> scheduled = Lists.newArrayList();
    private KeyToast toast;
    private boolean startedMapping;

    public JourneyMapPlugin() {
        instance = this;
    }

    public void initialize(IClientAPI api) {
        this.api = api;
        api.subscribe("dawncraft", EnumSet.of(ClientEvent.Type.MAPPING_STARTED, ClientEvent.Type.DISPLAY_UPDATE));
    }

    public String getModId() {
        return "dawncraft";
    }

    public void onEvent(ClientEvent clientEvent) {
        if (clientEvent.type == ClientEvent.Type.MAPPING_STARTED) {
            this.startedMapping = true;
            for (WaypointMessage message : this.scheduled) {
                if (message instanceof AddWaypointMessage) {
                    this.addWaypoint((AddWaypointMessage)message, false);
                }
                if (!(message instanceof RemoveWaypointMessage)) continue;
                this.removeWaypoint(message);
            }
            this.scheduled.clear();
        }
        if (clientEvent.type == ClientEvent.Type.DISPLAY_UPDATE && this.toast != null) {
            this.toast.setPressed();
        }
    }

    public void addWaypoint(AddWaypointMessage message, boolean sendMessage) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (sendMessage) {
            player.m_6352_((Component)new TranslatableComponent("message.dawncraft.waypoint", new Object[]{message.getStructure()}), null);
        }
        if (this.startedMapping) {
            try {
                BlockPos pos = message.getPos();
                ResourceKey dim = player.f_19853_.m_46472_();
                Waypoint waypoint = new Waypoint("dawncraft", "dc-" + message.getStructure(), message.getStructure(), dim, pos);
                waypoint.setColor(0xFFFFFF);
                waypoint.setGroup(GROUP);
                this.api.show((Displayable)waypoint);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.scheduled.add(message);
        }
    }

    public void removeWaypoint(WaypointMessage message) {
        if (this.startedMapping) {
            Waypoint waypoint = this.api.getWaypoint("dawncraft", "dc-" + message.getStructure());
            if (waypoint != null) {
                this.api.remove((Displayable)waypoint);
            }
        } else {
            this.scheduled.add(message);
        }
    }

    public static JourneyMapPlugin getInstance() {
        return instance;
    }

    public void displayToast(ToastComponent toasts) {
        this.toast = new KeyToast("toasts.dawncraft.map", (KeyMapping)JourneymapClient.getInstance().getKeyEvents().getHandler().kbFullscreenToggle, Items.f_42573_);
        toasts.m_94922_((Toast)this.toast);
    }
}

