/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.journeymap;

import com.afunproject.dawncraft.event.DCSubCommandsEvent;
import com.afunproject.dawncraft.integration.journeymap.client.JourneyMapPlugin;
import com.afunproject.dawncraft.integration.journeymap.network.AddWaypointMessage;
import com.afunproject.dawncraft.integration.journeymap.network.RemoveWaypointMessage;
import com.afunproject.dawncraft.network.DCNetworkHandler;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.smileycorp.atlas.api.network.NetworkUtils;

public class JourneyMapEvents {
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new JourneyMapEvents());
        NetworkUtils.registerMessage((SimpleChannel)DCNetworkHandler.NETWORK_INSTANCE, (int)5, AddWaypointMessage.class, JourneyMapEvents::receivePacket);
        NetworkUtils.registerMessage((SimpleChannel)DCNetworkHandler.NETWORK_INSTANCE, (int)6, RemoveWaypointMessage.class, JourneyMapEvents::receivePacket);
    }

    @SubscribeEvent
    public void registerSubCommands(DCSubCommandsEvent event) {
        event.addSubCommand((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"addWaypoint").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"structure", (ArgumentType)ResourceOrTagLocationArgument.m_210968_((ResourceKey)Registry.f_122882_)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::addWaypoint))))));
        event.addSubCommand((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"removeWaypoint").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::removeWaypoint)))));
    }

    private int addWaypoint(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ResourceOrTagLocationArgument.Result result = ResourceOrTagLocationArgument.m_210970_(ctx, (String)"structure");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        Registry registry = level.m_5962_().m_175515_(Registry.f_122882_);
        HolderSet holderset = (HolderSet)((Optional)result.m_207418_().map(rk -> registry.m_203636_(rk).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})), arg_0 -> ((Registry)registry).m_203431_(arg_0))).orElseThrow(() -> ((SimpleCommandExceptionType)new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.locate.invalid", new Object[]{result.m_207276_()}))).create());
        Pair pair = level.m_7726_().m_8481_().m_207970_(level, holderset, new BlockPos(((CommandSourceStack)ctx.getSource()).m_81371_()), 100, false);
        if (pair == null) {
            throw new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.locate.failed", new Object[]{result.m_207276_()})).create();
        }
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            JourneyMapEvents.addWaypoint((BlockPos)pair.getFirst(), StringArgumentType.getString(ctx, (String)"name"), player);
        }
        return 1;
    }

    public static void addWaypoint(BlockPos pos, String name, ServerPlayer player) {
        DCNetworkHandler.NETWORK_INSTANCE.sendTo((Object)new AddWaypointMessage(player.m_183503_().m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos), name), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private int removeWaypoint(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            JourneyMapEvents.removeWaypoint(StringArgumentType.getString(ctx, (String)"name"), player);
        }
        return 1;
    }

    public static void removeWaypoint(String name, ServerPlayer player) {
        DCNetworkHandler.NETWORK_INSTANCE.sendTo((Object)new RemoveWaypointMessage(name), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static void receivePacket(AddWaypointMessage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> JourneyMapPlugin.getInstance().addWaypoint(message, true)));
    }

    private static void receivePacket(RemoveWaypointMessage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> JourneyMapPlugin.getInstance().removeWaypoint(message)));
    }
}

