/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.humancompanions.entities;

import com.afunproject.dawncraft.entities.PlayerEntity;
import com.github.justinwon777.humancompanions.entity.Knight;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public class KnightPlayer
extends Knight
implements PlayerEntity {
    protected static final EntityDataAccessor<Optional<UUID>> PLAYER = SynchedEntityData.m_135353_(KnightPlayer.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    protected KnightPlayer(EntityType<? extends Knight> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PLAYER, Optional.empty());
    }

    public void setPlayer(String username) {
        Optional optional = ServerLifecycleHooks.getCurrentServer().m_129927_().m_10996_(username);
        if (optional.isPresent()) {
            this.setPlayer((GameProfile)optional.get());
        }
    }

    public void setPlayer(UUID uuid) {
        Optional optional = ServerLifecycleHooks.getCurrentServer().m_129927_().m_11002_(uuid);
        if (optional.isPresent()) {
            this.setPlayer((GameProfile)optional.get());
        }
    }

    public void setPlayer(GameProfile profile) {
        if (profile.getName() != null) {
            this.m_6593_((Component)new TextComponent(profile.getName()));
        }
        this.f_19804_.m_135381_(PLAYER, Optional.of(profile.getId()));
    }

    @Override
    public Optional<UUID> getPlayerUUID() {
        return (Optional)this.f_19804_.m_135370_(PLAYER);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("username")) {
            this.setPlayer(compound.m_128461_("username"));
        }
        if (compound.m_128441_("player_uuid")) {
            this.setPlayer(UUID.fromString(compound.m_128461_("player_uuid")));
        }
        if (compound.m_128441_("player")) {
            this.f_19804_.m_135381_(PLAYER, Optional.of(compound.m_128342_("player")));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        Optional optional = (Optional)this.f_19804_.m_135370_(PLAYER);
        if (optional.isPresent()) {
            compound.m_128362_("player", (UUID)optional.get());
        }
    }
}

