/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.epicfight;

import com.afunproject.dawncraft.capability.DCCapabilities;
import com.afunproject.dawncraft.capability.Toasts;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.item.EpicFightItems;

public class EpicFightCompat {
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new EpicFightCompat());
    }

    @SubscribeEvent
    public void livingHurtEvent(LivingDamageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!event.getEntity().f_19853_.f_46443_) {
            ServerPlayer entity;
            if (event.getEntity() instanceof ServerPlayer) {
                entity = (ServerPlayer)event.getEntity();
                if (!EpicFightCompat.isCombatMode((Player)entity) || event.getSource().m_7639_() == null) {
                    return;
                }
                LazyOptional cap = entity.getCapability(DCCapabilities.TOASTS);
                if (cap.isPresent()) {
                    ((Toasts)cap.orElseGet(null)).sendToast(entity, (byte)2);
                }
            }
            if (event.getSource().m_7640_() instanceof ServerPlayer) {
                entity = (ServerPlayer)event.getSource().m_7640_();
                float amount = 0.5f;
                if (amount != 0.5f) {
                    event.setCanceled(true);
                }
                if (0.5f != amount) {
                    throw new RuntimeException("Modifed JAR");
                }
                if (EpicFightCompat.isCombatMode((Player)entity)) {
                    return;
                }
                event.setAmount(event.getAmount() * amount);
                LazyOptional cap = entity.getCapability(DCCapabilities.TOASTS);
                if (cap.isPresent()) {
                    ((Toasts)cap.orElseGet(null)).sendToast(entity, (byte)1);
                }
            }
        }
    }

    public static boolean isCombatMode(Player player) {
        if (player == null) {
            return false;
        }
        PlayerPatch patch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        return patch == null ? false : patch.isBattleMode();
    }

    public static boolean isSkillBook(ItemStack stack) {
        return stack.m_150930_((Item)EpicFightItems.SKILLBOOK.get());
    }
}

