/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.dungeon.item;

import com.afunproject.dawncraft.CreativeTabs;
import com.afunproject.dawncraft.dungeon.item.DungeonItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CrystallizedXPItem
extends Item {
    public CrystallizedXPItem() {
        super(new Item.Properties().m_41491_(CreativeTabs.DUNGEON_ITEMS).m_41497_(Rarity.UNCOMMON));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player == null) {
            return InteractionResultHolder.m_19098_((Object)ItemStack.f_41583_);
        }
        ItemStack stack = player.m_21120_(hand);
        int value = CrystallizedXPItem.getValue(stack);
        if (value <= 0) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (level.m_5776_()) {
            player.m_5496_(SoundEvents.f_11871_, 0.5f, 1.0f);
        } else {
            int count = player.m_6047_() ? 1 : stack.m_41613_();
            player.m_6756_(value * count);
            stack.m_41774_(count);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag flag) {
        int value = CrystallizedXPItem.getValue(stack);
        if (value <= 0) {
            return;
        }
        lines.add((Component)new TranslatableComponent("tooltip.dawncraft.crystallized_xp_0", new Object[]{value}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)11201874))));
        lines.add((Component)new TranslatableComponent("tooltip.dawncraft.crystallized_xp_1"));
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab)) {
            items.add((Object)CrystallizedXPItem.withValue(1));
            items.add((Object)CrystallizedXPItem.withValue(5));
            items.add((Object)CrystallizedXPItem.withValue(10));
            items.add((Object)CrystallizedXPItem.withValue(50));
            items.add((Object)CrystallizedXPItem.withValue(100));
            items.add((Object)CrystallizedXPItem.withValue(500));
            items.add((Object)CrystallizedXPItem.withValue(1000));
        }
    }

    public static int getValue(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        CompoundTag tag = stack.m_41783_();
        return tag.m_128441_("value") ? tag.m_128451_("value") : 0;
    }

    public static ItemStack withValue(int value) {
        if (value <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)DungeonItems.CRYSTALLIZED_XP.get());
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("value", value);
        return stack;
    }
}

