/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.dungeon.block;

import com.afunproject.dawncraft.dungeon.KeyColour;
import com.afunproject.dawncraft.dungeon.block.LockedBlock;
import com.afunproject.dawncraft.dungeon.block.entity.DungeonDoorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DungeonDoorBlock
extends Block
implements LockedBlock,
EntityBlock {
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.m_61594_((String)"axis", Direction.Axis.class, axis -> axis != Direction.Axis.Y);
    protected static final VoxelShape X = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Z = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);

    public DungeonDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{AXIS});
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? Z : X;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? Z : X;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? Z : X;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ray) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? Z : X;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction dir : context.m_6232_()) {
            if (dir.m_122434_() == Direction.Axis.Y) continue;
            return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)dir.m_122434_());
        }
        return this.m_49966_();
    }

    @Override
    public KeyColour getColour(Level level, BlockPos pos, BlockBehaviour.BlockStateBase state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DungeonDoorBlockEntity) {
            return ((DungeonDoorBlockEntity)blockEntity).getLockColour();
        }
        return null;
    }

    @Override
    public boolean open(Level level, BlockPos pos, BlockBehaviour.BlockStateBase state, boolean isKey) {
        if (level.m_7702_(pos) instanceof DungeonDoorBlockEntity) {
            ((DungeonDoorBlockEntity)level.m_7702_(pos)).unlock();
            ((DungeonDoorBlockEntity)level.m_7702_(pos)).open();
        }
        for (Direction dir : Direction.values()) {
            BlockPos new_pos;
            BlockState other_state;
            if (dir.m_122434_() == state.m_61143_(AXIS) || (other_state = level.m_8055_(new_pos = pos.m_142300_(dir))).m_60734_() != state.m_60734_() || other_state.m_61143_(AXIS) != state.m_61143_(AXIS)) continue;
            ((DungeonDoorBlock)other_state.m_60734_()).open(level, new_pos, (BlockBehaviour.BlockStateBase)other_state, false);
        }
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DungeonDoorBlockEntity(pos, state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case X: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }
}

