/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.client.entity;

import com.afunproject.dawncraft.entities.PlayerEntity;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.smileycorp.atlas.api.client.PlayerTextureRenderer;

public class PlayerEntityRenderer<T extends Mob>
extends HumanoidMobRenderer<T, HumanoidModel<T>> {
    public static ModelLayerLocation DEFAULT = new ModelLayerLocation(new ResourceLocation("dawncraft", "player_entity"), "default");
    public static ModelLayerLocation SLIM = new ModelLayerLocation(new ResourceLocation("dawncraft", "player_entity"), "slim");
    protected final HumanoidModel<T> defaultModel;
    protected final HumanoidModel<T> slimModel;

    public PlayerEntityRenderer(EntityRendererProvider.Context ctx) {
        this(ctx, new HumanoidModel(ctx.m_174023_(DEFAULT)), new HumanoidModel(ctx.m_174023_(SLIM)));
    }

    public PlayerEntityRenderer(EntityRendererProvider.Context ctx, HumanoidModel<T> defaultModel, HumanoidModel<T> slimModel) {
        super(ctx, defaultModel, 0.5f);
        this.defaultModel = defaultModel;
        this.slimModel = slimModel;
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(ctx.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(ctx.m_174023_(ModelLayers.f_171165_))));
    }

    public ResourceLocation m_5478_(T entity) {
        Optional<UUID> optional = ((PlayerEntity)entity).getPlayerUUID();
        return PlayerTextureRenderer.getTexture(optional, (MinecraftProfileTexture.Type)MinecraftProfileTexture.Type.SKIN);
    }

    public void m_7392_(T entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        boolean isSlim;
        Optional<UUID> optional = ((PlayerEntity)entity).getPlayerUUID();
        String skinType = PlayerTextureRenderer.getSkinType(optional);
        boolean bl = isSlim = skinType == null ? false : skinType.equals("slim");
        if (isSlim && this.f_115290_ != this.slimModel) {
            this.f_115290_ = this.slimModel;
        } else if (!isSlim && this.f_115290_ != this.defaultModel) {
            this.f_115290_ = this.defaultModel;
        }
        super.m_7392_(entity, yaw, partialTicks, poseStack, bufferSource, packedLightIn);
    }

    public static LayerDefinition createLayer(boolean slim) {
        return LayerDefinition.m_171565_((MeshDefinition)PlayerEntityRenderer.createMesh(CubeDeformation.f_171458_, slim), (int)64, (int)64);
    }

    public static MeshDefinition createMesh(CubeDeformation p_170826_, boolean p_170827_) {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)p_170826_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("ear", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 1.0f, p_170826_), PartPose.f_171404_);
        partdefinition.m_171599_("cloak", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171496_(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, p_170826_, 1.0f, 0.5f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        if (p_170827_) {
            partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
        } else {
            partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
            partdefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
            partdefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        }
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_pants", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.m_171469_(0.25f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_pants", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.m_171469_(0.25f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170826_.m_171469_(0.25f)), PartPose.f_171404_);
        return meshdefinition;
    }
}

