/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.client;

import com.afunproject.dawncraft.Constants;
import com.afunproject.dawncraft.client.entity.FrogModel;
import com.afunproject.dawncraft.client.entity.FrogRenderer;
import com.afunproject.dawncraft.client.entity.PlayerEntityRenderer;
import com.afunproject.dawncraft.client.entity.RitualItemEntityRenderer;
import com.afunproject.dawncraft.client.render.blockentity.DungeonDoorBlockEntityRenderer;
import com.afunproject.dawncraft.dungeon.block.DungeonBlocks;
import com.afunproject.dawncraft.dungeon.block.entity.DungeonBlockEntities;
import com.afunproject.dawncraft.dungeon.item.DungeonItems;
import com.afunproject.dawncraft.dungeon.item.RebirthStaffItem;
import com.afunproject.dawncraft.entities.DawnCraftEntities;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.math.Transformation;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="dawncraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEventRegister {
    public static final List<Consumer<EntityRenderersEvent.RegisterRenderers>> RENDERER_REGISTERS = Lists.newArrayList();

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)DungeonBlocks.CHEST_SPAWNER.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)DungeonBlocks.REDSTONE_ACTIVATOR.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)DungeonBlocks.REDSTONE_TRIGGER.get()), (RenderType)RenderType.m_110457_());
            ItemProperties.register((Item)((Item)DungeonItems.REBIRTH_STAFF.get()), (ResourceLocation)Constants.loc("inert"), (stack, level, entity, i) -> RebirthStaffItem.isPowered(stack) ? 0.0f : 1.0f);
        });
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)DungeonBlockEntities.DUNGEON_DOOR.get(), DungeonDoorBlockEntityRenderer::new);
        for (Consumer<EntityRenderersEvent.RegisterRenderers> supplier : RENDERER_REGISTERS) {
            supplier.accept(event);
        }
        event.registerEntityRenderer((EntityType)DawnCraftEntities.RITUAL_ITEM.get(), RitualItemEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.AddLayers event) {
        FrogRenderer.init();
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(PlayerEntityRenderer.DEFAULT, () -> PlayerEntityRenderer.createLayer(false));
        event.registerLayerDefinition(PlayerEntityRenderer.SLIM, () -> PlayerEntityRenderer.createLayer(true));
        event.registerLayerDefinition(FrogRenderer.DEFAULT, FrogModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        ClientEventRegister.registerGUIModel("cursed_mask", registry);
    }

    public static void registerGUIModel(String name, Map<ResourceLocation, BakedModel> registry) {
        Minecraft mc = Minecraft.m_91087_();
        ResourceLocation loc = Constants.loc(name + "_gui");
        TextureAtlasSprite sprite = (TextureAtlasSprite)mc.m_91258_(TextureAtlas.f_118259_).apply(Constants.loc("item/" + name));
        BakedQuad quads = ItemTextureQuadConverter.genQuad((Transformation)Transformation.m_121093_(), (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.0f, (TextureAtlasSprite)sprite, (Direction)Direction.SOUTH, (int)-1, (int)2);
        ImmutableMap map = ImmutableMap.of((Object)ItemTransforms.TransformType.GUI, (Object)Transformation.m_121093_(), (Object)ItemTransforms.TransformType.NONE, (Object)Transformation.m_121093_());
        registry.put(loc, (BakedModel)new BakedItemModel(ImmutableList.of((Object)quads), sprite, map, ItemOverrides.f_111734_, false, true));
    }
}

